/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage.table;

import java.util.Date;
import java.util.UUID;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.Base64;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.Utility;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.table.EdmType;

public final class EntityProperty {
    private String value;
    private Class<?> type;
    private EdmType edmType = EdmType.NULL;
    private boolean isEncrypted = false;
    private boolean dateBackwardCompatibility = false;

    protected EntityProperty(String value, Class<?> type) {
        this.type = type;
        this.value = value;
        if (type.equals(byte[].class)) {
            this.getValueAsByteArray();
            this.edmType = EdmType.BINARY;
        } else if (type.equals(Byte[].class)) {
            this.getValueAsByteObjectArray();
            this.edmType = EdmType.BINARY;
        } else if (type.equals(String.class)) {
            this.edmType = EdmType.STRING;
        } else if (type.equals(Boolean.TYPE)) {
            this.getValueAsBoolean();
            this.edmType = EdmType.BOOLEAN;
        } else if (type.equals(Boolean.class)) {
            this.getValueAsBooleanObject();
            this.edmType = EdmType.BOOLEAN;
        } else if (type.equals(Date.class)) {
            this.getValueAsDate();
            this.edmType = EdmType.DATE_TIME;
        } else if (type.equals(Double.TYPE)) {
            this.getValueAsDouble();
            this.edmType = EdmType.DOUBLE;
        } else if (type.equals(Double.class)) {
            this.getValueAsDoubleObject();
            this.edmType = EdmType.DOUBLE;
        } else if (type.equals(UUID.class)) {
            this.getValueAsUUID();
            this.edmType = EdmType.GUID;
        } else if (type.equals(Integer.TYPE)) {
            this.getValueAsInteger();
            this.edmType = EdmType.INT32;
        } else if (type.equals(Integer.class)) {
            this.getValueAsIntegerObject();
            this.edmType = EdmType.INT32;
        } else if (type.equals(Long.TYPE)) {
            this.getValueAsLong();
            this.edmType = EdmType.INT64;
        } else if (type.equals(Long.class)) {
            this.getValueAsLongObject();
            this.edmType = EdmType.INT64;
        } else {
            throw new IllegalArgumentException(String.format("Type %s is not supported.", type.toString()));
        }
    }

    protected EntityProperty(Object value, Class<?> type) {
        if (type.equals(byte[].class)) {
            this.setValue((byte[])value);
            this.type = type;
        } else if (type.equals(Byte[].class)) {
            this.setValue((Byte[])value);
            this.type = type;
        } else if (type.equals(String.class)) {
            this.setValue((String)value);
            this.type = type;
        } else if (type.equals(Boolean.TYPE)) {
            this.setValue((boolean)((Boolean)value));
            this.type = type;
        } else if (type.equals(Boolean.class)) {
            this.setValue((Boolean)value);
            this.type = type;
        } else if (type.equals(Double.TYPE)) {
            this.setValue((double)((Double)value));
            this.type = type;
        } else if (type.equals(Double.class)) {
            this.setValue((Double)value);
            this.type = type;
        } else if (type.equals(UUID.class)) {
            this.setValue((UUID)value);
            this.type = type;
        } else if (type.equals(Integer.TYPE)) {
            this.setValue((int)((Integer)value));
            this.type = type;
        } else if (type.equals(Integer.class)) {
            this.setValue((Integer)value);
            this.type = type;
        } else if (type.equals(Long.TYPE)) {
            this.setValue((long)((Long)value));
            this.type = type;
        } else if (type.equals(Long.class)) {
            this.setValue((Long)value);
            this.type = type;
        } else if (type.equals(Date.class)) {
            this.setValue((Date)value);
            this.type = type;
        } else {
            throw new IllegalArgumentException(String.format("Type %s is not supported.", type.toString()));
        }
    }

    protected EntityProperty(String value, EdmType edmType) {
        this.edmType = edmType;
        this.value = value;
        if (edmType == EdmType.STRING) {
            this.type = String.class;
            return;
        }
        if (edmType == EdmType.BINARY) {
            this.getValueAsByteArray();
            this.type = Byte[].class;
        } else if (edmType == EdmType.BOOLEAN) {
            this.getValueAsBoolean();
            this.type = Boolean.class;
        } else if (edmType == EdmType.DOUBLE) {
            this.getValueAsDouble();
            this.type = Double.class;
        } else if (edmType == EdmType.GUID) {
            this.getValueAsUUID();
            this.type = UUID.class;
        } else if (edmType == EdmType.INT32) {
            this.getValueAsInteger();
            this.type = Integer.class;
        } else if (edmType == EdmType.INT64) {
            this.getValueAsLong();
            this.type = Long.class;
        } else if (edmType == EdmType.DATE_TIME) {
            this.getValueAsDate();
            this.type = Date.class;
        } else {
            if (edmType == null) {
                throw new IllegalArgumentException("EdmType cannot be null.");
            }
            throw new IllegalArgumentException(String.format("Invalid value '%s' for EdmType.", edmType.toString()));
        }
    }

    public EntityProperty(boolean value) {
        this.setValue(value);
    }

    public EntityProperty(Boolean value) {
        this.setValue(value);
    }

    public EntityProperty(byte[] value) {
        this.setValue(value);
    }

    public EntityProperty(Byte[] value) {
        this.setValue(value);
    }

    public EntityProperty(Date value) {
        this.setValue(value);
    }

    public EntityProperty(double value) {
        this.setValue(value);
    }

    public EntityProperty(Double value) {
        this.setValue(value);
    }

    public EntityProperty(int value) {
        this.setValue(value);
    }

    public EntityProperty(Integer value) {
        this.setValue(value);
    }

    public EntityProperty(long value) {
        this.setValue(value);
    }

    public EntityProperty(Long value) {
        this.setValue(value);
    }

    public EntityProperty(String value) {
        this.setValue(value);
    }

    public EntityProperty(UUID value) {
        this.setValue(value);
    }

    public EdmType getEdmType() {
        return this.edmType;
    }

    public boolean getIsNull() {
        return this.value == null;
    }

    public Class<?> getType() {
        return this.type;
    }

    protected boolean isEncrypted() {
        return this.isEncrypted;
    }

    public boolean getValueAsBoolean() {
        if (this.getIsNull()) {
            throw new IllegalArgumentException("EntityProperty cannot be set to null for primitive value types.");
        }
        return Boolean.parseBoolean(this.value);
    }

    public Boolean getValueAsBooleanObject() {
        if (this.getIsNull()) {
            return null;
        }
        return Boolean.parseBoolean(this.value);
    }

    public byte[] getValueAsByteArray() {
        return this.getIsNull() ? null : Base64.decode(this.value);
    }

    public Byte[] getValueAsByteObjectArray() {
        return this.getIsNull() ? null : Base64.decodeAsByteObjectArray(this.value);
    }

    public Date getValueAsDate() {
        return this.getIsNull() ? null : Utility.parseDate(this.value, this.dateBackwardCompatibility);
    }

    public double getValueAsDouble() {
        if (this.getIsNull()) {
            throw new IllegalArgumentException("EntityProperty cannot be set to null for primitive value types.");
        }
        if (this.value.equals("Infinity") || this.value.equals("INF")) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.value.equals("-Infinity") || this.value.equals("-INF")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.value.equals("NaN")) {
            return Double.NaN;
        }
        return Double.parseDouble(this.value);
    }

    public Double getValueAsDoubleObject() {
        if (this.getIsNull()) {
            return null;
        }
        if (this.value.equals("Infinity") || this.value.equals("INF")) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.value.equals("-Infinity") || this.value.equals("-INF")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.value.equals("NaN")) {
            return Double.NaN;
        }
        return Double.parseDouble(this.value);
    }

    public int getValueAsInteger() {
        if (this.getIsNull()) {
            throw new IllegalArgumentException("EntityProperty cannot be set to null for primitive value types.");
        }
        return Integer.parseInt(this.value);
    }

    public Integer getValueAsIntegerObject() {
        return this.getIsNull() ? null : Integer.valueOf(Integer.parseInt(this.value));
    }

    public long getValueAsLong() {
        if (this.getIsNull()) {
            throw new IllegalArgumentException("EntityProperty cannot be set to null for primitive value types.");
        }
        return Long.parseLong(this.value);
    }

    public Long getValueAsLongObject() {
        return this.getIsNull() ? null : Long.valueOf(Long.parseLong(this.value));
    }

    public String getValueAsString() {
        return this.getIsNull() ? null : this.value;
    }

    public UUID getValueAsUUID() {
        return this.getIsNull() ? null : UUID.fromString(this.value);
    }

    public final synchronized void setValue(boolean value) {
        this.edmType = EdmType.BOOLEAN;
        this.type = Boolean.TYPE;
        this.value = value ? "true" : "false";
    }

    public final synchronized void setValue(Boolean value) {
        this.edmType = EdmType.BOOLEAN;
        this.type = Boolean.class;
        this.value = value == null ? null : (value != false ? "true" : "false");
    }

    public final synchronized void setValue(byte[] value) {
        this.edmType = EdmType.BINARY;
        this.type = byte[].class;
        this.value = value == null ? null : Base64.encode(value);
    }

    public final synchronized void setValue(Byte[] value) {
        this.edmType = EdmType.BINARY;
        this.type = Byte[].class;
        this.value = value == null ? null : Base64.encode(value);
    }

    public final synchronized void setValue(Date value) {
        this.edmType = EdmType.DATE_TIME;
        this.type = Date.class;
        this.value = value == null ? null : Utility.getJavaISO8601Time(value);
    }

    public final synchronized void setValue(double value) {
        this.edmType = EdmType.DOUBLE;
        this.type = Double.TYPE;
        this.value = Double.toString(value);
    }

    public final synchronized void setValue(Double value) {
        this.edmType = EdmType.DOUBLE;
        this.type = Double.class;
        this.value = value == null ? null : Double.toString(value);
    }

    public final synchronized void setValue(int value) {
        this.edmType = EdmType.INT32;
        this.type = Integer.TYPE;
        this.value = Integer.toString(value);
    }

    public final synchronized void setValue(Integer value) {
        this.edmType = EdmType.INT32;
        this.type = Integer.class;
        this.value = value == null ? null : Integer.toString(value);
    }

    public final synchronized void setValue(long value) {
        this.edmType = EdmType.INT64;
        this.type = Long.TYPE;
        this.value = Long.toString(value);
    }

    public final synchronized void setValue(Long value) {
        this.edmType = EdmType.INT64;
        this.type = Long.class;
        this.value = value == null ? null : Long.toString(value);
    }

    public final synchronized void setValue(String value) {
        this.edmType = EdmType.STRING;
        this.type = String.class;
        this.value = value;
    }

    public final synchronized void setValue(UUID value) {
        this.edmType = EdmType.GUID;
        this.type = UUID.class;
        this.value = value == null ? null : value.toString();
    }

    void setDateBackwardCompatibility(boolean dateBackwardCompatibility) {
        this.dateBackwardCompatibility = dateBackwardCompatibility;
    }

    protected void setIsEncrypted(boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
    }
}

