/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.util.Collections;
import java.util.Set;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.ActionRequiredForJWSCompletionException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.CompletableJWSObjectSigning;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSHeader;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSSigner;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSSignerOption;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.ECDSA;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.ECDSAProvider;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.opts.OptionUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.opts.UserAuthenticationRequired;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.Curve;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.ECKey;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.Base64URL;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ECDSASigner
extends ECDSAProvider
implements JWSSigner {
    private final PrivateKey privateKey;
    private final Set<JWSSignerOption> opts;

    public ECDSASigner(ECPrivateKey privateKey) throws JOSEException {
        this(privateKey, (Set<JWSSignerOption>)null);
    }

    public ECDSASigner(ECPrivateKey privateKey, Set<JWSSignerOption> opts) throws JOSEException {
        super(ECDSA.resolveAlgorithm(privateKey));
        this.privateKey = privateKey;
        this.opts = opts != null ? opts : Collections.emptySet();
    }

    public ECDSASigner(PrivateKey privateKey, Curve curve) throws JOSEException {
        this(privateKey, curve, null);
    }

    public ECDSASigner(PrivateKey privateKey, Curve curve, Set<JWSSignerOption> opts) throws JOSEException {
        super(ECDSA.resolveAlgorithm(curve));
        if (!"EC".equalsIgnoreCase(privateKey.getAlgorithm())) {
            throw new IllegalArgumentException("The private key algorithm must be EC");
        }
        this.privateKey = privateKey;
        this.opts = opts != null ? opts : Collections.emptySet();
    }

    public ECDSASigner(ECKey ecJWK) throws JOSEException {
        this(ecJWK, null);
    }

    public ECDSASigner(ECKey ecJWK, Set<JWSSignerOption> opts) throws JOSEException {
        super(ECDSA.resolveAlgorithm(ecJWK.getCurve()));
        if (!ecJWK.isPrivate()) {
            throw new JOSEException("The EC JWK doesn't contain a private part");
        }
        this.privateKey = ecJWK.toPrivateKey();
        this.opts = opts != null ? opts : Collections.emptySet();
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Base64URL sign(final JWSHeader header, final byte[] signingInput) throws JOSEException {
        byte[] jcaSignature;
        JWSAlgorithm alg = header.getAlgorithm();
        if (!this.supportedJWSAlgorithms().contains(alg)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWSAlgorithm(alg, this.supportedJWSAlgorithms()));
        }
        try {
            final Signature dsa = ECDSA.getSignerAndVerifier(alg, this.getJCAContext().getProvider());
            dsa.initSign(this.privateKey, this.getJCAContext().getSecureRandom());
            if (OptionUtils.optionIsPresent(this.opts, UserAuthenticationRequired.class)) {
                throw new ActionRequiredForJWSCompletionException("Authenticate user to complete signing", UserAuthenticationRequired.getInstance(), new CompletableJWSObjectSigning(){

                    @Override
                    public Signature getInitializedSignature() {
                        return dsa;
                    }

                    @Override
                    public Base64URL complete() throws JOSEException {
                        try {
                            dsa.update(signingInput);
                            byte[] jcaSignature = dsa.sign();
                            int rsByteArrayLength = ECDSA.getSignatureByteArrayLength(header.getAlgorithm());
                            byte[] jwsSignature = ECDSA.transcodeSignatureToConcat(jcaSignature, rsByteArrayLength);
                            return Base64URL.encode(jwsSignature);
                        }
                        catch (SignatureException e) {
                            throw new JOSEException(e.getMessage(), e);
                        }
                    }
                });
            }
            dsa.update(signingInput);
            jcaSignature = dsa.sign();
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new JOSEException(e.getMessage(), e);
        }
        int rsByteArrayLength = ECDSA.getSignatureByteArrayLength(header.getAlgorithm());
        byte[] jwsSignature = ECDSA.transcodeSignatureToConcat(jcaSignature, rsByteArrayLength);
        return Base64URL.encode(jwsSignature);
    }
}

