/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.core.FileUtil;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFFixedViewResultSet;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.FileBackedOutputStream;
import net.snowflake.client.jdbc.MatDesc;
import net.snowflake.client.jdbc.SFBaseFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeFileTransferConfig;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadata;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadataV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeSimulatedUploadFailure;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeStorageClient;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.cloud.storage.StorageClientFactory;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectSummary;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectSummaryCollection;
import net.snowflake.client.jdbc.cloud.storage.StorageProviderException;
import net.snowflake.client.jdbc.internal.apache.commons.codec.digest.DigestUtils;
import net.snowflake.client.jdbc.internal.apache.commons.io.FileUtils;
import net.snowflake.client.jdbc.internal.apache.commons.io.IOUtils;
import net.snowflake.client.jdbc.internal.apache.commons.io.filefilter.WildcardFileFilter;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.TreeNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.type.TypeReference;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.google.common.base.Strings;
import net.snowflake.client.jdbc.internal.google.common.io.ByteStreams;
import net.snowflake.client.jdbc.internal.google.common.io.CountingOutputStream;
import net.snowflake.client.jdbc.internal.snowflake.common.core.FileCompressionType;
import net.snowflake.client.jdbc.internal.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SnowflakeFileTransferAgent
extends SFBaseFileTransferAgent {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeFileTransferAgent.class);
    static final StorageClientFactory storageFactory = StorageClientFactory.getFactory();
    private static final ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
    static final int MAX_BUFFER_SIZE = 0x8000000;
    public static final String SRC_FILE_NAME_FOR_STREAM = "stream";
    private static final String FILE_PROTOCOL = "file://";
    private static final String localFSFileSep = SnowflakeUtil.systemGetProperty("file.separator");
    private static final int DEFAULT_PARALLEL = 10;
    private final String command;
    private Set<String> sourceFiles;
    private Set<String> bigSourceFiles;
    private Set<String> smallSourceFiles;
    private int bigFileThreshold = 0xC800000;
    private Map<String, FileMetadata> fileMetadataMap;
    private StageInfo stageInfo;
    private String localLocation;
    private String queryID = null;
    private int parallel = 10;
    private SFSession session;
    private SFStatement statement;
    private static Throwable injectedFileTransferException = null;
    private List<RemoteStoreFileEncryptionMaterial> encryptionMaterial;
    private List<String> presignedUrls;
    HashMap<String, RemoteStoreFileEncryptionMaterial> srcFileToEncMat;
    HashMap<String, String> srcFileToPresignedUrl;
    private boolean autoCompress = true;
    private boolean overwrite = false;
    private SnowflakeStorageClient storageClient = null;
    private static final String SOURCE_COMPRESSION_AUTO_DETECT = "auto_detect";
    private static final String SOURCE_COMPRESSION_NONE = "none";
    private String sourceCompression = "auto_detect";
    private ExecutorService threadExecutor = null;
    private Boolean canceled = false;

    static void setInjectedFileTransferException(Throwable th) {
        injectedFileTransferException = th;
    }

    static boolean isInjectedFileTransferExceptionEnabled() {
        return injectedFileTransferException != null;
    }

    public StageInfo getStageInfo() {
        return this.stageInfo;
    }

    int getBigFileThreshold() {
        return this.bigFileThreshold;
    }

    public Map<?, ?> getStageCredentials() {
        return new HashMap(this.stageInfo.getCredentials());
    }

    public List<RemoteStoreFileEncryptionMaterial> getEncryptionMaterial() {
        return new ArrayList<RemoteStoreFileEncryptionMaterial>(this.encryptionMaterial);
    }

    public Map<String, RemoteStoreFileEncryptionMaterial> getSrcToMaterialsMap() {
        return new HashMap<String, RemoteStoreFileEncryptionMaterial>(this.srcFileToEncMat);
    }

    public Map<String, String> getSrcToPresignedUrlMap() {
        return new HashMap<String, String>(this.srcFileToPresignedUrl);
    }

    public String getStageLocation() {
        return this.stageInfo.getLocation();
    }

    private void initEncryptionMaterial(SFBaseFileTransferAgent.CommandType commandType, JsonNode jsonNode) throws SnowflakeSQLException, JsonProcessingException {
        this.encryptionMaterial = SnowflakeFileTransferAgent.getEncryptionMaterial(commandType, jsonNode);
    }

    static List<RemoteStoreFileEncryptionMaterial> getEncryptionMaterial(SFBaseFileTransferAgent.CommandType commandType, JsonNode jsonNode) throws SnowflakeSQLException, JsonProcessingException {
        List<RemoteStoreFileEncryptionMaterial> encryptionMaterial = new ArrayList<RemoteStoreFileEncryptionMaterial>();
        JsonNode rootNode = jsonNode.path("data").path("encryptionMaterial");
        if (commandType == SFBaseFileTransferAgent.CommandType.UPLOAD) {
            logger.debug("InitEncryptionMaterial: UPLOAD", false);
            RemoteStoreFileEncryptionMaterial encMat = null;
            if (!rootNode.isMissingNode() && !rootNode.isNull()) {
                encMat = mapper.treeToValue((TreeNode)rootNode, RemoteStoreFileEncryptionMaterial.class);
            }
            encryptionMaterial.add(encMat);
        } else {
            logger.debug("InitEncryptionMaterial: DOWNLOAD", false);
            if (!rootNode.isMissingNode() && !rootNode.isNull()) {
                encryptionMaterial = Arrays.asList(mapper.treeToValue((TreeNode)rootNode, RemoteStoreFileEncryptionMaterial[].class));
            }
        }
        return encryptionMaterial;
    }

    private void initPresignedUrls(SFBaseFileTransferAgent.CommandType commandType, JsonNode jsonNode) throws SnowflakeSQLException, JsonProcessingException, IOException {
        this.presignedUrls = SnowflakeFileTransferAgent.getPresignedUrls(commandType, jsonNode);
    }

    private static List<String> getPresignedUrls(SFBaseFileTransferAgent.CommandType commandType, JsonNode jsonNode) throws SnowflakeSQLException, JsonProcessingException, IOException {
        List<String> presignedUrls = new ArrayList<String>();
        JsonNode rootNode = jsonNode.path("data").path("presignedUrls");
        if (commandType == SFBaseFileTransferAgent.CommandType.DOWNLOAD) {
            logger.debug("InitEncryptionMaterial: DOWNLOAD", false);
            if (!rootNode.isMissingNode() && !rootNode.isNull()) {
                presignedUrls = Arrays.asList(mapper.readValue(rootNode.toString(), String[].class));
            }
        }
        return presignedUrls;
    }

    private static InputStreamWithMetadata compressStreamWithGZIP(InputStream inputStream, SFBaseSession session, String queryId) throws SnowflakeSQLException {
        FileBackedOutputStream tempStream = new FileBackedOutputStream(0x8000000, true);
        try {
            DigestOutputStream digestStream = new DigestOutputStream(tempStream, MessageDigest.getInstance("SHA-256"));
            CountingOutputStream countingStream = new CountingOutputStream(digestStream);
            GZIPOutputStream gzipStream = new GZIPOutputStream((OutputStream)countingStream, true);
            IOUtils.copy(inputStream, (OutputStream)gzipStream);
            inputStream.close();
            gzipStream.finish();
            gzipStream.flush();
            countingStream.flush();
            if (SnowflakeFileTransferAgent.isInjectedFileTransferExceptionEnabled() && injectedFileTransferException instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)injectedFileTransferException;
            }
            return new InputStreamWithMetadata(countingStream.getCount(), Base64.getEncoder().encodeToString(digestStream.getMessageDigest().digest()), tempStream);
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            logger.error("Exception compressing input stream", ex);
            throw new SnowflakeSQLLoggedException(queryId, session, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), ex, "error encountered for compression");
        }
    }

    @Deprecated
    private static InputStreamWithMetadata compressStreamWithGZIPNoDigest(InputStream inputStream, SFBaseSession session, String queryId) throws SnowflakeSQLException {
        try {
            FileBackedOutputStream tempStream = new FileBackedOutputStream(0x8000000, true);
            CountingOutputStream countingStream = new CountingOutputStream(tempStream);
            GZIPOutputStream gzipStream = new GZIPOutputStream((OutputStream)countingStream, true);
            IOUtils.copy(inputStream, (OutputStream)gzipStream);
            inputStream.close();
            gzipStream.finish();
            gzipStream.flush();
            countingStream.flush();
            if (SnowflakeFileTransferAgent.isInjectedFileTransferExceptionEnabled()) {
                throw (IOException)injectedFileTransferException;
            }
            return new InputStreamWithMetadata(countingStream.getCount(), null, tempStream);
        }
        catch (IOException ex) {
            logger.error("Exception compressing input stream", ex);
            throw new SnowflakeSQLLoggedException(queryId, session, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), ex, "error encountered for compression");
        }
    }

    private static InputStreamWithMetadata computeDigest(InputStream is, boolean resetStream) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        if (resetStream) {
            FileBackedOutputStream tempStream = new FileBackedOutputStream(0x8000000, true);
            CountingOutputStream countingOutputStream = new CountingOutputStream(tempStream);
            DigestOutputStream digestStream = new DigestOutputStream(countingOutputStream, md);
            IOUtils.copy(is, (OutputStream)digestStream);
            return new InputStreamWithMetadata(countingOutputStream.getCount(), Base64.getEncoder().encodeToString(digestStream.getMessageDigest().digest()), tempStream);
        }
        CountingOutputStream countingOutputStream = new CountingOutputStream(ByteStreams.nullOutputStream());
        DigestOutputStream digestStream = new DigestOutputStream(countingOutputStream, md);
        IOUtils.copy(is, (OutputStream)digestStream);
        return new InputStreamWithMetadata(countingOutputStream.getCount(), Base64.getEncoder().encodeToString(digestStream.getMessageDigest().digest()), null);
    }

    @Deprecated
    public static Callable<Void> getUploadFileCallable(StageInfo stage, String srcFilePath, FileMetadata metadata, SnowflakeStorageClient client, SFSession session, String command, InputStream inputStream, boolean sourceFromStream, int parallel, File srcFile, RemoteStoreFileEncryptionMaterial encMat) {
        return SnowflakeFileTransferAgent.getUploadFileCallable(stage, srcFilePath, metadata, client, session, command, inputStream, sourceFromStream, parallel, srcFile, encMat, null);
    }

    public static Callable<Void> getUploadFileCallable(final StageInfo stage, final String srcFilePath, final FileMetadata metadata, final SnowflakeStorageClient client, final SFSession session, final String command, final InputStream inputStream, final boolean sourceFromStream, final int parallel, final File srcFile, final RemoteStoreFileEncryptionMaterial encMat, final String queryId) {
        return new Callable<Void>(){

            /*
             * Unable to fully structure code
             */
            @Override
            public Void call() throws Exception {
                SnowflakeFileTransferAgent.access$000().trace("Entering getUploadFileCallable...", false);
                TelemetryService.getInstance().updateContext(session.getSnowflakeConnectionString());
                uploadStream = inputStream;
                fileToUpload = null;
                if (uploadStream == null) {
                    try {
                        if (SnowflakeFileTransferAgent.isInjectedFileTransferExceptionEnabled() && SnowflakeFileTransferAgent.access$100() instanceof FileNotFoundException) {
                            throw (FileNotFoundException)SnowflakeFileTransferAgent.access$100();
                        }
                        FileUtil.logFileUsage(srcFilePath, "Get file to upload", false);
                        uploadStream = new FileInputStream(srcFilePath);
                    }
                    catch (FileNotFoundException ex) {
                        metadata.resultStatus = ResultStatus.ERROR;
                        metadata.errorDetails = ex.getMessage();
                        throw ex;
                    }
                }
                if (metadata == null) {
                    throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", new Object[]{"missing file metadata for: " + srcFilePath});
                }
                destFileName = metadata.destFileName;
                digest = null;
                SnowflakeFileTransferAgent.access$000().debug("Dest file name: {}", false);
                fileBackedOutputStream = null;
                try {
                    if (metadata.requireCompress) {
                        compressedSizeAndStream = encMat == null ? SnowflakeFileTransferAgent.access$200(uploadStream, session, queryId) : SnowflakeFileTransferAgent.access$300(uploadStream, session, queryId);
                        fileBackedOutputStream = compressedSizeAndStream.fileBackedOutputStream;
                        uploadSize = compressedSizeAndStream.size;
                        digest = compressedSizeAndStream.digest;
                        if (compressedSizeAndStream.fileBackedOutputStream.getFile() != null) {
                            fileToUpload = compressedSizeAndStream.fileBackedOutputStream.getFile();
                        }
                        SnowflakeFileTransferAgent.access$000().debug("New size after compression: {}", new Object[]{uploadSize});
                    } else if (stage.getStageType() != StageInfo.StageType.LOCAL_FS) {
                        result = SnowflakeFileTransferAgent.access$400(uploadStream, sourceFromStream);
                        digest = result.digest;
                        fileBackedOutputStream = result.fileBackedOutputStream;
                        uploadSize = result.size;
                        if (!sourceFromStream) {
                            fileToUpload = srcFile;
                        } else if (result.fileBackedOutputStream.getFile() != null) {
                            fileToUpload = result.fileBackedOutputStream.getFile();
                        }
                    } else {
                        if (!sourceFromStream && srcFile != null) {
                            fileToUpload = srcFile;
                        }
                        uploadSize = sourceFromStream != false ? 0L : srcFile.length();
                    }
                    SnowflakeFileTransferAgent.access$000().debug("Started copying file from: {} to {}:{} destName: {} auto compressed? {} size: {}", new Object[]{srcFilePath, stage.getStageType().name(), stage.getLocation(), destFileName, metadata.requireCompress != false ? "yes" : "no", uploadSize});
                    if (session.getInjectFileUploadFailure() != null && srcFilePath.endsWith(session.getInjectFileUploadFailure())) {
                        throw new SnowflakeSimulatedUploadFailure(srcFile != null ? srcFile.getName() : "Unknown");
                    }
                    switch (6.$SwitchMap$net$snowflake$client$jdbc$cloud$storage$StageInfo$StageType[stage.getStageType().ordinal()]) {
                        case 1: {
                            SnowflakeFileTransferAgent.access$500(stage.getLocation(), srcFilePath, destFileName, uploadStream, fileBackedOutputStream, session, queryId);
                            ** break;
lbl54:
                            // 1 sources

                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            SnowflakeFileTransferAgent.access$600(stage, destFileName, uploadStream, fileBackedOutputStream, uploadSize, digest, metadata.destCompressionType, client, session, command, parallel, fileToUpload, fileToUpload == null, encMat, null, null, queryId);
                            metadata.isEncrypted = encMat != null;
                            break;
                        }
                        ** default:
lbl60:
                        // 1 sources

                        break;
                    }
                }
                catch (SnowflakeSimulatedUploadFailure ex) {
                    metadata.resultStatus = ResultStatus.ERROR;
                    metadata.errorDetails = ex.getMessage();
                    throw ex;
                }
                catch (Throwable ex) {
                    SnowflakeFileTransferAgent.access$000().error("Exception encountered during file upload", ex);
                    metadata.resultStatus = ResultStatus.ERROR;
                    metadata.errorDetails = ex.getMessage();
                    throw ex;
                }
                finally {
                    if (fileBackedOutputStream != null) {
                        try {
                            fileBackedOutputStream.reset();
                        }
                        catch (IOException ex) {
                            SnowflakeFileTransferAgent.access$000().debug("Failed to clean up temp file: {}", ex);
                        }
                    }
                    if (inputStream == null) {
                        IOUtils.closeQuietly(uploadStream);
                    }
                }
                SnowflakeFileTransferAgent.access$000().debug("FilePath: {}", new Object[]{srcFilePath});
                metadata.destFileSize = uploadSize;
                metadata.resultStatus = ResultStatus.UPLOADED;
                return null;
            }
        };
    }

    @Deprecated
    public static Callable<Void> getDownloadFileCallable(StageInfo stage, String srcFilePath, String localLocation, Map<String, FileMetadata> fileMetadataMap, SnowflakeStorageClient client, SFSession session, String command, int parallel, RemoteStoreFileEncryptionMaterial encMat, String presignedUrl) {
        return SnowflakeFileTransferAgent.getDownloadFileCallable(stage, srcFilePath, localLocation, fileMetadataMap, client, session, command, parallel, encMat, presignedUrl, null);
    }

    public static Callable<Void> getDownloadFileCallable(final StageInfo stage, final String srcFilePath, final String localLocation, final Map<String, FileMetadata> fileMetadataMap, final SnowflakeStorageClient client, final SFSession session, final String command, final int parallel, final RemoteStoreFileEncryptionMaterial encMat, final String presignedUrl, final String queryId) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                long downloadSize;
                logger.debug("Entering getDownloadFileCallable...", false);
                TelemetryService.getInstance().updateContext(session.getSnowflakeConnectionString());
                FileMetadata metadata = (FileMetadata)fileMetadataMap.get(srcFilePath);
                if (metadata == null) {
                    throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "missing file metadata for: " + srcFilePath);
                }
                String destFileName = metadata.destFileName;
                logger.debug("Started copying file from: {}:{} file path:{} to {} destName:{}", stage.getStageType().name(), stage.getLocation(), srcFilePath, localLocation, destFileName);
                try {
                    switch (stage.getStageType()) {
                        case LOCAL_FS: {
                            SnowflakeFileTransferAgent.pullFileFromLocal(stage.getLocation(), srcFilePath, localLocation, destFileName, session, queryId);
                            break;
                        }
                        case S3: 
                        case AZURE: 
                        case GCS: {
                            SnowflakeFileTransferAgent.pullFileFromRemoteStore(stage, srcFilePath, destFileName, localLocation, client, session, command, parallel, encMat, presignedUrl, queryId);
                            metadata.isEncrypted = encMat != null;
                        }
                    }
                }
                catch (Throwable ex) {
                    logger.error("Exception encountered during file download", ex);
                    metadata.resultStatus = ResultStatus.ERROR;
                    metadata.errorDetails = ex.getMessage();
                    throw ex;
                }
                logger.debug("FilePath: {}", srcFilePath);
                File destFile = new File(localLocation + localFSFileSep + destFileName);
                metadata.destFileSize = downloadSize = destFile.length();
                metadata.resultStatus = ResultStatus.DOWNLOADED;
                return null;
            }
        };
    }

    public SnowflakeFileTransferAgent(String command, SFSession session, SFStatement statement) throws SnowflakeSQLException {
        this.command = command;
        this.session = session;
        this.statement = statement;
        logger.debug("Start parsing", false);
        this.parseCommand();
        if (this.stageInfo.getStageType() != StageInfo.StageType.LOCAL_FS) {
            this.storageClient = storageFactory.createClient(this.stageInfo, this.parallel, null, session);
        }
    }

    private void parseCommand() throws SnowflakeSQLException {
        String[] src_locations;
        JsonNode jsonNode = SnowflakeFileTransferAgent.parseCommandInGS(this.statement, this.command);
        if (!jsonNode.path("data").path("command").isMissingNode()) {
            this.commandType = SFBaseFileTransferAgent.CommandType.valueOf(jsonNode.path("data").path("command").asText());
        }
        JsonNode locationsNode = jsonNode.path("data").path("src_locations");
        this.queryID = jsonNode.path("data").path("queryId").asText();
        assert (locationsNode.isArray());
        try {
            if (SnowflakeFileTransferAgent.isInjectedFileTransferExceptionEnabled() && injectedFileTransferException instanceof SnowflakeSQLException) {
                throw (SnowflakeSQLException)injectedFileTransferException;
            }
            src_locations = mapper.readValue(locationsNode.toString(), String[].class);
            this.initEncryptionMaterial(this.commandType, jsonNode);
            this.initPresignedUrls(this.commandType, jsonNode);
        }
        catch (Exception ex) {
            throw new SnowflakeSQLException(this.queryID, ex, "XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Failed to parse the locations due to: " + ex.getMessage());
        }
        this.showEncryptionParameter = jsonNode.path("data").path("clientShowEncryptionParameter").asBoolean();
        JsonNode thresholdNode = jsonNode.path("data").path("threshold");
        int threshold = thresholdNode.asInt();
        if (threshold > 0) {
            this.bigFileThreshold = threshold;
        }
        String localFilePathFromGS = null;
        if (this.commandType == SFBaseFileTransferAgent.CommandType.UPLOAD) {
            if (src_locations.length > 0) {
                localFilePathFromGS = src_locations[0];
            }
            this.sourceFiles = SnowflakeFileTransferAgent.expandFileNames(src_locations, this.queryID);
            this.autoCompress = jsonNode.path("data").path("autoCompress").asBoolean(true);
            if (!jsonNode.path("data").path("sourceCompression").isMissingNode()) {
                this.sourceCompression = jsonNode.path("data").path("sourceCompression").asText();
            }
        } else {
            int srcFileIdx;
            this.srcFileToEncMat = new HashMap();
            if (src_locations.length == this.encryptionMaterial.size()) {
                for (srcFileIdx = 0; srcFileIdx < src_locations.length; ++srcFileIdx) {
                    this.srcFileToEncMat.put(src_locations[srcFileIdx], this.encryptionMaterial.get(srcFileIdx));
                }
            }
            this.srcFileToPresignedUrl = new HashMap();
            if (src_locations.length == this.presignedUrls.size()) {
                for (srcFileIdx = 0; srcFileIdx < src_locations.length; ++srcFileIdx) {
                    this.srcFileToPresignedUrl.put(src_locations[srcFileIdx], this.presignedUrls.get(srcFileIdx));
                }
            }
            this.sourceFiles = new HashSet<String>(Arrays.asList(src_locations));
            localFilePathFromGS = this.localLocation = jsonNode.path("data").path("localLocation").asText();
            if (this.localLocation.startsWith("~")) {
                this.localLocation = SnowflakeUtil.systemGetProperty("user.home") + this.localLocation.substring(1);
            }
            if (this.localLocation.startsWith("~")) {
                throw new SnowflakeSQLLoggedException(this.queryID, (SFBaseSession)this.session, (int)ErrorCode.PATH_NOT_DIRECTORY.getMessageCode(), "58030", this.localLocation);
            }
            if (!new File(this.localLocation).isAbsolute()) {
                String cwd = SnowflakeUtil.systemGetProperty("user.dir");
                logger.debug("Adding current working dir to relative file path.", false);
                this.localLocation = cwd + localFSFileSep + this.localLocation;
            }
            if (new File(this.localLocation).isFile()) {
                throw new SnowflakeSQLLoggedException(this.queryID, (SFBaseSession)this.session, (int)ErrorCode.PATH_NOT_DIRECTORY.getMessageCode(), "58030", this.localLocation);
            }
        }
        this.verifyLocalFilePath(localFilePathFromGS);
        this.parallel = jsonNode.path("data").path("parallel").asInt();
        this.overwrite = jsonNode.path("data").path("overwrite").asBoolean(false);
        this.stageInfo = SnowflakeFileTransferAgent.getStageInfo(jsonNode, this.session);
        if (logger.isDebugEnabled()) {
            logger.debug("Command type: {}", new Object[]{this.commandType});
            if (this.commandType == SFBaseFileTransferAgent.CommandType.UPLOAD) {
                logger.debug("Auto compress: {}, source compression: {}", this.autoCompress, this.sourceCompression);
            } else {
                logger.debug("Local download location: {}", this.localLocation);
            }
            logger.debug("Source files: {}", String.join((CharSequence)",", this.sourceFiles));
            logger.debug("stageLocation: {}, parallel: {}, overwrite: {}, destLocationType: {}, stageRegion: {}, endPoint: {}, storageAccount: {}", new Object[]{this.stageInfo.getLocation(), this.parallel, this.overwrite, this.stageInfo.getStageType(), this.stageInfo.getRegion(), this.stageInfo.getEndPoint(), this.stageInfo.getStorageAccount()});
        }
    }

    static StageInfo getStageInfo(JsonNode jsonNode, SFSession session) throws SnowflakeSQLException {
        String presignedUrl;
        JsonNode presignedUrlNode;
        Map<?, ?> stageCredentials;
        StageInfo stageInfo;
        String queryId = jsonNode.path("data").path("queryId").asText();
        String stageLocation = jsonNode.path("data").path("stageInfo").path("location").asText();
        String stageLocationType = jsonNode.path("data").path("stageInfo").path("locationType").asText();
        String stageRegion = null;
        if (!jsonNode.path("data").path("stageInfo").path("region").isMissingNode()) {
            stageRegion = jsonNode.path("data").path("stageInfo").path("region").asText();
        }
        boolean isClientSideEncrypted = true;
        if (!jsonNode.path("data").path("stageInfo").path("isClientSideEncrypted").isMissingNode()) {
            isClientSideEncrypted = jsonNode.path("data").path("stageInfo").path("isClientSideEncrypted").asBoolean(true);
        }
        String endPoint = null;
        if ("AZURE".equalsIgnoreCase(stageLocationType) || "S3".equalsIgnoreCase(stageLocationType)) {
            endPoint = jsonNode.path("data").path("stageInfo").findValue("endPoint").asText();
        }
        String stgAcct = null;
        if ("AZURE".equalsIgnoreCase(stageLocationType)) {
            Iterator<Map.Entry<String, JsonNode>> fields = jsonNode.path("data").path("stageInfo").fields();
            while (fields.hasNext()) {
                Map.Entry<String, JsonNode> jsonField = fields.next();
                if (!jsonField.getKey().startsWith("sto")) continue;
                stgAcct = jsonField.getValue().toString().trim().substring(1, jsonField.getValue().toString().trim().lastIndexOf("\""));
            }
        }
        if ("LOCAL_FS".equalsIgnoreCase(stageLocationType)) {
            if (stageLocation.startsWith("~")) {
                stageLocation = SnowflakeUtil.systemGetProperty("user.home") + stageLocation.substring(1);
            }
            if (!new File(stageLocation).isAbsolute()) {
                String cwd = SnowflakeUtil.systemGetProperty("user.dir");
                logger.debug("Adding current working dir to stage file path.", new Object[0]);
                stageLocation = cwd + localFSFileSep + stageLocation;
            }
        }
        if ((stageInfo = StageInfo.createStageInfo(stageLocationType, stageLocation, stageCredentials = SnowflakeFileTransferAgent.extractStageCreds(jsonNode, queryId), stageRegion, endPoint, stgAcct, isClientSideEncrypted)).getStageType() == StageInfo.StageType.GCS && !(presignedUrlNode = jsonNode.path("data").path("stageInfo").path("presignedUrl")).isMissingNode() && !Strings.isNullOrEmpty(presignedUrl = presignedUrlNode.asText())) {
            stageInfo.setPresignedUrl(presignedUrl);
        }
        if (stageInfo.getStageType() == StageInfo.StageType.S3) {
            if (session == null) {
                JsonNode useS3RegionalURLNode = jsonNode.path("data").path("stageInfo").path("useS3RegionalUrl");
                if (!useS3RegionalURLNode.isMissingNode()) {
                    boolean useS3RegionalUrl = useS3RegionalURLNode.asBoolean(false);
                    stageInfo.setUseS3RegionalUrl(useS3RegionalUrl);
                }
            } else {
                stageInfo.setUseS3RegionalUrl(session.getUseRegionalS3EndpointsForPresignedURL());
            }
        }
        return stageInfo;
    }

    private void verifyLocalFilePath(String localFilePathFromGS) throws SnowflakeSQLException {
        String localFilePath = SnowflakeFileTransferAgent.getLocalFilePathFromCommand(this.command, true);
        if (!localFilePath.isEmpty() && !localFilePath.equals(localFilePathFromGS)) {
            throw new SnowflakeSQLLoggedException(this.queryID, (SFBaseSession)this.session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unexpected local file path from GS. From GS: " + localFilePathFromGS + ", expected: " + localFilePath);
        }
        if (localFilePath.isEmpty()) {
            logger.debug("Fail to parse local file path from command: {}", this.command);
        } else {
            logger.trace("local file path from GS matches local parsing: {}", localFilePath);
        }
    }

    private static String getLocalFilePathFromCommand(String command, boolean unescape) {
        if (command == null) {
            logger.error("null command", false);
            return null;
        }
        if (command.indexOf(FILE_PROTOCOL) < 0) {
            logger.error("file:// prefix not found in command: {}", command);
            return null;
        }
        int localFilePathBeginIdx = command.indexOf(FILE_PROTOCOL) + FILE_PROTOCOL.length();
        boolean isLocalFilePathQuoted = localFilePathBeginIdx > FILE_PROTOCOL.length() && command.charAt(localFilePathBeginIdx - 1 - FILE_PROTOCOL.length()) == '\'';
        int localFilePathEndIdx = 0;
        String localFilePath = "";
        if (isLocalFilePathQuoted) {
            localFilePathEndIdx = command.indexOf("'", localFilePathBeginIdx);
            if (localFilePathEndIdx > localFilePathBeginIdx) {
                localFilePath = command.substring(localFilePathBeginIdx, localFilePathEndIdx);
            }
            if (unescape) {
                localFilePath = localFilePath.replaceAll("\\\\\\\\", "\\\\");
            }
        } else {
            ArrayList<Integer> indexList = new ArrayList<Integer>();
            char[] delimiterChars = new char[]{' ', '\n', ';'};
            for (int i = 0; i < delimiterChars.length; ++i) {
                int charIndex = command.indexOf(delimiterChars[i], localFilePathBeginIdx);
                if (charIndex == -1) continue;
                indexList.add(charIndex);
            }
            int n = localFilePathEndIdx = indexList.isEmpty() ? -1 : (Integer)Collections.min(indexList);
            if (localFilePathEndIdx > localFilePathBeginIdx) {
                localFilePath = command.substring(localFilePathBeginIdx, localFilePathEndIdx);
            } else if (localFilePathEndIdx == -1) {
                localFilePath = command.substring(localFilePathBeginIdx);
            }
        }
        return localFilePath;
    }

    private static JsonNode parseCommandInGS(SFStatement statement, String command) throws SnowflakeSQLException {
        Object result = null;
        try {
            result = statement.executeHelper(command, "application/json", null, false, false, false, new ExecTimeTelemetryData());
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getQueryId(), ex, ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
        JsonNode jsonNode = (JsonNode)result;
        logger.debug("Response: {}", jsonNode.toString());
        SnowflakeUtil.checkErrorAndThrowException(jsonNode);
        return jsonNode;
    }

    private static Map<?, ?> extractStageCreds(JsonNode rootNode, String queryId) throws SnowflakeSQLException {
        JsonNode credsNode = rootNode.path("data").path("stageInfo").path("creds");
        Map stageCredentials = null;
        try {
            TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
            stageCredentials = mapper.readValue(credsNode.toString(), typeRef);
        }
        catch (Exception ex) {
            throw new SnowflakeSQLException(queryId, ex, "XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Failed to parse the credentials (" + (credsNode != null ? credsNode.toString() : "null") + ") due to exception: " + ex.getMessage());
        }
        return stageCredentials;
    }

    public List<SnowflakeFileTransferMetadata> getFileTransferMetadatas() throws SnowflakeSQLException {
        ArrayList<SnowflakeFileTransferMetadata> result = new ArrayList<SnowflakeFileTransferMetadata>();
        if (this.stageInfo.getStageType() != StageInfo.StageType.GCS && this.stageInfo.getStageType() != StageInfo.StageType.AZURE && this.stageInfo.getStageType() != StageInfo.StageType.S3) {
            throw new SnowflakeSQLLoggedException(this.queryID, (SFBaseSession)this.session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "This API only supports S3/AZURE/GCS");
        }
        if (this.commandType != SFBaseFileTransferAgent.CommandType.UPLOAD) {
            throw new SnowflakeSQLLoggedException(this.queryID, (SFBaseSession)this.session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "This API only supports PUT command");
        }
        for (String sourceFilePath : this.sourceFiles) {
            String sourceFileName = sourceFilePath.substring(sourceFilePath.lastIndexOf("/") + 1);
            result.add(new SnowflakeFileTransferMetadataV1(this.stageInfo.getPresignedUrl(), sourceFileName, this.encryptionMaterial.get(0).getQueryStageMasterKey(), this.encryptionMaterial.get(0).getQueryId(), this.encryptionMaterial.get(0).getSmkId(), this.commandType, this.stageInfo));
        }
        return result;
    }

    public static List<SnowflakeFileTransferMetadata> getFileTransferMetadatas(JsonNode jsonNode) throws SnowflakeSQLException {
        return SnowflakeFileTransferAgent.getFileTransferMetadatas(jsonNode, null);
    }

    public static List<SnowflakeFileTransferMetadata> getFileTransferMetadatas(JsonNode jsonNode, String queryId) throws SnowflakeSQLException {
        List<RemoteStoreFileEncryptionMaterial> encryptionMaterial;
        String[] srcLocations;
        SFBaseFileTransferAgent.CommandType commandType;
        SFBaseFileTransferAgent.CommandType commandType2 = commandType = !jsonNode.path("data").path("command").isMissingNode() ? SFBaseFileTransferAgent.CommandType.valueOf(jsonNode.path("data").path("command").asText()) : SFBaseFileTransferAgent.CommandType.UPLOAD;
        if (commandType != SFBaseFileTransferAgent.CommandType.UPLOAD) {
            throw new SnowflakeSQLException(queryId, ErrorCode.INTERNAL_ERROR, "This API only supports PUT commands");
        }
        JsonNode locationsNode = jsonNode.path("data").path("src_locations");
        if (!locationsNode.isArray()) {
            throw new SnowflakeSQLException(queryId, ErrorCode.INTERNAL_ERROR, "src_locations must be an array");
        }
        try {
            srcLocations = mapper.readValue(locationsNode.toString(), String[].class);
        }
        catch (Exception ex) {
            throw new SnowflakeSQLException(queryId, ErrorCode.INTERNAL_ERROR, "Failed to parse the locations due to: " + ex.getMessage());
        }
        try {
            encryptionMaterial = SnowflakeFileTransferAgent.getEncryptionMaterial(commandType, jsonNode);
        }
        catch (Exception ex) {
            throw new SnowflakeSQLException(queryId, ErrorCode.INTERNAL_ERROR, "Failed to parse encryptionMaterial due to: " + ex.getMessage());
        }
        assert (encryptionMaterial.size() == 1);
        Set<String> sourceFiles = SnowflakeFileTransferAgent.expandFileNames(srcLocations, queryId);
        StageInfo stageInfo = SnowflakeFileTransferAgent.getStageInfo(jsonNode, null);
        ArrayList<SnowflakeFileTransferMetadata> result = new ArrayList<SnowflakeFileTransferMetadata>();
        if (stageInfo.getStageType() != StageInfo.StageType.GCS && stageInfo.getStageType() != StageInfo.StageType.AZURE && stageInfo.getStageType() != StageInfo.StageType.S3) {
            throw new SnowflakeSQLException(queryId, ErrorCode.INTERNAL_ERROR, "This API only supports S3/AZURE/GCS, received=" + (Object)((Object)stageInfo.getStageType()));
        }
        for (String sourceFilePath : sourceFiles) {
            String sourceFileName = sourceFilePath.substring(sourceFilePath.lastIndexOf("/") + 1);
            result.add(new SnowflakeFileTransferMetadataV1(stageInfo.getPresignedUrl(), sourceFileName, encryptionMaterial.get(0) != null ? encryptionMaterial.get(0).getQueryStageMasterKey() : null, encryptionMaterial.get(0) != null ? encryptionMaterial.get(0).getQueryId() : null, encryptionMaterial.get(0) != null ? encryptionMaterial.get(0).getSmkId() : null, commandType, stageInfo));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean execute() throws SQLException {
        try {
            logger.debug("Start init metadata", new Object[0]);
            this.initFileMetadata();
            logger.debug("Start checking file types", new Object[0]);
            if (this.commandType == SFBaseFileTransferAgent.CommandType.UPLOAD) {
                this.processFileCompressionTypes();
            }
            if (!(this.overwrite || this.stageInfo.getStageType() == StageInfo.StageType.GCS && this.storageClient.requirePresignedUrl())) {
                logger.debug("Start filtering", new Object[0]);
                this.filterExistingFiles();
                logger.debug("Filtering done", new Object[0]);
            }
            Boolean bl = this.canceled;
            // MONITORENTER : bl
            if (this.canceled.booleanValue()) {
                logger.debug("File transfer canceled by user", new Object[0]);
                this.threadExecutor = null;
                boolean bl2 = false;
                // MONITOREXIT : bl
                return bl2;
            }
            // MONITOREXIT : bl
            if (this.commandType == SFBaseFileTransferAgent.CommandType.DOWNLOAD) {
                File dir = new File(this.localLocation);
                if (!dir.exists()) {
                    boolean created = dir.mkdirs();
                    if (created) {
                        logger.debug("Directory created: {}", this.localLocation);
                    } else {
                        logger.debug("Directory not created {}", this.localLocation);
                    }
                }
                this.downloadFiles();
            } else if (this.sourceFromStream) {
                this.uploadStream();
            } else {
                logger.debug("Start segregate files by size", new Object[0]);
                this.segregateFilesBySize();
                if (this.bigSourceFiles != null) {
                    logger.debug("Start uploading big files", new Object[0]);
                    this.uploadFiles(this.bigSourceFiles, 1);
                    logger.debug("End uploading big files", new Object[0]);
                }
                if (this.smallSourceFiles != null) {
                    logger.debug("Start uploading small files", new Object[0]);
                    this.uploadFiles(this.smallSourceFiles, this.parallel);
                    logger.debug("End uploading small files", new Object[0]);
                }
            }
            this.populateStatusRows();
            boolean bl3 = true;
            return bl3;
        }
        finally {
            if (this.storageClient != null) {
                this.storageClient.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadStream() throws SnowflakeSQLException {
        try {
            FileMetadata fileMetadata = this.fileMetadataMap.get(SRC_FILE_NAME_FOR_STREAM);
            if (fileMetadata.resultStatus == ResultStatus.SKIPPED) {
                logger.debug("Skipping {}, status: {}, details: {}", new Object[]{SRC_FILE_NAME_FOR_STREAM, fileMetadata.resultStatus, fileMetadata.errorDetails});
                return;
            }
            this.threadExecutor = SnowflakeUtil.createDefaultExecutorService("sf-stream-upload-worker-", 1);
            RemoteStoreFileEncryptionMaterial encMat = this.encryptionMaterial.get(0);
            Future<Void> uploadTask = null;
            if (this.commandType == SFBaseFileTransferAgent.CommandType.UPLOAD) {
                uploadTask = this.threadExecutor.submit(SnowflakeFileTransferAgent.getUploadFileCallable(this.stageInfo, SRC_FILE_NAME_FOR_STREAM, fileMetadata, this.stageInfo.getStageType() == StageInfo.StageType.LOCAL_FS ? null : storageFactory.createClient(this.stageInfo, this.parallel, encMat, this.session), this.session, this.command, this.sourceStream, true, this.parallel, null, encMat, this.queryID));
            } else if (this.commandType == SFBaseFileTransferAgent.CommandType.DOWNLOAD) {
                throw new SnowflakeSQLLoggedException(this.queryID, (SFBaseSession)this.session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000");
            }
            this.threadExecutor.shutdown();
            try {
                if (SnowflakeFileTransferAgent.isInjectedFileTransferExceptionEnabled() && injectedFileTransferException instanceof InterruptedException) {
                    throw (InterruptedException)injectedFileTransferException;
                }
                uploadTask.get();
            }
            catch (InterruptedException ex) {
                throw new SnowflakeSQLLoggedException(this.queryID, (SFBaseSession)this.session, (int)ErrorCode.INTERRUPTED.getMessageCode(), "57014");
            }
            catch (ExecutionException ex) {
                throw new SnowflakeSQLException(this.queryID, ex.getCause(), "XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), new Object[0]);
            }
            logger.debug("Done with uploading from a stream", new Object[0]);
        }
        finally {
            if (this.threadExecutor != null) {
                this.threadExecutor.shutdownNow();
                this.threadExecutor = null;
            }
        }
    }

    @Override
    public InputStream downloadStream(String fileName) throws SnowflakeSQLException {
        logger.debug("Downloading file as stream: {}", fileName);
        if (this.stageInfo.getStageType() == StageInfo.StageType.LOCAL_FS) {
            logger.error("downloadStream function doesn't support local file system", false);
            throw new SnowflakeSQLException(this.queryID, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), this.session, "downloadStream function only supported in remote stages");
        }
        remoteLocation remoteLocation2 = SnowflakeFileTransferAgent.extractLocationAndPath(this.stageInfo.getLocation());
        String sourceLocation = (String)this.sourceFiles.stream().findFirst().orElseThrow(() -> new SnowflakeSQLException(this.queryID, "02000", (int)ErrorCode.FILE_NOT_FOUND.getMessageCode(), this.session, "File not found: " + fileName));
        if (!fileName.equals(sourceLocation)) {
            logger.debug("Changing file to download location from {} to {}", fileName, sourceLocation);
        }
        String stageFilePath = sourceLocation;
        if (!remoteLocation2.path.isEmpty()) {
            stageFilePath = SnowflakeUtil.concatFilePathNames(remoteLocation2.path, sourceLocation, "/");
        }
        logger.debug("Stage file path for {} is {}", sourceLocation, stageFilePath);
        RemoteStoreFileEncryptionMaterial encMat = this.srcFileToEncMat.get(sourceLocation);
        String presignedUrl = this.srcFileToPresignedUrl.get(sourceLocation);
        return storageFactory.createClient(this.stageInfo, this.parallel, encMat, this.session).downloadToStream(this.session, this.command, this.parallel, remoteLocation2.location, stageFilePath, this.stageInfo.getRegion(), presignedUrl, this.queryID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFiles() throws SnowflakeSQLException {
        try {
            this.threadExecutor = SnowflakeUtil.createDefaultExecutorService("sf-file-download-worker-", 1);
            for (String srcFile : this.sourceFiles) {
                FileMetadata fileMetadata = this.fileMetadataMap.get(srcFile);
                if (fileMetadata.resultStatus != ResultStatus.UNKNOWN) {
                    logger.debug("Skipping {}, status: {}, details: {}", new Object[]{srcFile, fileMetadata.resultStatus, fileMetadata.errorDetails});
                    continue;
                }
                RemoteStoreFileEncryptionMaterial encMat = this.srcFileToEncMat.get(srcFile);
                String presignedUrl = this.srcFileToPresignedUrl.get(srcFile);
                this.threadExecutor.submit(SnowflakeFileTransferAgent.getDownloadFileCallable(this.stageInfo, srcFile, this.localLocation, this.fileMetadataMap, this.stageInfo.getStageType() == StageInfo.StageType.LOCAL_FS ? null : storageFactory.createClient(this.stageInfo, this.parallel, encMat, this.session), this.session, this.command, this.parallel, encMat, presignedUrl, this.queryID));
                logger.debug("Submitted download job for: {}", srcFile);
            }
            this.threadExecutor.shutdown();
            try {
                this.threadExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (InterruptedException ex) {
                throw new SnowflakeSQLLoggedException(this.queryID, (SFBaseSession)this.session, (int)ErrorCode.INTERRUPTED.getMessageCode(), "57014");
            }
            logger.debug("Done with downloading", new Object[0]);
        }
        finally {
            if (this.threadExecutor != null) {
                this.threadExecutor.shutdownNow();
                this.threadExecutor = null;
            }
        }
    }

    private void setUploadDelay(int delayTime) {
        if (delayTime > 0) {
            try {
                TimeUnit.SECONDS.sleep(delayTime);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFiles(Set<String> fileList, int parallel) throws SnowflakeSQLException {
        try {
            this.threadExecutor = SnowflakeUtil.createDefaultExecutorService("sf-file-upload-worker-", parallel);
            for (String srcFile : fileList) {
                FileMetadata fileMetadata = this.fileMetadataMap.get(srcFile);
                if (fileMetadata.resultStatus != ResultStatus.UNKNOWN) {
                    logger.debug("Skipping {}, status: {}, details: {}", new Object[]{srcFile, fileMetadata.resultStatus, fileMetadata.errorDetails});
                    continue;
                }
                File srcFileObj = new File(srcFile);
                int delay = this.session.getInjectWaitInPut();
                this.setUploadDelay(delay);
                this.threadExecutor.submit(SnowflakeFileTransferAgent.getUploadFileCallable(this.stageInfo, srcFile, fileMetadata, this.stageInfo.getStageType() == StageInfo.StageType.LOCAL_FS ? null : storageFactory.createClient(this.stageInfo, parallel, this.encryptionMaterial.get(0), this.session), this.session, this.command, null, false, parallel > 1 ? 1 : this.parallel, srcFileObj, this.encryptionMaterial.get(0), this.queryID));
                logger.debug("Submitted copy job for: {}", srcFile);
            }
            this.threadExecutor.shutdown();
            try {
                this.threadExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (InterruptedException ex) {
                throw new SnowflakeSQLLoggedException(this.queryID, (SFBaseSession)this.session, (int)ErrorCode.INTERRUPTED.getMessageCode(), "57014");
            }
            logger.debug("Done with uploading", new Object[0]);
        }
        finally {
            if (this.threadExecutor != null) {
                this.threadExecutor.shutdownNow();
                this.threadExecutor = null;
            }
        }
    }

    private void segregateFilesBySize() {
        for (String srcFile : this.sourceFiles) {
            if (new File(srcFile).length() > (long)this.bigFileThreshold) {
                if (this.bigSourceFiles == null) {
                    this.bigSourceFiles = new HashSet<String>(this.sourceFiles.size());
                }
                this.bigSourceFiles.add(srcFile);
                continue;
            }
            if (this.smallSourceFiles == null) {
                this.smallSourceFiles = new HashSet<String>(this.sourceFiles.size());
            }
            this.smallSourceFiles.add(srcFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Boolean bl = this.canceled;
        synchronized (bl) {
            if (this.threadExecutor != null) {
                this.threadExecutor.shutdownNow();
                this.threadExecutor = null;
            }
            this.canceled = true;
        }
    }

    static Set<String> expandFileNames(String[] filePathList, String queryId) throws SnowflakeSQLException {
        HashSet<String> result = new HashSet<String>();
        HashMap<String, ArrayList<String>> locationToFilePatterns = new HashMap<String, ArrayList<String>>();
        String cwd = SnowflakeUtil.systemGetProperty("user.dir");
        for (String path : filePathList) {
            if (path.startsWith("~")) {
                path = SnowflakeUtil.systemGetProperty("user.home") + path.substring(1);
            }
            if (!new File(path).isAbsolute()) {
                logger.debug("Adding current working dir to relative file path.", new Object[0]);
                path = cwd + localFSFileSep + path;
            }
            if (!(path.contains("*") || path.contains("?") || path.contains("[") && path.contains("]"))) {
                result.add(path);
                continue;
            }
            int lastFileSepIndex = path.lastIndexOf(localFSFileSep);
            if (lastFileSepIndex < 0 && !"/".equals(localFSFileSep)) {
                lastFileSepIndex = path.lastIndexOf("/");
            }
            String loc = path.substring(0, lastFileSepIndex + 1);
            String filePattern = path.substring(lastFileSepIndex + 1);
            ArrayList<String> filePatterns = (ArrayList<String>)locationToFilePatterns.get(loc);
            if (filePatterns == null) {
                filePatterns = new ArrayList<String>();
                locationToFilePatterns.put(loc, filePatterns);
            }
            filePatterns.add(filePattern);
        }
        for (Map.Entry entry : locationToFilePatterns.entrySet()) {
            try {
                File dir = new File((String)entry.getKey());
                logger.debug("Listing files under: {} with patterns: {}", entry.getKey(), ((List)entry.getValue()).toString());
                if (SnowflakeFileTransferAgent.isInjectedFileTransferExceptionEnabled() && injectedFileTransferException instanceof Exception) {
                    throw (Exception)injectedFileTransferException;
                }
                File[] filesMatchingPattern = dir.listFiles(new WildcardFileFilter((List)entry.getValue()));
                if (filesMatchingPattern != null) {
                    for (File file : filesMatchingPattern) {
                        result.add(file.getCanonicalPath());
                    }
                    continue;
                }
                logger.debug("No files under {} matching pattern {}", entry.getKey(), entry.getValue());
            }
            catch (Exception ex) {
                throw new SnowflakeSQLException(queryId, ex, "22000", ErrorCode.FAIL_LIST_FILES.getMessageCode(), "Exception: " + ex.getMessage() + ", Dir=" + (String)entry.getKey() + ", Patterns=" + ((List)entry.getValue()).toString());
            }
        }
        logger.debug("Expanded file paths: ", new Object[0]);
        for (String string : result) {
            logger.debug("File: {}", string);
        }
        return result;
    }

    private static boolean pushFileToLocal(String stageLocation, String filePath, String destFileName, InputStream inputStream, FileBackedOutputStream fileBackedOutStr, SFBaseSession session, String queryId) throws SQLException {
        stageLocation = stageLocation.replace("~", SnowflakeUtil.systemGetProperty("user.home"));
        try {
            logger.debug("Copy file. srcFile: {}, destination: {}, destFileName: {}", filePath, stageLocation, destFileName);
            File destFile = new File(SnowflakeUtil.concatFilePathNames(stageLocation, destFileName, localFSFileSep));
            if (fileBackedOutStr != null) {
                inputStream = fileBackedOutStr.asByteSource().openStream();
            }
            FileUtils.copyInputStreamToFile(inputStream, destFile);
        }
        catch (Exception ex) {
            throw new SnowflakeSQLLoggedException(queryId, session, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), ex, ex.getMessage());
        }
        return true;
    }

    private static boolean pullFileFromLocal(String sourceLocation, String filePath, String destLocation, String destFileName, SFBaseSession session, String queryId) throws SQLException {
        try {
            logger.debug("Copy file. srcFile: {}, destination: {}, destFileName: {}", sourceLocation + localFSFileSep + filePath, destLocation, destFileName);
            File srcFile = new File(SnowflakeUtil.concatFilePathNames(sourceLocation, filePath, localFSFileSep));
            FileUtils.copyFileToDirectory(srcFile, new File(destLocation));
        }
        catch (Exception ex) {
            throw new SnowflakeSQLLoggedException(queryId, session, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), ex, ex.getMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pushFileToRemoteStore(StageInfo stage, String destFileName, InputStream inputStream, FileBackedOutputStream fileBackedOutStr, long uploadSize, String digest, FileCompressionType compressionType, SnowflakeStorageClient initialClient, SFSession session, String command, int parallel, File srcFile, boolean uploadFromStream, RemoteStoreFileEncryptionMaterial encMat, String streamingIngestClientName, String streamingIngestClientKey, String queryId) throws SQLException, IOException {
        remoteLocation remoteLocation2 = SnowflakeFileTransferAgent.extractLocationAndPath(stage.getLocation());
        String origDestFileName = destFileName;
        if (remoteLocation2.path != null && !remoteLocation2.path.isEmpty()) {
            destFileName = remoteLocation2.path + (!remoteLocation2.path.endsWith("/") ? "/" : "") + destFileName;
        }
        logger.debug("Upload object. Location: {}, key: {}, srcFile: {}, encryption: {}", remoteLocation2.location, destFileName, srcFile, () -> encMat == null ? "NULL" : encMat.getSmkId() + "|" + encMat.getQueryId());
        StorageObjectMetadata meta = storageFactory.createStorageMetadataObj(stage.getStageType());
        meta.setContentLength(uploadSize);
        if (digest != null) {
            initialClient.addDigestMetadata(meta, digest);
        }
        if (compressionType != null && compressionType.isSupported()) {
            meta.setContentEncoding(compressionType.name().toLowerCase());
        }
        if (streamingIngestClientName != null && streamingIngestClientKey != null) {
            initialClient.addStreamingIngestMetadata(meta, streamingIngestClientName, streamingIngestClientKey);
        }
        try {
            String localFilePath;
            String commandWithExactPath;
            SFStatement statement;
            JsonNode jsonNode;
            String presignedUrl = "";
            if (initialClient.requirePresignedUrl() && !(jsonNode = SnowflakeFileTransferAgent.parseCommandInGS(statement = new SFStatement(session), commandWithExactPath = command.replace(localFilePath = SnowflakeFileTransferAgent.getLocalFilePathFromCommand(command, false), origDestFileName))).path("data").path("stageInfo").path("presignedUrl").isMissingNode()) {
                presignedUrl = jsonNode.path("data").path("stageInfo").path("presignedUrl").asText();
            }
            initialClient.upload(session, command, parallel, uploadFromStream, remoteLocation2.location, srcFile, destFileName, inputStream, fileBackedOutStr, meta, stage.getRegion(), presignedUrl, queryId);
        }
        finally {
            if (uploadFromStream && inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void uploadWithoutConnection(SnowflakeFileTransferConfig config) throws Exception {
        logger.trace("Entering uploadWithoutConnection...", new Object[0]);
        SnowflakeFileTransferMetadataV1 metadata = (SnowflakeFileTransferMetadataV1)config.getSnowflakeFileTransferMetadata();
        InputStream uploadStream = config.getUploadStream();
        boolean requireCompress = config.getRequireCompress();
        int networkTimeoutInMilli = config.getNetworkTimeoutInMilli();
        OCSPMode ocspMode = config.getOcspMode();
        Properties proxyProperties = config.getProxyProperties();
        String streamingIngestClientName = config.getStreamingIngestClientName();
        String streamingIngestClientKey = config.getStreamingIngestClientKey();
        HttpClientSettingsKey key = SnowflakeUtil.convertProxyPropertiesToHttpClientKey(ocspMode, proxyProperties);
        StageInfo stageInfo = metadata.getStageInfo();
        stageInfo.setProxyProperties(proxyProperties);
        String destFileName = metadata.getPresignedUrlFileName();
        logger.debug("Begin upload data for " + destFileName, new Object[0]);
        File fileToUpload = null;
        String digest = null;
        FileBackedOutputStream fileBackedOutputStream = null;
        RemoteStoreFileEncryptionMaterial encMat = metadata.getEncryptionMaterial();
        if (encMat.getQueryId() == null && encMat.getQueryStageMasterKey() == null && encMat.getSmkId() == null) {
            encMat = null;
        }
        try {
            long uploadSize;
            if (requireCompress) {
                InputStreamWithMetadata compressedSizeAndStream = encMat == null ? SnowflakeFileTransferAgent.compressStreamWithGZIPNoDigest(uploadStream, null, null) : SnowflakeFileTransferAgent.compressStreamWithGZIP(uploadStream, null, encMat.getQueryId());
                fileBackedOutputStream = compressedSizeAndStream.fileBackedOutputStream;
                uploadSize = compressedSizeAndStream.size;
                digest = compressedSizeAndStream.digest;
                if (compressedSizeAndStream.fileBackedOutputStream.getFile() != null) {
                    fileToUpload = compressedSizeAndStream.fileBackedOutputStream.getFile();
                }
                logger.debug("New size after compression: {}", uploadSize);
            } else {
                InputStreamWithMetadata result = SnowflakeFileTransferAgent.computeDigest(uploadStream, true);
                digest = result.digest;
                fileBackedOutputStream = result.fileBackedOutputStream;
                uploadSize = result.size;
                if (result.fileBackedOutputStream.getFile() != null) {
                    fileToUpload = result.fileBackedOutputStream.getFile();
                }
            }
            logger.debug("Started copying file to {}:{} destName: {} compressed ? {} size={}", stageInfo.getStageType().name(), stageInfo.getLocation(), destFileName, requireCompress ? "yes" : "no", uploadSize);
            SnowflakeStorageClient initialClient = storageFactory.createClient(stageInfo, 1, encMat, null);
            if (SnowflakeFileTransferAgent.isInjectedFileTransferExceptionEnabled()) {
                throw (Exception)injectedFileTransferException;
            }
            String queryId = encMat != null && encMat.getQueryId() != null ? encMat.getQueryId() : null;
            switch (stageInfo.getStageType()) {
                case S3: 
                case AZURE: {
                    SnowflakeFileTransferAgent.pushFileToRemoteStore(metadata.getStageInfo(), destFileName, uploadStream, fileBackedOutputStream, uploadSize, digest, requireCompress ? FileCompressionType.GZIP : null, initialClient, config.getSession(), config.getCommand(), 1, fileToUpload, fileToUpload == null, encMat, streamingIngestClientName, streamingIngestClientKey, queryId);
                    return;
                }
                case GCS: {
                    destFileName = metadata.isForOneFile() ? metadata.getPresignedUrlFileName() : config.getDestFileName();
                    SnowflakeFileTransferAgent.pushFileToRemoteStoreWithPresignedUrl(metadata.getStageInfo(), destFileName, uploadStream, fileBackedOutputStream, uploadSize, digest, requireCompress ? FileCompressionType.GZIP : null, initialClient, networkTimeoutInMilli, key, 1, null, true, encMat, metadata.getPresignedUrl(), streamingIngestClientName, streamingIngestClientKey, queryId);
                    return;
                }
            }
            return;
        }
        catch (Exception ex) {
            logger.error("Exception encountered during file upload in uploadWithoutConnection", ex);
            throw ex;
        }
        finally {
            if (fileBackedOutputStream != null) {
                try {
                    fileBackedOutputStream.reset();
                }
                catch (IOException ex) {
                    logger.debug("Failed to clean up temp file: {}", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pushFileToRemoteStoreWithPresignedUrl(StageInfo stage, String destFileName, InputStream inputStream, FileBackedOutputStream fileBackedOutStr, long uploadSize, String digest, FileCompressionType compressionType, SnowflakeStorageClient initialClient, int networkTimeoutInMilli, HttpClientSettingsKey ocspModeAndProxyKey, int parallel, File srcFile, boolean uploadFromStream, RemoteStoreFileEncryptionMaterial encMat, String presignedUrl, String streamingIngestClientName, String streamingIngestClientKey, String queryId) throws SQLException, IOException {
        remoteLocation remoteLocation2 = SnowflakeFileTransferAgent.extractLocationAndPath(stage.getLocation());
        if (remoteLocation2.path != null && !remoteLocation2.path.isEmpty()) {
            destFileName = remoteLocation2.path + (!remoteLocation2.path.endsWith("/") ? "/" : "") + destFileName;
        }
        logger.debug("Upload object. Location: {}, key: {}, srcFile: {}, encryption: {}", remoteLocation2.location, destFileName, srcFile, () -> encMat == null ? "NULL" : encMat.getSmkId() + "|" + encMat.getQueryId());
        StorageObjectMetadata meta = storageFactory.createStorageMetadataObj(stage.getStageType());
        meta.setContentLength(uploadSize);
        if (digest != null) {
            initialClient.addDigestMetadata(meta, digest);
        }
        if (compressionType != null && compressionType.isSupported()) {
            meta.setContentEncoding(compressionType.name().toLowerCase());
        }
        if (streamingIngestClientName != null && streamingIngestClientKey != null) {
            initialClient.addStreamingIngestMetadata(meta, streamingIngestClientName, streamingIngestClientKey);
        }
        try {
            initialClient.uploadWithPresignedUrlWithoutConnection(networkTimeoutInMilli, ocspModeAndProxyKey, parallel, uploadFromStream, remoteLocation2.location, srcFile, destFileName, inputStream, fileBackedOutStr, meta, stage.getRegion(), presignedUrl, queryId);
        }
        finally {
            if (uploadFromStream && inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static void renewExpiredToken(SFSession session, String command, SnowflakeStorageClient client) throws SnowflakeSQLException {
        SFStatement statement = new SFStatement(session);
        JsonNode jsonNode = SnowflakeFileTransferAgent.parseCommandInGS(statement, command);
        String queryId = jsonNode.path("data").path("queryId").asText();
        Map<?, ?> stageCredentials = SnowflakeFileTransferAgent.extractStageCreds(jsonNode, queryId);
        logger.debug("Renewing expired access token", new Object[0]);
        client.renew(stageCredentials);
    }

    private static void pullFileFromRemoteStore(StageInfo stage, String filePath, String destFileName, String localLocation, SnowflakeStorageClient initialClient, SFSession session, String command, int parallel, RemoteStoreFileEncryptionMaterial encMat, String presignedUrl, String queryId) throws SQLException {
        remoteLocation remoteLocation2 = SnowflakeFileTransferAgent.extractLocationAndPath(stage.getLocation());
        String stageFilePath = filePath;
        if (!remoteLocation2.path.isEmpty()) {
            stageFilePath = SnowflakeUtil.concatFilePathNames(remoteLocation2.path, filePath, "/");
        }
        logger.debug("Download object. Location: {}, key: {}, srcFile: {}, encryption: {}", remoteLocation2.location, stageFilePath, filePath, () -> encMat == null ? "NULL" : encMat.getSmkId() + "|" + encMat.getQueryId());
        initialClient.download(session, command, localLocation, destFileName, parallel, remoteLocation2.location, stageFilePath, stage.getRegion(), presignedUrl, queryId);
    }

    private void filterExistingFiles() throws SnowflakeSQLException {
        HashMap<String, String> destFileNameToSrcFileMap = new HashMap<String, String>(this.fileMetadataMap.size());
        logger.debug("Build reverse map from destination file name to source file", new Object[0]);
        for (Map.Entry<String, FileMetadata> entry : this.fileMetadataMap.entrySet()) {
            if (entry.getValue().destFileName != null) {
                String prevSrcFile = destFileNameToSrcFileMap.put(entry.getValue().destFileName, entry.getKey());
                if (prevSrcFile == null) continue;
                FileMetadata prevFileMetadata = this.fileMetadataMap.get(prevSrcFile);
                prevFileMetadata.resultStatus = ResultStatus.COLLISION;
                prevFileMetadata.errorDetails = prevSrcFile + " has same name as " + entry.getKey();
                continue;
            }
            logger.debug("No dest file name found for: {}", entry.getKey());
            logger.debug("Status: {}", new Object[]{entry.getValue().resultStatus});
        }
        if (destFileNameToSrcFileMap.size() == 0) {
            return;
        }
        Object[] stageFileNames = this.commandType == SFBaseFileTransferAgent.CommandType.UPLOAD ? destFileNameToSrcFileMap.keySet().toArray(new String[0]) : destFileNameToSrcFileMap.values().toArray(new String[0]);
        Arrays.sort(stageFileNames);
        String greatestCommonPrefix = SnowflakeUtil.greatestCommonPrefix((String)stageFileNames[0], (String)stageFileNames[stageFileNames.length - 1]);
        logger.debug("Greatest common prefix: {}", greatestCommonPrefix);
        if (this.stageInfo.getStageType() == StageInfo.StageType.S3 || this.stageInfo.getStageType() == StageInfo.StageType.AZURE || this.stageInfo.getStageType() == StageInfo.StageType.GCS) {
            logger.debug("Check existing files on remote storage for the common prefix", new Object[0]);
            remoteLocation storeLocation = SnowflakeFileTransferAgent.extractLocationAndPath(this.stageInfo.getLocation());
            StorageObjectSummaryCollection objectSummaries = null;
            int retryCount = 0;
            logger.debug("Start dragging object summaries from remote storage", new Object[0]);
            do {
                try {
                    if (SnowflakeFileTransferAgent.isInjectedFileTransferExceptionEnabled() && injectedFileTransferException instanceof StorageProviderException) {
                        throw (StorageProviderException)injectedFileTransferException;
                    }
                    objectSummaries = this.storageClient.listObjects(storeLocation.location, SnowflakeUtil.concatFilePathNames(storeLocation.path, greatestCommonPrefix, "/"));
                    logger.debug("Received object summaries from remote storage", new Object[0]);
                }
                catch (Exception ex) {
                    logger.debug("Listing objects for filtering encountered exception: {}", ex.getMessage());
                    if (ex instanceof StorageProviderException) {
                        ex = (Exception)ex.getCause();
                    }
                    this.storageClient.handleStorageException(ex, ++retryCount, "listObjects", this.session, this.command, this.queryID);
                    continue;
                }
                try {
                    this.compareAndSkipRemoteFiles(objectSummaries, destFileNameToSrcFileMap);
                    break;
                }
                catch (Exception ex) {
                    logger.debug("Comparison with existing files in remote storage encountered exception.", ex);
                    if (ex instanceof StorageProviderException) {
                        ex = (Exception)ex.getCause();
                    }
                    this.storageClient.handleStorageException(ex, ++retryCount, "compareRemoteFiles", this.session, this.command, this.queryID);
                }
            } while (retryCount <= this.storageClient.getMaxRetries());
        } else if (this.stageInfo.getStageType() == StageInfo.StageType.LOCAL_FS) {
            for (Object stageFileName : stageFileNames) {
                Object localFile;
                String stageFilePath = SnowflakeUtil.concatFilePathNames(this.stageInfo.getLocation(), (String)stageFileName, localFSFileSep);
                File stageFile = new File(stageFilePath);
                if (!stageFile.exists()) continue;
                Object mappedSrcFile = this.commandType == SFBaseFileTransferAgent.CommandType.UPLOAD ? (String)destFileNameToSrcFileMap.get(stageFileName) : stageFileName;
                Object object = localFile = this.commandType == SFBaseFileTransferAgent.CommandType.UPLOAD ? mappedSrcFile : this.localLocation + this.fileMetadataMap.get((Object)mappedSrcFile).destFileName;
                if (this.commandType == SFBaseFileTransferAgent.CommandType.UPLOAD && ((String)stageFileName).equals(this.fileMetadataMap.get((Object)mappedSrcFile).destFileName)) {
                    this.skipFile((String)mappedSrcFile, (String)stageFileName);
                    continue;
                }
                if (!this.fileMetadataMap.get((Object)mappedSrcFile).requireCompress && stageFile.length() != new File((String)localFile).length()) {
                    logger.debug("Size diff between stage and local, will {} {}", this.commandType.name().toLowerCase(), mappedSrcFile);
                    continue;
                }
                String localFileHashText = null;
                String stageFileHashText = null;
                ArrayList<FileBackedOutputStream> fileBackedOutputStreams = new ArrayList<FileBackedOutputStream>();
                InputStream localFileStream = null;
                try {
                    Object res;
                    localFileStream = new FileInputStream((String)localFile);
                    if (this.fileMetadataMap.get((Object)mappedSrcFile).requireCompress) {
                        logger.debug("Compressing stream for digest check", new Object[0]);
                        res = SnowflakeFileTransferAgent.compressStreamWithGZIP(localFileStream, this.session, this.queryID);
                        fileBackedOutputStreams.add(((InputStreamWithMetadata)res).fileBackedOutputStream);
                        localFileStream = ((InputStreamWithMetadata)res).fileBackedOutputStream.asByteSource().openStream();
                    }
                    res = SnowflakeFileTransferAgent.computeDigest(localFileStream, false);
                    localFileHashText = ((InputStreamWithMetadata)res).digest;
                    fileBackedOutputStreams.add(((InputStreamWithMetadata)res).fileBackedOutputStream);
                }
                catch (IOException | NoSuchAlgorithmException ex) {
                    throw new SnowflakeSQLLoggedException(this.queryID, (SFBaseSession)this.session, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), ex, "Error reading local file: " + (String)localFile);
                }
                finally {
                    for (FileBackedOutputStream stream : fileBackedOutputStreams) {
                        if (stream == null) continue;
                        try {
                            stream.reset();
                        }
                        catch (IOException ex) {
                            logger.debug("Failed to clean up temp file: {}", ex);
                        }
                    }
                    IOUtils.closeQuietly(localFileStream);
                }
                FileBackedOutputStream fileBackedOutputStream = null;
                FileInputStream stageFileStream = null;
                try {
                    stageFileStream = new FileInputStream(stageFilePath);
                    InputStreamWithMetadata res = SnowflakeFileTransferAgent.computeDigest(stageFileStream, false);
                    stageFileHashText = res.digest;
                    fileBackedOutputStream = res.fileBackedOutputStream;
                }
                catch (IOException | NoSuchAlgorithmException ex) {
                    throw new SnowflakeSQLLoggedException(this.queryID, (SFBaseSession)this.session, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), ex, "Error reading stage file: " + stageFilePath);
                }
                finally {
                    try {
                        if (fileBackedOutputStream != null) {
                            fileBackedOutputStream.reset();
                        }
                    }
                    catch (IOException ex) {
                        logger.debug("Failed to clean up temp file: {}", ex);
                    }
                    IOUtils.closeQuietly(stageFileStream);
                }
                if (!stageFileHashText.equals(localFileHashText)) {
                    logger.debug("Digest diff between local and stage, will {} {}", this.commandType.name().toLowerCase(), mappedSrcFile);
                    continue;
                }
                logger.debug("Digest matches between local and stage, will skip {}", mappedSrcFile);
                this.skipFile((String)mappedSrcFile, (String)stageFileName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareAndSkipRemoteFiles(StorageObjectSummaryCollection objectSummaries, Map<String, String> destFileNameToSrcFileMap) throws SnowflakeSQLException {
        for (StorageObjectSummary obj : objectSummaries) {
            logger.debug("Existing object: key: {} size: {} md5: {}", obj.getKey(), obj.getSize(), obj.getMD5());
            int idxOfLastFileSep = obj.getKey().lastIndexOf("/");
            String objFileName = obj.getKey().substring(idxOfLastFileSep + 1);
            String mappedSrcFile = destFileNameToSrcFileMap.get(objFileName);
            if (mappedSrcFile == null) continue;
            logger.debug("Next compare digest for {} against {} on the remote store", mappedSrcFile, objFileName);
            String localFile = null;
            try {
                StorageObjectMetadata meta;
                if (SnowflakeFileTransferAgent.isInjectedFileTransferExceptionEnabled()) {
                    throw (NoSuchAlgorithmException)injectedFileTransferException;
                }
                String string = localFile = this.commandType == SFBaseFileTransferAgent.CommandType.UPLOAD ? mappedSrcFile : this.localLocation + objFileName;
                if (this.commandType == SFBaseFileTransferAgent.CommandType.DOWNLOAD && !new File(localFile).exists()) {
                    logger.debug("File does not exist locally, will download {}", mappedSrcFile);
                    continue;
                }
                if (this.commandType == SFBaseFileTransferAgent.CommandType.UPLOAD && objFileName.equals(this.fileMetadataMap.get((Object)mappedSrcFile).destFileName)) {
                    this.skipFile(mappedSrcFile, objFileName);
                    continue;
                }
                if (!this.fileMetadataMap.get((Object)mappedSrcFile).requireCompress && Math.abs(obj.getSize() - new File(localFile).length()) > 16L) {
                    logger.debug("Size diff between remote and local, will {} {}", this.commandType.name().toLowerCase(), mappedSrcFile);
                    continue;
                }
                try {
                    meta = this.storageClient.getObjectMetadata(obj.getLocation(), obj.getKey());
                }
                catch (StorageProviderException spEx) {
                    if (spEx.isServiceException404()) {
                        logger.debug("File returned from listing but found missing {} when getting its metadata. Location: {}, key: {}", obj.getLocation(), obj.getKey());
                        continue;
                    }
                    logger.error("Fetching object metadata encountered exception: {}", spEx.getMessage());
                    throw spEx;
                }
                String objDigest = this.storageClient.getDigestMetadata(meta);
                boolean remoteEncrypted = MatDesc.parse(meta.getUserMetadata().get(this.storageClient.getMatdescKey())) != null;
                InputStream fileStream = null;
                String hashText = null;
                ArrayList<FileBackedOutputStream> fileBackedOutputStreams = new ArrayList<FileBackedOutputStream>();
                try {
                    InputStreamWithMetadata res;
                    fileStream = new FileInputStream(localFile);
                    if (this.fileMetadataMap.get((Object)mappedSrcFile).requireCompress) {
                        logger.debug("Compressing stream for digest check", new Object[0]);
                        res = SnowflakeFileTransferAgent.compressStreamWithGZIP(fileStream, this.session, this.queryID);
                        fileStream = res.fileBackedOutputStream.asByteSource().openStream();
                        fileBackedOutputStreams.add(res.fileBackedOutputStream);
                    }
                    if (objDigest != null) {
                        res = SnowflakeFileTransferAgent.computeDigest(fileStream, false);
                        hashText = res.digest;
                        fileBackedOutputStreams.add(res.fileBackedOutputStream);
                    } else if (!remoteEncrypted) {
                        hashText = DigestUtils.md5Hex(fileStream);
                    }
                }
                finally {
                    if (fileStream != null) {
                        ((InputStream)fileStream).close();
                    }
                    for (FileBackedOutputStream stream : fileBackedOutputStreams) {
                        if (stream == null) continue;
                        try {
                            stream.reset();
                        }
                        catch (IOException ex) {
                            logger.debug("Failed to clean up temp file: {}", ex);
                        }
                    }
                }
                if (hashText == null || objDigest != null && !hashText.equals(objDigest) || objDigest == null && !hashText.equals(obj.getMD5())) {
                    logger.debug("Digest diff between remote store and local, will {} {}, local digest: {}, remote store md5: {}", this.commandType.name().toLowerCase(), mappedSrcFile, hashText, obj.getMD5());
                    continue;
                }
            }
            catch (IOException | NoSuchAlgorithmException ex) {
                throw new SnowflakeSQLLoggedException(this.queryID, (SFBaseSession)this.session, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), ex, "Error reading: " + localFile);
            }
            logger.debug("Digest same between remote store and local, will not upload {} {}", this.commandType.name().toLowerCase(), mappedSrcFile);
            this.skipFile(mappedSrcFile, objFileName);
        }
    }

    private void skipFile(String srcFilePath, String destFileName) {
        FileMetadata fileMetadata = this.fileMetadataMap.get(srcFilePath);
        if (fileMetadata != null) {
            if (fileMetadata.resultStatus == null || fileMetadata.resultStatus == ResultStatus.UNKNOWN) {
                logger.debug("Mark {} as skipped", srcFilePath);
                fileMetadata.resultStatus = ResultStatus.SKIPPED;
                fileMetadata.errorDetails = "File with same destination name and checksum already exists: " + destFileName;
            } else {
                logger.debug("No need to mark as skipped for: {} status was already marked as: {}", new Object[]{srcFilePath, fileMetadata.resultStatus});
            }
        }
    }

    private void initFileMetadata() throws SnowflakeSQLException {
        block6: {
            block5: {
                this.fileMetadataMap = new HashMap<String, FileMetadata>(this.sourceFiles.size());
                if (this.commandType != SFBaseFileTransferAgent.CommandType.UPLOAD) break block5;
                if (this.sourceFromStream) {
                    FileMetadata fileMetadata = new FileMetadata();
                    this.fileMetadataMap.put(SRC_FILE_NAME_FOR_STREAM, fileMetadata);
                    fileMetadata.srcFileName = SRC_FILE_NAME_FOR_STREAM;
                } else {
                    for (String sourceFile : this.sourceFiles) {
                        FileMetadata fileMetadata = new FileMetadata();
                        this.fileMetadataMap.put(sourceFile, fileMetadata);
                        File file = new File(sourceFile);
                        fileMetadata.srcFileName = file.getName();
                        fileMetadata.srcFileSize = file.length();
                        if (!file.exists()) {
                            logger.debug("File doesn't exist: {}", sourceFile);
                            throw new SnowflakeSQLLoggedException(this.queryID, (SFBaseSession)this.session, (int)ErrorCode.FILE_NOT_FOUND.getMessageCode(), "22000", sourceFile);
                        }
                        if (!file.isDirectory()) continue;
                        logger.debug("Not a file, but directory: {}", sourceFile);
                        throw new SnowflakeSQLLoggedException(this.queryID, (SFBaseSession)this.session, (int)ErrorCode.FILE_IS_DIRECTORY.getMessageCode(), "22000", sourceFile);
                    }
                }
                break block6;
            }
            if (this.commandType != SFBaseFileTransferAgent.CommandType.DOWNLOAD) break block6;
            for (String sourceFile : this.sourceFiles) {
                FileMetadata fileMetadata = new FileMetadata();
                this.fileMetadataMap.put(sourceFile, fileMetadata);
                fileMetadata.srcFileName = sourceFile;
                fileMetadata.destFileName = sourceFile.substring(sourceFile.lastIndexOf("/") + 1);
            }
        }
    }

    static Optional<FileCompressionType> mimeTypeToCompressionType(String mimeTypeStr) {
        if (mimeTypeStr == null) {
            return Optional.empty();
        }
        int slashIndex = mimeTypeStr.indexOf(47);
        if (slashIndex < 0) {
            return Optional.empty();
        }
        int semiColonIndex = mimeTypeStr.indexOf(59);
        String subType = semiColonIndex < 0 ? mimeTypeStr.substring(slashIndex + 1).trim().toLowerCase(Locale.ENGLISH) : mimeTypeStr.substring(slashIndex + 1, semiColonIndex);
        if (Strings.isNullOrEmpty(subType)) {
            return Optional.empty();
        }
        return FileCompressionType.lookupByMimeSubType(subType);
    }

    private void processFileCompressionTypes() throws SnowflakeSQLException {
        boolean autoDetect = true;
        FileCompressionType userSpecifiedSourceCompression = null;
        if (SOURCE_COMPRESSION_AUTO_DETECT.equalsIgnoreCase(this.sourceCompression)) {
            autoDetect = true;
        } else if (SOURCE_COMPRESSION_NONE.equalsIgnoreCase(this.sourceCompression)) {
            autoDetect = false;
        } else {
            Optional<FileCompressionType> foundCompType = FileCompressionType.lookupByMimeSubType(this.sourceCompression.toLowerCase());
            if (!foundCompType.isPresent()) {
                throw new SnowflakeSQLLoggedException(this.queryID, (SFBaseSession)this.session, (int)ErrorCode.COMPRESSION_TYPE_NOT_KNOWN.getMessageCode(), "0A000", this.sourceCompression);
            }
            userSpecifiedSourceCompression = (FileCompressionType)((Object)foundCompType.get());
            if (!userSpecifiedSourceCompression.isSupported()) {
                throw new SnowflakeSQLLoggedException(this.queryID, (SFBaseSession)this.session, (int)ErrorCode.COMPRESSION_TYPE_NOT_SUPPORTED.getMessageCode(), "0A000", this.sourceCompression);
            }
            autoDetect = false;
        }
        if (!this.sourceFromStream) {
            for (String srcFile : this.sourceFiles) {
                FileMetadata fileMetadata = this.fileMetadataMap.get(srcFile);
                if (fileMetadata.resultStatus == ResultStatus.NONEXIST || fileMetadata.resultStatus == ResultStatus.DIRECTORY) continue;
                File file = new File(srcFile);
                String srcFileName = file.getName();
                String mimeTypeStr = null;
                FileCompressionType currentFileCompressionType = null;
                try {
                    if (autoDetect) {
                        Optional<FileCompressionType> foundCompType;
                        mimeTypeStr = Files.probeContentType(file.toPath());
                        if (mimeTypeStr == null) {
                            try (FileInputStream f = new FileInputStream(file);){
                                byte[] magic = new byte[4];
                                if (f.read(magic, 0, 4) == 4) {
                                    if (Arrays.equals(magic, new byte[]{80, 65, 82, 49})) {
                                        mimeTypeStr = "snowflake/parquet";
                                    } else if (Arrays.equals(Arrays.copyOfRange(magic, 0, 3), new byte[]{79, 82, 67})) {
                                        mimeTypeStr = "snowflake/orc";
                                    }
                                }
                            }
                        }
                        if (mimeTypeStr != null) {
                            logger.debug("Mime type for {} is: {}", srcFile, mimeTypeStr);
                            foundCompType = SnowflakeFileTransferAgent.mimeTypeToCompressionType(mimeTypeStr);
                            if (foundCompType.isPresent()) {
                                currentFileCompressionType = foundCompType.get();
                            }
                        }
                        if (currentFileCompressionType == null && (mimeTypeStr = this.getMimeTypeFromFileExtension(srcFile)) != null) {
                            logger.debug("Mime type for {} is: {}", srcFile, mimeTypeStr);
                            foundCompType = SnowflakeFileTransferAgent.mimeTypeToCompressionType(mimeTypeStr);
                            if (foundCompType.isPresent()) {
                                currentFileCompressionType = foundCompType.get();
                            }
                        }
                    } else {
                        currentFileCompressionType = userSpecifiedSourceCompression;
                    }
                    if (currentFileCompressionType != null) {
                        fileMetadata.srcCompressionType = currentFileCompressionType;
                        if (currentFileCompressionType.isSupported()) {
                            fileMetadata.destCompressionType = currentFileCompressionType;
                            fileMetadata.requireCompress = false;
                            fileMetadata.destFileName = srcFileName;
                            logger.debug("File compression detected as {} for: {}", currentFileCompressionType.name(), srcFile);
                            continue;
                        }
                        throw new SnowflakeSQLLoggedException(this.queryID, (SFBaseSession)this.session, (int)ErrorCode.COMPRESSION_TYPE_NOT_SUPPORTED.getMessageCode(), "0A000", currentFileCompressionType.name());
                    }
                    logger.debug("Compression not found for file: {}", srcFile);
                    fileMetadata.requireCompress = this.autoCompress;
                    fileMetadata.srcCompressionType = null;
                    if (this.autoCompress) {
                        fileMetadata.destFileName = srcFileName + FileCompressionType.GZIP.getFileExtension();
                        fileMetadata.destCompressionType = FileCompressionType.GZIP;
                        continue;
                    }
                    fileMetadata.destFileName = srcFileName;
                    fileMetadata.destCompressionType = null;
                }
                catch (Exception ex) {
                    if (ex instanceof SnowflakeSQLException) {
                        logger.debug("Exception encountered when processing file compression types", ex);
                    } else {
                        logger.debug("Exception encountered when processing file compression types", ex);
                    }
                    fileMetadata.resultStatus = ResultStatus.ERROR;
                    fileMetadata.errorDetails = ex.getMessage();
                }
            }
        } else {
            FileMetadata fileMetadata = this.fileMetadataMap.get(SRC_FILE_NAME_FOR_STREAM);
            fileMetadata.srcCompressionType = userSpecifiedSourceCompression;
            if (this.compressSourceFromStream) {
                fileMetadata.destCompressionType = FileCompressionType.GZIP;
                fileMetadata.requireCompress = true;
            } else {
                fileMetadata.destCompressionType = userSpecifiedSourceCompression;
                fileMetadata.requireCompress = false;
            }
            fileMetadata.destFileName = this.compressSourceFromStream && !this.destFileNameForStreamSource.endsWith(FileCompressionType.GZIP.getFileExtension()) ? this.destFileNameForStreamSource + FileCompressionType.GZIP.getFileExtension() : this.destFileNameForStreamSource;
        }
    }

    private String getMimeTypeFromFileExtension(String srcFile) {
        String srcFileLowCase = srcFile.toLowerCase();
        for (FileCompressionType compressionType : FileCompressionType.values()) {
            if (!srcFileLowCase.endsWith(compressionType.getFileExtension())) continue;
            return compressionType.getMimeType() + "/" + compressionType.getMimeSubTypes().get(0);
        }
        return null;
    }

    public static remoteLocation extractLocationAndPath(String stageLocationPath) {
        String location = stageLocationPath;
        String path = "";
        if (stageLocationPath.contains("/")) {
            location = stageLocationPath.substring(0, stageLocationPath.indexOf("/"));
            path = stageLocationPath.substring(stageLocationPath.indexOf("/") + 1);
        }
        return new remoteLocation(location, path);
    }

    private void populateStatusRows() {
        boolean sortResult;
        for (Map.Entry<String, FileMetadata> entry : this.fileMetadataMap.entrySet()) {
            FileMetadata fileMetadata = entry.getValue();
            if (this.commandType == SFBaseFileTransferAgent.CommandType.UPLOAD) {
                this.statusRows.add(this.showEncryptionParameter ? new SFBaseFileTransferAgent.UploadCommandEncryptionFacade(fileMetadata.srcFileName, fileMetadata.destFileName, fileMetadata.resultStatus.name(), fileMetadata.errorDetails, fileMetadata.srcFileSize, fileMetadata.destFileSize, fileMetadata.srcCompressionType == null ? "NONE" : fileMetadata.srcCompressionType.name(), fileMetadata.destCompressionType == null ? "NONE" : fileMetadata.destCompressionType.name(), fileMetadata.isEncrypted) : new SFBaseFileTransferAgent.UploadCommandFacade(fileMetadata.srcFileName, fileMetadata.destFileName, fileMetadata.resultStatus.name(), fileMetadata.errorDetails, fileMetadata.srcFileSize, fileMetadata.destFileSize, fileMetadata.srcCompressionType == null ? "NONE" : fileMetadata.srcCompressionType.name(), fileMetadata.destCompressionType == null ? "NONE" : fileMetadata.destCompressionType.name()));
                continue;
            }
            if (this.commandType != SFBaseFileTransferAgent.CommandType.DOWNLOAD) continue;
            this.statusRows.add(this.showEncryptionParameter ? new SFBaseFileTransferAgent.DownloadCommandEncryptionFacade(fileMetadata.srcFileName.startsWith("/") ? fileMetadata.srcFileName.substring(1) : fileMetadata.srcFileName, fileMetadata.resultStatus.name(), fileMetadata.errorDetails, fileMetadata.destFileSize, fileMetadata.isEncrypted) : new SFBaseFileTransferAgent.DownloadCommandFacade(fileMetadata.srcFileName.startsWith("/") ? fileMetadata.srcFileName.substring(1) : fileMetadata.srcFileName, fileMetadata.resultStatus.name(), fileMetadata.errorDetails, fileMetadata.destFileSize));
        }
        Object sortProperty = null;
        sortProperty = this.session.getSessionPropertyByKey("sort");
        boolean bl = sortResult = sortProperty != null && (Boolean)sortProperty != false;
        if (sortResult) {
            Comparator<Object> comparator = this.commandType == SFBaseFileTransferAgent.CommandType.UPLOAD ? new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    String srcFileNameA = ((SFBaseFileTransferAgent.UploadCommandFacade)a).getSrcFile();
                    String srcFileNameB = ((SFBaseFileTransferAgent.UploadCommandFacade)b).getSrcFile();
                    return srcFileNameA.compareTo(srcFileNameB);
                }
            } : new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    String srcFileNameA = ((SFBaseFileTransferAgent.DownloadCommandFacade)a).getFile();
                    String srcFileNameB = ((SFBaseFileTransferAgent.DownloadCommandFacade)b).getFile();
                    return srcFileNameA.compareTo(srcFileNameB);
                }
            };
            Collections.sort(this.statusRows, comparator);
        }
    }

    public Object getResultSet() throws SnowflakeSQLException {
        return new SFFixedViewResultSet(this, this.commandType, this.queryID);
    }

    public SFBaseFileTransferAgent.CommandType getCommandType() {
        return this.commandType;
    }

    @Deprecated
    public static void throwJCEMissingError(String operation, Exception ex) throws SnowflakeSQLException {
        SnowflakeFileTransferAgent.throwJCEMissingError(operation, ex, null);
    }

    public static void throwJCEMissingError(String operation, Exception ex, String queryId) throws SnowflakeSQLException {
        String msg = "Strong encryption with Java JRE requires JCE Unlimited Strength Jurisdiction Policy files. Follow JDBC client installation instructions provided by Snowflake or contact Snowflake Support.";
        logger.error("JCE Unlimited Strength policy files missing: {}. {}.", ex.getMessage(), ex.getCause().getMessage());
        String bootLib = SnowflakeUtil.systemGetProperty("sun.boot.library.path");
        if (bootLib != null) {
            msg = msg + " The target directory on your system is: " + Paths.get(bootLib, "security").toString();
            logger.error(msg, new Object[0]);
        }
        throw new SnowflakeSQLException(queryId, ex, "58000", ErrorCode.AWS_CLIENT_ERROR.getMessageCode(), operation, msg);
    }

    @Deprecated
    public static void throwNoSpaceLeftError(SFSession session, String operation, Exception ex) throws SnowflakeSQLLoggedException {
        SnowflakeFileTransferAgent.throwNoSpaceLeftError(session, operation, ex, null);
    }

    public static void throwNoSpaceLeftError(SFSession session, String operation, Exception ex, String queryId) throws SnowflakeSQLLoggedException {
        String exMessage = SnowflakeUtil.getRootCause(ex).getMessage();
        if (exMessage != null && exMessage.equals("No space left on device")) {
            throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), ex, "Encountered exception during " + operation + ": " + ex.getMessage());
        }
    }

    static /* synthetic */ Throwable access$100() {
        return injectedFileTransferException;
    }

    static /* synthetic */ InputStreamWithMetadata access$200(InputStream x0, SFBaseSession x1, String x2) throws SnowflakeSQLException {
        return SnowflakeFileTransferAgent.compressStreamWithGZIPNoDigest(x0, x1, x2);
    }

    static /* synthetic */ InputStreamWithMetadata access$300(InputStream x0, SFBaseSession x1, String x2) throws SnowflakeSQLException {
        return SnowflakeFileTransferAgent.compressStreamWithGZIP(x0, x1, x2);
    }

    static /* synthetic */ InputStreamWithMetadata access$400(InputStream x0, boolean x1) throws NoSuchAlgorithmException, IOException {
        return SnowflakeFileTransferAgent.computeDigest(x0, x1);
    }

    static /* synthetic */ boolean access$500(String x0, String x1, String x2, InputStream x3, FileBackedOutputStream x4, SFBaseSession x5, String x6) throws SQLException {
        return SnowflakeFileTransferAgent.pushFileToLocal(x0, x1, x2, x3, x4, x5, x6);
    }

    static /* synthetic */ void access$600(StageInfo x0, String x1, InputStream x2, FileBackedOutputStream x3, long x4, String x5, FileCompressionType x6, SnowflakeStorageClient x7, SFSession x8, String x9, int x10, File x11, boolean x12, RemoteStoreFileEncryptionMaterial x13, String x14, String x15, String x16) throws SQLException, IOException {
        SnowflakeFileTransferAgent.pushFileToRemoteStore(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13, x14, x15, x16);
    }

    static class InputStreamWithMetadata {
        long size;
        String digest;
        FileBackedOutputStream fileBackedOutputStream;

        InputStreamWithMetadata(long size, String digest, FileBackedOutputStream fileBackedOutputStream) {
            this.size = size;
            this.digest = digest;
            this.fileBackedOutputStream = fileBackedOutputStream;
        }
    }

    private class FileMetadata {
        public String srcFileName;
        public long srcFileSize;
        public String destFileName;
        public long destFileSize;
        public boolean requireCompress;
        public ResultStatus resultStatus = ResultStatus.UNKNOWN;
        public String errorDetails = "";
        public FileCompressionType srcCompressionType;
        public FileCompressionType destCompressionType;
        public boolean isEncrypted = false;

        private FileMetadata() {
        }
    }

    private static class remoteLocation {
        String location;
        String path;

        public remoteLocation(String remoteStorageLocation, String remotePath) {
            this.location = remoteStorageLocation;
            this.path = remotePath;
        }
    }

    public static enum ResultStatus {
        UNKNOWN("Unknown status"),
        UPLOADED("File uploaded"),
        UNSUPPORTED("File type not supported"),
        ERROR("Error encountered"),
        SKIPPED("Skipped since file exists"),
        NONEXIST("File does not exist"),
        COLLISION("File name collides with another file"),
        DIRECTORY("Not a file, but directory"),
        DOWNLOADED("File downloaded");

        private String desc;

        public String getDesc() {
            return this.desc;
        }

        private ResultStatus(String desc) {
            this.desc = desc;
        }
    }
}

