/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.cloud.NoCredentials;
import net.snowflake.client.jdbc.internal.google.cloud.ServiceDefaults;
import net.snowflake.client.jdbc.internal.google.cloud.ServiceOptions;
import net.snowflake.client.jdbc.internal.google.cloud.http.HttpTransportOptions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.GrpcStorageOptions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.HttpStorageOptions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Storage;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageFactory;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageRetryStrategy;
import net.snowflake.client.jdbc.internal.google.cloud.storage.TransportCompatibility;
import net.snowflake.client.jdbc.internal.google.cloud.storage.spi.StorageRpcFactory;

public abstract class StorageOptions
extends ServiceOptions<Storage, StorageOptions> {
    private static final long serialVersionUID = -7295846567928013233L;

    StorageOptions(Builder builder, StorageDefaults serviceDefaults) {
        super(StorageFactory.class, StorageRpcFactory.class, builder, serviceDefaults);
    }

    @Deprecated
    public static HttpTransportOptions getDefaultHttpTransportOptions() {
        return HttpStorageOptions.defaults().getDefaultTransportOptions();
    }

    @Override
    protected boolean projectIdRequired() {
        return false;
    }

    @Override
    public abstract Builder toBuilder();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public static StorageOptions getDefaultInstance() {
        return HttpStorageOptions.newBuilder().build();
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public static StorageOptions getUnauthenticatedInstance() {
        return HttpStorageOptions.newBuilder().setCredentials(NoCredentials.getInstance()).build();
    }

    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public static Builder newBuilder() {
        return StorageOptions.http();
    }

    @BetaApi
    @TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
    public static HttpStorageOptions.Builder http() {
        return HttpStorageOptions.newBuilder();
    }

    @BetaApi
    @TransportCompatibility(value={TransportCompatibility.Transport.GRPC})
    public static GrpcStorageOptions.Builder grpc() {
        return GrpcStorageOptions.newBuilder();
    }

    static abstract class StorageDefaults
    implements ServiceDefaults<Storage, StorageOptions> {
        StorageDefaults() {
        }
    }

    public static abstract class Builder
    extends ServiceOptions.Builder<Storage, StorageOptions, Builder> {
        Builder() {
        }

        Builder(StorageOptions options) {
            super(options);
        }

        public abstract Builder setStorageRetryStrategy(StorageRetryStrategy var1);

        public abstract StorageOptions build();
    }

    @Deprecated
    public static class DefaultStorageRpcFactory
    extends HttpStorageOptions.HttpStorageRpcFactory {
        @Deprecated
        public DefaultStorageRpcFactory() {
        }
    }

    @Deprecated
    public static class DefaultStorageFactory
    extends HttpStorageOptions.HttpStorageFactory {
        @Deprecated
        public DefaultStorageFactory() {
        }
    }
}

