/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BufferHandle;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BufferedWritableByteChannelSession;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Buffers;
import net.snowflake.client.jdbc.internal.google.cloud.storage.UnbufferedWritableByteChannelSession;

final class DefaultBufferedWritableByteChannel
implements BufferedWritableByteChannelSession.BufferedWritableByteChannel {
    private final BufferHandle handle;
    private final UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel channel;

    DefaultBufferedWritableByteChannel(BufferHandle handle, UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel channel) {
        this.handle = handle;
        this.channel = channel;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!this.channel.isOpen()) {
            throw new ClosedChannelException();
        }
        int bytesConsumed = 0;
        while (src.hasRemaining()) {
            int srcRemaining = src.remaining();
            int srcPosition = src.position();
            int capacity = this.handle.capacity();
            int bufferRemaining = this.handle.remaining();
            int bufferPending = capacity - bufferRemaining;
            boolean enqueuedBytes = this.enqueuedBytes();
            if (srcRemaining < bufferRemaining) {
                ((ByteBuffer)this.handle.get()).put(src);
                bytesConsumed += srcRemaining;
                break;
            }
            if (enqueuedBytes) {
                ByteBuffer buf;
                int sliceLimit = bufferRemaining;
                boolean usingSlice = false;
                if (srcRemaining == bufferRemaining) {
                    buf = src;
                } else {
                    ByteBuffer slice = src.slice();
                    Buffers.limit(slice, sliceLimit);
                    usingSlice = true;
                    buf = slice;
                }
                ByteBuffer buffer = (ByteBuffer)this.handle.get();
                Buffers.flip(buffer);
                ByteBuffer[] srcs = new ByteBuffer[]{buffer, buf};
                long write = this.channel.write(srcs);
                if (write == (long)capacity) {
                    Buffers.clear(buffer);
                    if (usingSlice) {
                        Buffers.position(src, srcPosition + sliceLimit);
                    }
                    bytesConsumed += sliceLimit;
                    continue;
                }
                if (buffer.hasRemaining()) {
                    buffer.compact();
                    continue;
                }
                Buffers.clear(buffer);
                int sliceWritten = Math.toIntExact(write - (long)bufferPending);
                Buffers.position(src, srcPosition + sliceWritten);
                bytesConsumed += sliceWritten;
                continue;
            }
            if (bufferRemaining == srcRemaining) {
                bytesConsumed += this.channel.write(src);
                continue;
            }
            ByteBuffer slice = src.slice();
            Buffers.limit(slice, bufferRemaining);
            int write = this.channel.write(slice);
            Buffers.position(src, srcPosition + write);
            bytesConsumed += write;
        }
        return bytesConsumed;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        try (UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel ignored = this.channel;){
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.enqueuedBytes()) {
            ByteBuffer buffer = (ByteBuffer)this.handle.get();
            Buffers.flip(buffer);
            this.channel.write(buffer);
            if (buffer.hasRemaining()) {
                buffer.compact();
            } else {
                Buffers.clear(buffer);
            }
        }
    }

    private boolean enqueuedBytes() {
        return this.handle.position() > 0;
    }
}

