/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.snowflake.client.core.BasicEvent;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.ParameterBindingDTO;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFBaseStatement;
import net.snowflake.client.core.SFChildResult;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFFixedViewResultSet;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SFPreparedStatementMetaData;
import net.snowflake.client.core.SFResultSetFactory;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.core.StmtUtil;
import net.snowflake.client.core.UUIDUtils;
import net.snowflake.client.core.bind.BindException;
import net.snowflake.client.core.bind.BindUploader;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.QueryStatusV2;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeReauthenticationRequest;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.telemetry.TelemetryData;
import net.snowflake.client.jdbc.telemetry.TelemetryField;
import net.snowflake.client.jdbc.telemetry.TelemetryUtil;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SFStatement
extends SFBaseStatement {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SFStatement.class);
    private SFSession session;
    private SFBaseResultSet resultSet = null;
    private HttpRequestBase httpRequest;
    private Boolean isClosed = false;
    private Integer sequenceId = -1;
    private String requestId = null;
    private String sqlText = null;
    private final AtomicBoolean canceling = new AtomicBoolean(false);
    private boolean isFileTransfer = false;
    private SnowflakeFileTransferAgent transferAgent = null;
    private static final int MAX_BINDING_PARAMS_FOR_LOGGING = 1000;
    private String describeJobUUID;
    private List<SFChildResult> childResults = null;
    private int conservativePrefetchThreads;
    private int conservativeResultChunkSize;
    private long conservativeMemoryLimit;

    public SFStatement(SFSession session) {
        logger.trace("SFStatement(SFSession session)", false);
        this.session = session;
        Integer queryTimeout = session == null ? null : session.getQueryTimeout();
        this.queryTimeout = queryTimeout != null ? queryTimeout : this.queryTimeout;
        this.verifyArrowSupport();
    }

    private void verifyArrowSupport() {
        if (SnowflakeDriver.isDisableArrowResultFormat()) {
            logger.debug("Disable arrow support: {}", SnowflakeDriver.getDisableArrowResultFormatMessage());
            this.statementParametersMap.put("JDBC_QUERY_RESULT_FORMAT", "JSON");
        }
    }

    private void sanityCheckQuery(String sql) throws SQLException {
        if (sql == null || sql.isEmpty()) {
            throw new SnowflakeSQLException("03000", (int)ErrorCode.INVALID_SQL.getMessageCode(), sql);
        }
    }

    private SFBaseResultSet executeQuery(String sql, Map<String, ParameterBindingDTO> parametersBinding, boolean describeOnly, boolean asyncExec, SFBaseStatement.CallingMethod caller, ExecTimeTelemetryData execTimeData) throws SQLException, SFException {
        this.sanityCheckQuery(sql);
        String trimmedSql = sql.trim();
        if (SFStatement.isFileTransfer(trimmedSql)) {
            if (!(this.session == null || this.session.getJdbcEnablePutGet() && this.session.getEnablePutGet())) {
                logger.debug("Executing file transfer locally is disabled: {}", sql);
                throw new SnowflakeSQLException("File transfers have been disabled.");
            }
            logger.debug("Executing file transfer locally: {}", sql);
            return this.executeFileTransfer(sql);
        }
        return this.executeQueryInternal(sql, parametersBinding, describeOnly, describeOnly, asyncExec, caller, execTimeData);
    }

    @Override
    public SFPreparedStatementMetaData describe(String sql) throws SFException, SQLException {
        SFBaseResultSet baseResultSet = this.executeQuery(sql, null, true, false, null, new ExecTimeTelemetryData());
        this.describeJobUUID = baseResultSet.getQueryId();
        return new SFPreparedStatementMetaData(baseResultSet.getMetaData(), baseResultSet.getStatementType(), baseResultSet.getNumberOfBinds(), baseResultSet.isArrayBindSupported(), baseResultSet.getMetaDataOfBinds(), true);
    }

    SFBaseResultSet executeQueryInternal(String sql, Map<String, ParameterBindingDTO> parameterBindings, boolean describeOnly, boolean internal, boolean asyncExec, SFBaseStatement.CallingMethod caller, ExecTimeTelemetryData execTimeData) throws SQLException, SFException {
        this.resetState();
        logger.debug("ExecuteQuery: {}", sql);
        if (this.session == null || this.session.isClosed()) {
            throw new SQLException("connection is closed");
        }
        Object result = this.executeHelper(sql, "application/snowflake", parameterBindings, describeOnly, internal, asyncExec, execTimeData);
        if (result == null) {
            throw new SnowflakeSQLLoggedException((SFBaseSession)this.session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "got null result");
        }
        Object sortProperty = this.session.getSessionPropertyByKey("sort");
        boolean sortResult = sortProperty != null && (Boolean)sortProperty != false;
        logger.debug("Creating result set", false);
        try {
            JsonNode jsonResult = (JsonNode)result;
            this.resultSet = SFResultSetFactory.getResultSet(jsonResult, this, sortResult, execTimeData);
            this.childResults = ResultUtil.getChildResults(this.session, this.requestId, jsonResult);
            if (!this.childResults.isEmpty()) {
                SFStatementType type = this.childResults.get(0).getType();
                if (caller == SFBaseStatement.CallingMethod.EXECUTE_QUERY && !type.isGenerateResultSet()) {
                    throw new SnowflakeSQLLoggedException((SFBaseSession)this.session, ErrorCode.QUERY_FIRST_RESULT_NOT_RESULT_SET, new Object[0]);
                }
                if (caller == SFBaseStatement.CallingMethod.EXECUTE_UPDATE && type.isGenerateResultSet()) {
                    throw new SnowflakeSQLLoggedException((SFBaseSession)this.session, ErrorCode.UPDATE_FIRST_RESULT_NOT_UPDATE_COUNT, new Object[0]);
                }
                this.getMoreResults();
            }
        }
        catch (OutOfMemoryError | SnowflakeSQLException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            logger.error("Exception creating result", ex);
            throw new SFException(ErrorCode.INTERNAL_ERROR, IncidentUtil.oneLiner("exception creating result", ex));
        }
        logger.debug("Done creating result set", false);
        if (asyncExec) {
            this.session.addQueryToActiveQueryList(this.resultSet.getQueryId());
        }
        execTimeData.setQueryId(this.resultSet.getQueryId());
        return this.resultSet;
    }

    private void setTimeBomb(ScheduledExecutorService executor) {
        class TimeBombTask
        implements Callable<Void> {
            private final SFStatement statement;

            TimeBombTask(SFStatement statement) {
                this.statement = statement;
            }

            @Override
            public Void call() throws SQLException {
                try {
                    this.statement.cancel();
                }
                catch (SFException ex) {
                    throw new SnowflakeSQLLoggedException((SFBaseSession)SFStatement.this.session, ex.getSqlState(), ex.getVendorCode(), ex, ex.getParams());
                }
                return null;
            }
        }
        executor.schedule(new TimeBombTask(this), (long)this.queryTimeout, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeHelper(String sql, String mediaType, Map<String, ParameterBindingDTO> bindValues, boolean describeOnly, boolean internal, boolean asyncExec, ExecTimeTelemetryData execTimeData) throws SnowflakeSQLException, SFException {
        ExecutorService executor = null;
        try {
            SFStatement sFStatement = this;
            synchronized (sFStatement) {
                if (this.isClosed.booleanValue()) {
                    throw new SFException(ErrorCode.STATEMENT_CLOSED, new Object[0]);
                }
                if (this.canceling.get()) {
                    throw new SFException(ErrorCode.QUERY_CANCELED, new Object[0]);
                }
                if (this.requestId != null) {
                    throw new SnowflakeSQLLoggedException((SFBaseSession)this.session, (int)ErrorCode.STATEMENT_ALREADY_RUNNING_QUERY.getMessageCode(), "0A000");
                }
                this.requestId = UUIDUtils.getUUID().toString();
                execTimeData.setRequestId(this.requestId);
                this.sequenceId = this.session.getAndIncrementSequenceId();
                this.sqlText = sql;
            }
            EventUtil.triggerStateTransition(BasicEvent.QueryState.QUERY_STARTED, String.format(BasicEvent.QueryState.QUERY_STARTED.getArgString(), this.requestId));
            execTimeData.setBindStart();
            int numBinds = BindUploader.arrayBindValueCount(bindValues);
            String bindStagePath = null;
            if (0 < this.session.getArrayBindStageThreshold() && this.session.getArrayBindStageThreshold() <= numBinds && !describeOnly && BindUploader.isArrayBind(bindValues)) {
                TelemetryData errorLog;
                try (BindUploader uploader = BindUploader.newInstance(this.session, this.requestId);){
                    uploader.upload(bindValues);
                    bindStagePath = uploader.getStagePath();
                }
                catch (BindException ex) {
                    logger.debug("Exception encountered trying to upload binds to stage with input stream. Attaching binds in payload instead. ", ex);
                    errorLog = TelemetryUtil.buildJobData(this.requestId, ex.type.field, 1L);
                    this.session.getTelemetryClient().addLogToBatch(errorLog);
                }
                catch (SQLException ex) {
                    logger.debug("Exception encountered trying to upload binds to stage with input stream. Attaching binds in payload instead. ", ex);
                    errorLog = TelemetryUtil.buildJobData(this.requestId, TelemetryField.FAILED_BIND_UPLOAD, 1L);
                    this.session.getTelemetryClient().addLogToBatch(errorLog);
                }
            }
            if (this.session.isConservativeMemoryUsageEnabled()) {
                logger.debug("JDBC conservative memory usage is enabled.", false);
                this.calculateConservativeMemoryUsage();
            }
            StmtUtil.StmtInput stmtInput = new StmtUtil.StmtInput();
            stmtInput.setSql(sql).setMediaType(mediaType).setInternal(internal).setDescribeOnly(describeOnly).setAsync(asyncExec).setServerUrl(this.session.getServerUrl()).setRequestId(this.requestId).setSequenceId(this.sequenceId).setParametersMap(this.statementParametersMap).setSessionToken(this.session.getSessionToken()).setNetworkTimeoutInMillis(this.session.getNetworkTimeoutInMilli()).setInjectSocketTimeout(this.session.getInjectSocketTimeout()).setInjectClientPause(this.session.getInjectClientPause()).setCanceling(this.canceling).setRetry(false).setDescribedJobId(this.describeJobUUID).setCombineDescribe(this.session.getEnableCombineDescribe()).setQuerySubmissionTime(System.currentTimeMillis()).setServiceName(this.session.getServiceName()).setOCSPMode(this.session.getOCSPMode()).setHttpClientSettingsKey(this.session.getHttpClientKey()).setMaxRetries(this.session.getMaxHttpRetries()).setQueryContextDTO(this.session.isAsyncSession() ? null : this.session.getQueryContextDTO());
            if (bindStagePath != null) {
                stmtInput.setBindValues(null).setBindStage(bindStagePath);
                this.setUseNewSqlFormat(true);
                this.statementParametersMap.put("TIMESTAMP_INPUT_FORMAT", "AUTO");
            } else {
                stmtInput.setBindValues(bindValues).setBindStage(null);
            }
            if (numBinds > 0 && this.session.getPreparedStatementLogging()) {
                if (numBinds > 1000) {
                    logger.info("Number of binds exceeds logging limit. Printing off {} binding parameters.", 1000);
                } else {
                    logger.info("Printing off {} binding parameters.", numBinds);
                }
                int counter = 0;
                if (BindUploader.isArrayBind(bindValues)) {
                    int numRowsPrinted = 1000 / bindValues.size();
                    if (numRowsPrinted <= 0) {
                        numRowsPrinted = 1;
                    }
                    for (Map.Entry entry : bindValues.entrySet()) {
                        List bindRows = (List)((ParameterBindingDTO)entry.getValue()).getValue();
                        if (numRowsPrinted >= bindRows.size()) {
                            numRowsPrinted = bindRows.size();
                        }
                        String rows = "[";
                        for (int i = 0; i < numRowsPrinted; ++i) {
                            rows = rows + (String)bindRows.get(i) + ", ";
                        }
                        rows = rows + "]";
                        logger.info("Column {}: {}", entry.getKey(), rows);
                        if ((counter += numRowsPrinted) < 1000) continue;
                        break;
                    }
                } else {
                    for (Map.Entry<String, ParameterBindingDTO> entry : bindValues.entrySet()) {
                        if (counter < 1000) {
                            ++counter;
                            logger.info("Column {}: {}", entry.getKey(), entry.getValue().getValue());
                            continue;
                        }
                        break;
                    }
                }
            }
            execTimeData.setBindEnd();
            if (this.canceling.get()) {
                logger.debug("Query cancelled", false);
                throw new SFException(ErrorCode.QUERY_CANCELED, new Object[0]);
            }
            if (this.queryTimeout > 0) {
                executor = Executors.newScheduledThreadPool(1);
                this.setTimeBomb((ScheduledExecutorService)executor);
            }
            StmtUtil.StmtOutput stmtOutput = null;
            while (true) {
                boolean sessionRenewed = false;
                try {
                    stmtOutput = StmtUtil.execute(stmtInput, execTimeData);
                }
                catch (SnowflakeSQLException ex) {
                    if (ex.getErrorCode() == 390112) {
                        try {
                            this.session.renewSession(stmtInput.sessionToken);
                        }
                        catch (SnowflakeReauthenticationRequest snowflakeReauthenticationRequest) {
                            if (this.session.isExternalbrowserAuthenticator()) {
                                this.reauthenticate();
                            }
                            throw snowflakeReauthenticationRequest;
                        }
                    } else {
                        throw ex;
                    }
                    stmtInput.setSessionToken(this.session.getSessionToken());
                    stmtInput.setRetry(true);
                    sessionRenewed = true;
                    execTimeData.incrementRetryCount();
                    execTimeData.addRetryLocation("renewSession");
                    logger.debug("Session got renewed, will retry", false);
                    if (sessionRenewed && !this.canceling.get()) continue;
                }
                break;
            }
            if (Boolean.TRUE.toString().equalsIgnoreCase(SnowflakeUtil.systemGetProperty("snowflake.enable_incident_test1"))) {
                throw new SFException(ErrorCode.STATEMENT_CLOSED, new Object[0]);
            }
            Object object = this;
            synchronized (object) {
                this.sequenceId = -1;
                this.requestId = null;
            }
            if (this.canceling.get()) {
                throw new SFException(ErrorCode.QUERY_CANCELED, new Object[0]);
            }
            logger.debug("Returning from executeHelper", false);
            if (stmtOutput != null) {
                object = stmtOutput.getResult();
                return object;
            }
            try {
                throw new SFException(ErrorCode.INTERNAL_ERROR, new Object[0]);
            }
            catch (SFException | SnowflakeSQLException ex) {
                this.isClosed = true;
                throw ex;
            }
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
            this.setUseNewSqlFormat(false);
        }
    }

    private void calculateConservativeMemoryUsage() {
        long memoryLimitInBytes;
        int clientMemoryLimit = this.session.getClientMemoryLimit();
        int clientPrefetchThread = this.session.getClientPrefetchThreads();
        int clientChunkSize = this.session.getClientResultChunkSize();
        if ((long)clientMemoryLimit == SessionUtil.DEFAULT_CLIENT_MEMORY_LIMIT) {
            long freeMemoryToUse = Runtime.getRuntime().freeMemory() * 8L / 10L;
            memoryLimitInBytes = Math.min(2L * (long)clientPrefetchThread * (long)clientChunkSize * 1024L * 1024L, freeMemoryToUse);
        } else {
            memoryLimitInBytes = (long)clientMemoryLimit * 1024L * 1024L;
        }
        this.conservativeMemoryLimit = memoryLimitInBytes;
        this.reducePrefetchThreadsAndChunkSizeToFitMemoryLimit(this.conservativeMemoryLimit, clientPrefetchThread, clientChunkSize);
    }

    private void updateConservativeResultChunkSize(int clientChunkSize) {
        if (clientChunkSize != this.conservativeResultChunkSize) {
            logger.debug("conservativeResultChunkSize changed from {} to {}", this.conservativeResultChunkSize, clientChunkSize);
            this.conservativeResultChunkSize = clientChunkSize;
            this.statementParametersMap.put("CLIENT_RESULT_CHUNK_SIZE", this.conservativeResultChunkSize);
        }
    }

    private void reducePrefetchThreadsAndChunkSizeToFitMemoryLimit(long clientMemoryLimit, int clientPrefetchThread, int clientChunkSize) {
        if (clientPrefetchThread != SessionUtil.DEFAULT_CLIENT_PREFETCH_THREADS) {
            this.conservativePrefetchThreads = clientPrefetchThread;
            while (clientChunkSize >= SessionUtil.MIN_CLIENT_CHUNK_SIZE) {
                if (clientMemoryLimit >= 2L * (long)clientPrefetchThread * (long)clientChunkSize * 1024L * 1024L) {
                    this.updateConservativeResultChunkSize(clientChunkSize);
                    return;
                }
                clientChunkSize -= this.session.getConservativeMemoryAdjustStep();
            }
            this.updateConservativeResultChunkSize(SessionUtil.MIN_CLIENT_CHUNK_SIZE);
        } else {
            while (clientPrefetchThread > 1) {
                for (clientChunkSize = SessionUtil.MAX_CLIENT_CHUNK_SIZE; clientChunkSize >= SessionUtil.MIN_CLIENT_CHUNK_SIZE; clientChunkSize -= this.session.getConservativeMemoryAdjustStep()) {
                    if (clientMemoryLimit < 2L * (long)clientPrefetchThread * (long)clientChunkSize * 1024L * 1024L) continue;
                    this.conservativePrefetchThreads = clientPrefetchThread;
                    this.updateConservativeResultChunkSize(clientChunkSize);
                    return;
                }
                --clientPrefetchThread;
            }
            this.conservativePrefetchThreads = clientPrefetchThread;
            this.updateConservativeResultChunkSize(SessionUtil.MIN_CLIENT_CHUNK_SIZE);
        }
    }

    @Override
    public int getConservativePrefetchThreads() {
        return this.conservativePrefetchThreads;
    }

    @Override
    public long getConservativeMemoryLimit() {
        return this.conservativeMemoryLimit;
    }

    @Override
    public String[] getChildQueryIds(String queryID) throws SQLException {
        QueryStatusV2 qs = this.session.getQueryStatusV2(queryID);
        if (qs.isStillRunning()) {
            throw new SQLException("Status of query associated with resultSet is " + qs.getDescription() + ". Results not generated.");
        }
        try {
            JsonNode jsonResult = StmtUtil.getQueryResultJSON(queryID, this.session);
            List<SFChildResult> childResults = ResultUtil.getChildResults(this.session, this.requestId, jsonResult);
            ArrayList<String> resultList = new ArrayList<String>();
            for (int i = 0; i < childResults.size(); ++i) {
                resultList.add(childResults.get(i).getId());
            }
            if (resultList.isEmpty()) {
                resultList.add(queryID);
            }
            String[] result = new String[resultList.size()];
            resultList.toArray(result);
            return result;
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex);
        }
    }

    @Override
    public SFBaseResultSet execute(String sql, Map<String, ParameterBindingDTO> parametersBinding, SFBaseStatement.CallingMethod caller, ExecTimeTelemetryData execTimeData) throws SQLException, SFException {
        return this.execute(sql, false, parametersBinding, caller, execTimeData);
    }

    private void reauthenticate() throws SFException, SnowflakeSQLException {
        SFLoginInput input = new SFLoginInput().setRole(this.session.getRole()).setWarehouse(this.session.getWarehouse()).setDatabaseName(this.session.getDatabase()).setSchemaName(this.session.getSchema()).setOCSPMode(this.session.getOCSPMode()).setHttpClientSettingsKey(this.session.getHttpClientKey());
        this.session.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelHelper(String sql, String mediaType) throws SnowflakeSQLException, SFException {
        SFStatement sFStatement = this;
        synchronized (sFStatement) {
            if (this.isClosed.booleanValue()) {
                throw new SFException(ErrorCode.INTERNAL_ERROR, "statement already closed");
            }
        }
        StmtUtil.StmtInput stmtInput = new StmtUtil.StmtInput();
        stmtInput.setServerUrl(this.session.getServerUrl()).setSql(sql).setMediaType(mediaType).setRequestId(this.requestId).setSessionToken(this.session.getSessionToken()).setServiceName(this.session.getServiceName()).setOCSPMode(this.session.getOCSPMode()).setMaxRetries(this.session.getMaxHttpRetries()).setHttpClientSettingsKey(this.session.getHttpClientKey());
        StmtUtil.cancel(stmtInput);
        SFStatement sFStatement2 = this;
        synchronized (sFStatement2) {
            this.sequenceId = -1;
            this.requestId = null;
        }
    }

    public SFBaseResultSet execute(String sql, boolean asyncExec, Map<String, ParameterBindingDTO> parametersBinding, SFBaseStatement.CallingMethod caller, ExecTimeTelemetryData execTimeData) throws SQLException, SFException {
        TelemetryService.getInstance().updateContext(this.session.getSnowflakeConnectionString());
        this.sanityCheckQuery(sql);
        this.session.injectedDelay();
        if (this.session.getPreparedStatementLogging()) {
            logger.info("Execute: {}", sql);
        } else {
            logger.debug("Execute: {}", sql);
        }
        String trimmedSql = sql.trim();
        if (trimmedSql.length() >= 20 && trimmedSql.toLowerCase().startsWith("set-sf-property")) {
            this.executeSetProperty(sql);
            return null;
        }
        return this.executeQuery(sql, parametersBinding, false, asyncExec, caller, execTimeData);
    }

    private SFBaseResultSet executeFileTransfer(String sql) throws SQLException, SFException {
        this.session.injectedDelay();
        this.resetState();
        logger.debug("Entering executeFileTransfer", false);
        this.isFileTransfer = true;
        this.transferAgent = new SnowflakeFileTransferAgent(sql, this.session, this);
        try {
            this.transferAgent.execute();
            logger.debug("Setting result set", false);
            this.resultSet = (SFFixedViewResultSet)this.transferAgent.getResultSet();
            this.childResults = Collections.emptyList();
            logger.debug("Number of cols: {}", this.resultSet.getMetaData().getColumnCount());
            logger.debug("Completed transferring data", false);
            return this.resultSet;
        }
        catch (SQLException ex) {
            logger.debug("Exception: {}", ex.getMessage());
            throw ex;
        }
    }

    @Override
    public void close() {
        logger.trace("void close()", false);
        if (this.requestId != null) {
            EventUtil.triggerStateTransition(BasicEvent.QueryState.QUERY_ENDED, String.format(BasicEvent.QueryState.QUERY_ENDED.getArgString(), this.requestId));
        }
        this.resultSet = null;
        this.childResults = null;
        this.isClosed = true;
        if (this.httpRequest != null) {
            logger.debug("Releasing connection for the http request", false);
            this.httpRequest.releaseConnection();
            this.httpRequest = null;
        }
        this.session.getTelemetryClient().sendBatchAsync();
        this.isFileTransfer = false;
        this.transferAgent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SFException, SQLException {
        logger.trace("void cancel()", false);
        if (this.canceling.get()) {
            logger.debug("Query is already cancelled", false);
            return;
        }
        this.canceling.set(true);
        if (this.isFileTransfer) {
            if (this.transferAgent != null) {
                logger.debug("Cancel file transferring ... ", false);
                this.transferAgent.cancel();
            }
        } else {
            SFStatement sFStatement = this;
            synchronized (sFStatement) {
                if (this.requestId == null) {
                    logger.debug("No remote query outstanding", false);
                    return;
                }
            }
            this.cancelHelper(this.sqlText, "application/snowflake");
        }
    }

    private void resetState() {
        this.resultSet = null;
        this.childResults = null;
        if (this.httpRequest != null) {
            this.httpRequest.releaseConnection();
            this.httpRequest = null;
        }
        this.isClosed = false;
        this.sequenceId = -1;
        this.requestId = null;
        this.sqlText = null;
        this.canceling.set(false);
        this.isFileTransfer = false;
        this.transferAgent = null;
    }

    @Override
    public SFBaseSession getSFBaseSession() {
        return this.session;
    }

    private void setUseNewSqlFormat(boolean useNewSqlFormat) throws SFException {
        this.addProperty("NEW_SQL_FORMAT", useNewSqlFormat);
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (this.resultSet != null && (current == 1 || current == 3)) {
            this.resultSet.close();
        }
        this.resultSet = null;
        if (this.childResults == null || this.childResults.isEmpty()) {
            return false;
        }
        SFChildResult nextResult = this.childResults.remove(0);
        try {
            JsonNode result = StmtUtil.getQueryResultJSON(nextResult.getId(), this.session);
            Object sortProperty = this.session.getSessionPropertyByKey("sort");
            boolean sortResult = sortProperty != null && (Boolean)sortProperty != false;
            this.resultSet = SFResultSetFactory.getResultSet(result, this, sortResult, new ExecTimeTelemetryData());
            this.resultSet.setStatementType(nextResult.getType());
            return nextResult.getType().isGenerateResultSet();
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex);
        }
    }

    @Override
    public SFBaseResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public boolean hasChildren() {
        return !this.childResults.isEmpty();
    }

    @Override
    public SFBaseResultSet asyncExecute(String sql, Map<String, ParameterBindingDTO> parametersBinding, SFBaseStatement.CallingMethod caller, ExecTimeTelemetryData execTimeData) throws SQLException, SFException {
        return this.execute(sql, true, parametersBinding, caller, execTimeData);
    }
}

