/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import net.snowflake.client.core.FieldSchemaCreator;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SfTimestampUtil;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.BindingParameterMetadata;
import net.snowflake.client.jdbc.SnowflakeColumn;
import net.snowflake.client.jdbc.SnowflakeLoggedFeatureNotSupportedException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinary;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTime;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTimestamp;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SnowflakeDateTimeFormat;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.ThrowingTriCallable;

@SnowflakeJdbcInternalApi
public class JsonSqlOutput
implements SQLOutput {
    static final SFLogger logger = SFLoggerFactory.getLogger(JsonSqlOutput.class);
    private JSONObject json;
    private SQLData original;
    private SFBaseSession session;
    private Iterator<Field> fields;
    private BindingParameterMetadata schema;
    private TimeZone sessionTimezone;

    public JsonSqlOutput(SQLData original, SFBaseSession sfBaseSession) {
        this.original = original;
        this.session = sfBaseSession;
        this.sessionTimezone = this.getSessionTimezone(sfBaseSession);
        this.fields = JsonSqlOutput.getClassFields(original).iterator();
        this.schema = new BindingParameterMetadata("object");
        this.schema.setFields(new ArrayList<BindingParameterMetadata>());
        this.json = new JSONObject();
    }

    private TimeZone getSessionTimezone(SFBaseSession sfBaseSession) {
        String timeZoneName = (String)ResultUtil.effectiveParamValue(sfBaseSession.getCommonParameters(), "TIMEZONE");
        return TimeZone.getTimeZone(timeZoneName);
    }

    private static List<Field> getClassFields(SQLData original) {
        return Arrays.stream(original.getClass().getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers()) && !Modifier.isTransient(field.getModifiers())).collect(Collectors.toList());
    }

    @Override
    public void writeString(String value) throws SQLException {
        this.withNextValue((json, fieldName, maybeColumn) -> {
            json.put(fieldName, value);
            this.schema.getFields().add(FieldSchemaCreator.buildSchemaForText(fieldName, maybeColumn));
        });
    }

    @Override
    public void writeBoolean(boolean value) throws SQLException {
        this.withNextValue((json, fieldName, maybeColumn) -> {
            json.put(fieldName, value);
            this.schema.getFields().add(FieldSchemaCreator.buildSchemaTypeAndNameOnly(fieldName, "boolean", maybeColumn));
        });
    }

    @Override
    public void writeByte(byte value) throws SQLException {
        this.withNextValue((json, fieldName, maybeColumn) -> {
            json.put(fieldName, value);
            this.schema.getFields().add(FieldSchemaCreator.buildSchemaWithScaleAndPrecision(fieldName, "fixed", 0, 38, maybeColumn));
        });
    }

    @Override
    public void writeShort(short value) throws SQLException {
        this.withNextValue((json, fieldName, maybeColumn) -> {
            json.put(fieldName, value);
            this.schema.getFields().add(FieldSchemaCreator.buildSchemaWithScaleAndPrecision(fieldName, "fixed", 0, 38, maybeColumn));
        });
    }

    @Override
    public void writeInt(int input) throws SQLException {
        this.withNextValue((json, fieldName, maybeColumn) -> {
            json.put(fieldName, input);
            this.schema.getFields().add(FieldSchemaCreator.buildSchemaWithScaleAndPrecision(fieldName, "fixed", 0, 38, maybeColumn));
        });
    }

    @Override
    public void writeLong(long value) throws SQLException {
        this.withNextValue((json, fieldName, maybeColumn) -> {
            json.put(fieldName, value);
            this.schema.getFields().add(FieldSchemaCreator.buildSchemaWithScaleAndPrecision(fieldName, "fixed", 0, 38, maybeColumn));
        });
    }

    @Override
    public void writeFloat(float value) throws SQLException {
        this.withNextValue((json, fieldName, maybeColumn) -> {
            json.put(fieldName, Float.valueOf(value));
            this.schema.getFields().add(FieldSchemaCreator.buildSchemaTypeAndNameOnly(fieldName, "real", maybeColumn));
        });
    }

    @Override
    public void writeDouble(double value) throws SQLException {
        this.withNextValue((json, fieldName, maybeColumn) -> {
            json.put(fieldName, value);
            this.schema.getFields().add(FieldSchemaCreator.buildSchemaTypeAndNameOnly(fieldName, "real", maybeColumn));
        });
    }

    @Override
    public void writeBigDecimal(BigDecimal value) throws SQLException {
        this.withNextValue((json, fieldName, maybeColumn) -> {
            json.put(fieldName, value);
            this.schema.getFields().add(FieldSchemaCreator.buildSchemaWithScaleAndPrecision(fieldName, "fixed", value.scale(), 38, maybeColumn));
        });
    }

    @Override
    public void writeBytes(byte[] value) throws SQLException {
        this.withNextValue((json, fieldName, maybeColumn) -> {
            json.put(fieldName, new SFBinary(value).toHex());
            this.schema.getFields().add(FieldSchemaCreator.buildSchemaForBytesType(fieldName, maybeColumn));
        });
    }

    @Override
    public void writeDate(Date value) throws SQLException {
        this.withNextValue((json, fieldName, maybeColumn) -> {
            json.put(fieldName, ResultUtil.getDateAsString(value, this.getDateTimeFormat("DATE_OUTPUT_FORMAT")));
            this.schema.getFields().add(FieldSchemaCreator.buildSchemaTypeAndNameOnly(fieldName, "date", maybeColumn));
        });
    }

    @Override
    public void writeTime(Time x) throws SQLException {
        this.withNextValue((json, fieldName, maybeColumn) -> {
            long nanosSinceMidnight = SfTimestampUtil.getTimeInNanoseconds(x);
            String result = ResultUtil.getSFTimeAsString(SFTime.fromNanoseconds(nanosSinceMidnight), 9, this.getDateTimeFormat("TIME_OUTPUT_FORMAT"));
            json.put(fieldName, result);
            this.schema.getFields().add(FieldSchemaCreator.buildSchemaWithScaleAndPrecision(fieldName, "time", 9, 0, maybeColumn));
        });
    }

    @Override
    public void writeTimestamp(Timestamp value) throws SQLException {
        this.withNextValue((json, fieldName, maybeColumn) -> {
            String timestampSessionType = (String)ResultUtil.effectiveParamValue(this.session.getCommonParameters(), "CLIENT_TIMESTAMP_TYPE_MAPPING");
            SnowflakeType snowflakeType = SnowflakeType.fromString(maybeColumn.map(cl -> cl.type()).filter(str -> !str.isEmpty()).orElse(timestampSessionType));
            int columnType = this.snowflakeTypeToJavaType(snowflakeType);
            TimeZone timeZone = this.timeZoneDependOnType(snowflakeType, this.session, null);
            String timestampAsString = SnowflakeUtil.mapSFExceptionToSQLException(() -> ResultUtil.getSFTimestampAsString(new SFTimestamp(value, timeZone), columnType, 9, this.getDateTimeFormat("TIMESTAMP_NTZ_OUTPUT_FORMAT"), this.getDateTimeFormat("TIMESTAMP_LTZ_OUTPUT_FORMAT"), this.getDateTimeFormat("TIMESTAMP_TZ_OUTPUT_FORMAT"), this.session));
            json.put(fieldName, timestampAsString);
            this.schema.getFields().add(FieldSchemaCreator.buildSchemaWithScaleAndPrecision(fieldName, snowflakeType.name(), 9, 0, maybeColumn));
        });
    }

    @Override
    public void writeCharacterStream(Reader x) throws SQLException {
        logger.debug(" Unsupported method writeCharacterStream(Reader x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void writeAsciiStream(InputStream x) throws SQLException {
        logger.debug("Unsupported method writeAsciiStream(InputStream x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void writeBinaryStream(InputStream x) throws SQLException {
        logger.debug("Unsupported method writeBinaryStream(InputStream x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void writeObject(SQLData sqlData) throws SQLException {
        this.withNextValue((json, fieldName, maybeColumn) -> {
            JsonSqlOutput jsonSqlOutput = new JsonSqlOutput(sqlData, this.session);
            sqlData.writeSQL(jsonSqlOutput);
            json.put(fieldName, jsonSqlOutput.getJsonObject());
            BindingParameterMetadata structSchema = jsonSqlOutput.getSchema();
            structSchema.setName((String)fieldName);
            this.schema.getFields().add(structSchema);
        });
    }

    @Override
    public void writeRef(Ref x) throws SQLException {
        logger.debug("Unsupported method writeRef(Ref x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void writeBlob(Blob x) throws SQLException {
        logger.debug("Unsupported method writeBlob(Blob x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void writeClob(Clob x) throws SQLException {
        logger.debug("Unsupported method writeClob(Clob x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void writeStruct(Struct x) throws SQLException {
        logger.debug("Unsupported method writeStruct(Struct x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void writeArray(Array x) throws SQLException {
        logger.debug("Unsupported method writeArray(Array x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void writeURL(URL x) throws SQLException {
        logger.debug("Unsupported method writeURL(URL x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void writeNString(String x) throws SQLException {
        logger.debug("Unsupported method writeNString(String x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void writeNClob(NClob x) throws SQLException {
        logger.debug("Unsupported method writeNClob(NClob x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void writeRowId(RowId x) throws SQLException {
        logger.debug("Unsupported method writeRowId(RowId x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public void writeSQLXML(SQLXML x) throws SQLException {
        logger.debug("Unsupported method  writeSQLXML(SQLXML x)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    public String getJsonString() {
        return this.json.toJSONString();
    }

    public JSONObject getJsonObject() {
        return this.json;
    }

    private void withNextValue(ThrowingTriCallable<JSONObject, String, Optional<SnowflakeColumn>, SQLException> action) throws SQLException {
        Field field = this.fields.next();
        String fieldName = field.getName();
        Optional<SnowflakeColumn> maybeColumn = Optional.ofNullable(field.getAnnotation(SnowflakeColumn.class));
        action.apply(this.json, fieldName, maybeColumn);
    }

    private SnowflakeDateTimeFormat getDateTimeFormat(String format) {
        String rawFormat = (String)this.session.getCommonParameters().get(format);
        if (rawFormat == null || rawFormat.isEmpty()) {
            rawFormat = (String)this.session.getCommonParameters().get("TIMESTAMP_OUTPUT_FORMAT");
        }
        SnowflakeDateTimeFormat formatter = SnowflakeDateTimeFormat.fromSqlFormat(rawFormat);
        return formatter;
    }

    public BindingParameterMetadata getSchema() {
        return this.schema;
    }

    private TimeZone timeZoneDependOnType(SnowflakeType snowflakeType, SFBaseSession session, TimeZone tz) {
        if (snowflakeType == SnowflakeType.TIMESTAMP_NTZ) {
            return null;
        }
        if (snowflakeType == SnowflakeType.TIMESTAMP_LTZ) {
            return this.getSessionTimezone(session);
        }
        if (snowflakeType == SnowflakeType.TIMESTAMP_TZ) {
            return Optional.ofNullable(tz).orElse(this.sessionTimezone);
        }
        return TimeZone.getDefault();
    }

    private int snowflakeTypeToJavaType(SnowflakeType snowflakeType) {
        if (snowflakeType == SnowflakeType.TIMESTAMP_NTZ) {
            return 50002;
        }
        if (snowflakeType == SnowflakeType.TIMESTAMP_LTZ) {
            return 50000;
        }
        return 50001;
    }
}

