/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.diagnostic;

class SnowflakeEndpoint {
    private final String type;
    private final String host;
    private final int port;
    private final boolean isSecure;

    public SnowflakeEndpoint(String type, String host, int port) {
        this.type = type;
        this.host = host;
        this.port = port;
        this.isSecure = this.port == 443;
    }

    public SnowflakeEndpoint() {
        this(null, null, -1);
    }

    public String getType() {
        return this.type;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isSslEnabled() {
        return this.isSecure;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isPrivateLink() {
        return this.host.contains("privatelink.snowflakecomputing.com");
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    public boolean equals(Object o) {
        boolean isSnowflakeEndpoint = o instanceof SnowflakeEndpoint;
        if (!isSnowflakeEndpoint) {
            return false;
        }
        if (!((SnowflakeEndpoint)o).getHost().equals(this.host)) {
            return false;
        }
        if (((SnowflakeEndpoint)o).getPort() != this.port) {
            return false;
        }
        return ((SnowflakeEndpoint)o).getType().equals(this.type);
    }
}

