/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds.internal.security;

import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.xds.Bootstrapper;
import net.snowflake.client.jdbc.internal.grpc.xds.EnvoyServerProtoData;
import net.snowflake.client.jdbc.internal.grpc.xds.TlsContextManager;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.ClientSslContextProviderFactory;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.ReferenceCountingMap;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.ServerSslContextProviderFactory;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.SslContextProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;

public final class TlsContextManagerImpl
implements TlsContextManager {
    private final ReferenceCountingMap<EnvoyServerProtoData.UpstreamTlsContext, SslContextProvider> mapForClients;
    private final ReferenceCountingMap<EnvoyServerProtoData.DownstreamTlsContext, SslContextProvider> mapForServers;

    @VisibleForTesting
    public TlsContextManagerImpl(Bootstrapper.BootstrapInfo bootstrapInfo) {
        this(new ClientSslContextProviderFactory(bootstrapInfo), new ServerSslContextProviderFactory(bootstrapInfo));
    }

    @VisibleForTesting
    TlsContextManagerImpl(ReferenceCountingMap.ValueFactory<EnvoyServerProtoData.UpstreamTlsContext, SslContextProvider> clientFactory, ReferenceCountingMap.ValueFactory<EnvoyServerProtoData.DownstreamTlsContext, SslContextProvider> serverFactory) {
        Preconditions.checkNotNull(clientFactory, "clientFactory");
        Preconditions.checkNotNull(serverFactory, "serverFactory");
        this.mapForClients = new ReferenceCountingMap<EnvoyServerProtoData.UpstreamTlsContext, SslContextProvider>(clientFactory);
        this.mapForServers = new ReferenceCountingMap<EnvoyServerProtoData.DownstreamTlsContext, SslContextProvider>(serverFactory);
    }

    @Override
    public SslContextProvider findOrCreateServerSslContextProvider(EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext) {
        Preconditions.checkNotNull(downstreamTlsContext, "downstreamTlsContext");
        CommonTlsContext.Builder builder = downstreamTlsContext.getCommonTlsContext().toBuilder();
        downstreamTlsContext = new EnvoyServerProtoData.DownstreamTlsContext(builder.build(), downstreamTlsContext.isRequireClientCertificate());
        return this.mapForServers.get(downstreamTlsContext);
    }

    @Override
    public SslContextProvider findOrCreateClientSslContextProvider(EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
        Preconditions.checkNotNull(upstreamTlsContext, "upstreamTlsContext");
        CommonTlsContext.Builder builder = upstreamTlsContext.getCommonTlsContext().toBuilder();
        upstreamTlsContext = new EnvoyServerProtoData.UpstreamTlsContext(builder.build());
        return this.mapForClients.get(upstreamTlsContext);
    }

    @Override
    public SslContextProvider releaseClientSslContextProvider(SslContextProvider clientSslContextProvider) {
        Preconditions.checkNotNull(clientSslContextProvider, "clientSslContextProvider");
        return this.mapForClients.release(clientSslContextProvider.getUpstreamTlsContext(), clientSslContextProvider);
    }

    @Override
    public SslContextProvider releaseServerSslContextProvider(SslContextProvider serverSslContextProvider) {
        Preconditions.checkNotNull(serverSslContextProvider, "serverSslContextProvider");
        return this.mapForServers.release(serverSslContextProvider.getDownstreamTlsContext(), serverSslContextProvider);
    }
}

