/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.core.BaseSqlInput;
import net.snowflake.client.core.ColumnTypeHelper;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFResultSet;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.json.Converters;
import net.snowflake.client.core.structs.SQLDataCreationHelper;
import net.snowflake.client.jdbc.FieldMetadata;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.JsonStringArrayList;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.JsonStringHashMap;
import net.snowflake.client.util.ThrowingBiFunction;

@SnowflakeJdbcInternalApi
public class ArrowSqlInput
extends BaseSqlInput {
    private final Map<String, Object> input;
    private int currentIndex = 0;
    private boolean wasNull = false;

    public ArrowSqlInput(Map<String, Object> input, SFBaseSession session, Converters converters, List<FieldMetadata> fields) {
        super(session, converters, fields);
        this.input = input;
    }

    public Map<String, Object> getInput() {
        return this.input;
    }

    @Override
    public String readString() throws SQLException {
        return this.withNextValue(this::convertString);
    }

    @Override
    public boolean readBoolean() throws SQLException {
        return this.withNextValue(this::convertBoolean);
    }

    @Override
    public byte readByte() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getNumberConverter().getByte(value)));
    }

    @Override
    public short readShort() throws SQLException {
        return this.withNextValue(this::convertShort);
    }

    @Override
    public int readInt() throws SQLException {
        return this.withNextValue(this::convertInt);
    }

    @Override
    public long readLong() throws SQLException {
        return this.withNextValue(this::convertLong);
    }

    @Override
    public float readFloat() throws SQLException {
        return this.withNextValue(this::convertFloat).floatValue();
    }

    @Override
    public double readDouble() throws SQLException {
        return this.withNextValue(this::convertDouble);
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        return this.withNextValue(this::convertBigDecimal);
    }

    @Override
    public byte[] readBytes() throws SQLException {
        return this.withNextValue(this::convertBytes);
    }

    @Override
    public Date readDate() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            if (value == null) {
                return null;
            }
            return this.convertDate((Integer)value);
        });
    }

    private Date convertDate(int value) throws SQLException {
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getStructuredTypeDateTimeConverter().getDate(value, TimeZone.getDefault()));
    }

    @Override
    public Time readTime() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            if (value == null) {
                return null;
            }
            return this.convertTime((Long)value, (FieldMetadata)fieldMetadata);
        });
    }

    private Time convertTime(long value, FieldMetadata fieldMetadata) throws SQLException {
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> {
            int scale = fieldMetadata.getScale();
            return this.converters.getStructuredTypeDateTimeConverter().getTime(value, scale);
        });
    }

    @Override
    public Timestamp readTimestamp(TimeZone tz) throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> this.convertTimestamp(tz, value, (FieldMetadata)fieldMetadata));
    }

    private Timestamp convertTimestamp(TimeZone tz, Object value, FieldMetadata fieldMetadata) throws SQLException {
        if (value == null) {
            return null;
        }
        int columnType = ColumnTypeHelper.getColumnType(fieldMetadata.getType(), this.session);
        int columnSubType = fieldMetadata.getType();
        int scale = fieldMetadata.getScale();
        return SnowflakeUtil.mapSFExceptionToSQLException(() -> this.converters.getStructuredTypeDateTimeConverter().getTimestamp((Map)value, columnType, columnSubType, tz, scale));
    }

    @Override
    public Object readObject() throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            if (!(value instanceof JsonStringHashMap)) {
                throw new SQLException("Invalid value passed to 'readObject()', expected Map; got: " + value.getClass());
            }
            return value;
        });
    }

    @Override
    public <T> T readObject(Class<T> type) throws SQLException {
        return this.readObject(type, TimeZone.getDefault());
    }

    @Override
    public <T> T readObject(Class<T> type, TimeZone tz) throws SQLException {
        return (T)this.withNextValue((value, fieldMetadata) -> this.convertObject(type, tz, value, (FieldMetadata)fieldMetadata));
    }

    private <T> T convertObject(Class<T> type, TimeZone tz, Object value, FieldMetadata fieldMetadata) throws SQLException {
        if (value == null) {
            return null;
        }
        if (SQLData.class.isAssignableFrom(type)) {
            ArrowSqlInput sqlInput = new ArrowSqlInput((Map)value, this.session, this.converters, fieldMetadata.getFields());
            SQLData instance = (SQLData)SQLDataCreationHelper.create(type);
            instance.readSQL(sqlInput, null);
            return (T)instance;
        }
        if (Map.class.isAssignableFrom(type)) {
            return (T)this.convertSqlInputToMap((SQLInput)value);
        }
        if (String.class.isAssignableFrom(type)) {
            return (T)this.convertString(value, fieldMetadata);
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return (T)this.convertBoolean(value, fieldMetadata);
        }
        if (Byte.class.isAssignableFrom(type)) {
            return (T)this.convertBytes(value, fieldMetadata);
        }
        if (Short.class.isAssignableFrom(type)) {
            return (T)this.convertShort(value, fieldMetadata);
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (T)this.convertInt(value, fieldMetadata);
        }
        if (Long.class.isAssignableFrom(type)) {
            return (T)this.convertLong(value, fieldMetadata);
        }
        if (Float.class.isAssignableFrom(type)) {
            return (T)this.convertFloat(value, fieldMetadata);
        }
        if (Double.class.isAssignableFrom(type)) {
            return (T)this.convertDouble(value, fieldMetadata);
        }
        if (Date.class.isAssignableFrom(type)) {
            return (T)this.convertDate((Integer)value);
        }
        if (Time.class.isAssignableFrom(type)) {
            return (T)this.convertTime((Long)value, fieldMetadata);
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return (T)this.convertTimestamp(tz, value, fieldMetadata);
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return (T)this.convertBigDecimal(value, fieldMetadata);
        }
        if (byte[].class.isAssignableFrom(type)) {
            return (T)this.convertBytes(value, fieldMetadata);
        }
        SFResultSet.logger.debug("Unsupported type passed to readObject(int columnIndex,Class<T> type): " + type.getName(), new Object[0]);
        throw new SQLException("Type passed to 'getObject(int columnIndex,Class<T> type)' is unsupported. Type: " + type.getName());
    }

    @Override
    public <T> List<T> readList(Class<T> type) throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            if (value == null) {
                return null;
            }
            ArrayList result = new ArrayList();
            JsonStringArrayList maps = (JsonStringArrayList)value;
            for (Object ob : maps) {
                result.add(this.convertObject(type, TimeZone.getDefault(), ob, fieldMetadata.getFields().get(0)));
            }
            return result;
        });
    }

    @Override
    public <T> T[] readArray(Class<T> type) throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            if (value == null) {
                return null;
            }
            JsonStringArrayList internalValues = (JsonStringArrayList)value;
            Object[] array = (Object[])Array.newInstance(type, internalValues.size());
            int counter = 0;
            for (Object ob : internalValues) {
                array[counter++] = this.convertObject(type, TimeZone.getDefault(), ob, fieldMetadata.getFields().get(0));
            }
            return array;
        });
    }

    @Override
    public <T> Map<String, T> readMap(Class<T> type) throws SQLException {
        return this.withNextValue((value, fieldMetadata) -> {
            if (value == null) {
                return null;
            }
            HashMap result = new HashMap();
            JsonStringArrayList maps = (JsonStringArrayList)value;
            for (Map map : maps) {
                result.put(map.get("key").toString(), this.convertObject(type, TimeZone.getDefault(), map.get("value"), fieldMetadata.getFields().get(1)));
            }
            return result;
        });
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    Map<String, Object> convertSqlInputToMap(SQLInput sqlInput) {
        return ((ArrowSqlInput)sqlInput).getInput();
    }

    private <T> T withNextValue(ThrowingBiFunction<Object, FieldMetadata, T, SQLException> action) throws SQLException {
        FieldMetadata field;
        Object value;
        this.wasNull = (value = this.input.get((field = (FieldMetadata)this.fields.get(this.currentIndex++)).getName())) == null;
        return action.apply(value, field);
    }
}

