/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.sql.Time;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.structs.StructureTypeHelper;
import net.snowflake.client.jdbc.ColumnTypeInfo;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.FieldMetadata;
import net.snowflake.client.jdbc.SnowflakeColumnMetadata;
import net.snowflake.client.jdbc.SnowflakeReauthenticationRequest;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.commons.io.IOUtils;
import net.snowflake.client.jdbc.internal.apache.http.Header;
import net.snowflake.client.jdbc.internal.apache.http.HttpResponse;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ArrayNode;
import net.snowflake.client.jdbc.internal.google.common.base.Strings;
import net.snowflake.client.jdbc.internal.snowflake.common.util.ClassUtil;
import net.snowflake.client.jdbc.internal.snowflake.common.util.FixedViewColumn;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.ThrowingCallable;

public class SnowflakeUtil {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeUtil.class);
    public static final int EXTRA_TYPES_TIMESTAMP_LTZ = 50000;
    public static final int EXTRA_TYPES_TIMESTAMP_TZ = 50001;
    public static final int EXTRA_TYPES_TIMESTAMP_NTZ = 50002;
    private static final int ID_TOKEN_EXPIRED_GS_CODE = 390110;
    private static final int SESSION_NOT_EXIST_GS_CODE = 390111;
    private static final int MASTER_TOKEN_NOTFOUND = 390113;
    private static final int MASTER_EXPIRED_GS_CODE = 390114;
    private static final int MASTER_TOKEN_INVALID_GS_CODE = 390115;
    private static final int ID_TOKEN_INVALID_LOGIN_REQUEST_GS_CODE = 390195;
    public static final String BIG_DECIMAL_STR = "big decimal";
    public static final String FLOAT_STR = "float";
    public static final String DOUBLE_STR = "double";
    public static final String BOOLEAN_STR = "boolean";
    public static final String SHORT_STR = "short";
    public static final String INT_STR = "int";
    public static final String LONG_STR = "long";
    public static final String TIME_STR = "time";
    public static final String TIMESTAMP_STR = "timestamp";
    public static final String DATE_STR = "date";
    public static final String BYTE_STR = "byte";
    public static final String BYTES_STR = "byte array";
    private static final String ALPHA_NUMERIC_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public static void checkErrorAndThrowExceptionIncludingReauth(JsonNode rootNode) throws SnowflakeSQLException {
        SnowflakeUtil.checkErrorAndThrowExceptionSub(rootNode, true);
    }

    public static void checkErrorAndThrowException(JsonNode rootNode) throws SnowflakeSQLException {
        SnowflakeUtil.checkErrorAndThrowExceptionSub(rootNode, false);
    }

    public static long getEpochTimeInMicroSeconds() {
        Instant timestamp = Instant.now();
        long micros = TimeUnit.SECONDS.toMicros(timestamp.getEpochSecond()) + TimeUnit.NANOSECONDS.toMicros(timestamp.getNano());
        return micros;
    }

    private static void checkErrorAndThrowExceptionSub(JsonNode rootNode, boolean raiseReauthenticateError) throws SnowflakeSQLException {
        String errorMessage;
        int errorCode;
        String sqlState;
        if (rootNode.path("success").asBoolean()) {
            return;
        }
        String queryId = "unknown";
        if (!rootNode.path("data").path("sqlState").isMissingNode()) {
            sqlState = rootNode.path("data").path("sqlState").asText();
            errorCode = rootNode.path("data").path("errorCode").asInt();
            queryId = rootNode.path("data").path("queryId").asText();
            errorMessage = rootNode.path("message").asText();
        } else {
            sqlState = "XX000";
            if (!rootNode.path("code").isMissingNode()) {
                errorCode = rootNode.path("code").asInt();
                errorMessage = rootNode.path("message").asText();
            } else {
                errorCode = ErrorCode.INTERNAL_ERROR.getMessageCode();
                errorMessage = "no_error_code_from_server";
                try (PrintWriter writer = new PrintWriter("output.json", "UTF-8");){
                    writer.print(rootNode.toString());
                }
                catch (Exception ex) {
                    logger.debug("{}", ex);
                }
            }
        }
        if (raiseReauthenticateError) {
            switch (errorCode) {
                case 390110: 
                case 390111: 
                case 390113: 
                case 390114: 
                case 390115: 
                case 390195: {
                    throw new SnowflakeReauthenticationRequest(queryId, errorMessage, sqlState, errorCode);
                }
            }
        }
        throw new SnowflakeSQLException(queryId, errorMessage, sqlState, errorCode);
    }

    public static SnowflakeColumnMetadata extractColumnMetadata(JsonNode colNode, boolean jdbcTreatDecimalAsInt, SFBaseSession session) throws SnowflakeSQLException {
        String colName = colNode.path("name").asText();
        String internalColTypeName = colNode.path("type").asText();
        boolean nullable = colNode.path("nullable").asBoolean();
        int precision = colNode.path("precision").asInt();
        int scale = colNode.path("scale").asInt();
        int length = colNode.path("length").asInt();
        boolean fixed = colNode.path("fixed").asBoolean();
        JsonNode udtOutputType = colNode.path("outputType");
        JsonNode extColTypeNameNode = colNode.path("extTypeName");
        String extColTypeName = null;
        if (!extColTypeNameNode.isMissingNode() && !Strings.isNullOrEmpty(extColTypeNameNode.asText())) {
            extColTypeName = extColTypeNameNode.asText();
        }
        int fixedColType = jdbcTreatDecimalAsInt && scale == 0 ? -5 : 3;
        ColumnTypeInfo columnTypeInfo = SnowflakeUtil.getSnowflakeType(internalColTypeName, extColTypeName, udtOutputType, session, fixedColType);
        String colSrcDatabase = colNode.path("database").asText();
        String colSrcSchema = colNode.path("schema").asText();
        String colSrcTable = colNode.path("table").asText();
        List<FieldMetadata> fieldsMetadata = SnowflakeUtil.getFieldMetadata(jdbcTreatDecimalAsInt, colNode);
        boolean isAutoIncrement = colNode.path("isAutoIncrement").asBoolean();
        return new SnowflakeColumnMetadata(colName, columnTypeInfo.getColumnType(), nullable, length, precision, scale, columnTypeInfo.getExtColTypeName(), fixed, columnTypeInfo.getSnowflakeType(), fieldsMetadata, colSrcDatabase, colSrcSchema, colSrcTable, isAutoIncrement);
    }

    static ColumnTypeInfo getSnowflakeType(String internalColTypeName, String extColTypeName, JsonNode udtOutputType, SFBaseSession session, int fixedColType) throws SnowflakeSQLLoggedException {
        SnowflakeType baseType = SnowflakeType.fromString(internalColTypeName);
        ColumnTypeInfo columnTypeInfo = null;
        switch (baseType) {
            case TEXT: {
                columnTypeInfo = new ColumnTypeInfo(12, SnowflakeUtil.defaultIfNull(extColTypeName, "VARCHAR"), baseType);
                break;
            }
            case CHAR: {
                columnTypeInfo = new ColumnTypeInfo(1, SnowflakeUtil.defaultIfNull(extColTypeName, "CHAR"), baseType);
                break;
            }
            case INTEGER: {
                columnTypeInfo = new ColumnTypeInfo(4, SnowflakeUtil.defaultIfNull(extColTypeName, "INTEGER"), baseType);
                break;
            }
            case FIXED: {
                columnTypeInfo = new ColumnTypeInfo(fixedColType, SnowflakeUtil.defaultIfNull(extColTypeName, "NUMBER"), baseType);
                break;
            }
            case REAL: {
                columnTypeInfo = new ColumnTypeInfo(8, SnowflakeUtil.defaultIfNull(extColTypeName, "DOUBLE"), baseType);
                break;
            }
            case TIMESTAMP: 
            case TIMESTAMP_LTZ: {
                columnTypeInfo = new ColumnTypeInfo(50000, SnowflakeUtil.defaultIfNull(extColTypeName, "TIMESTAMPLTZ"), baseType);
                break;
            }
            case TIMESTAMP_NTZ: {
                columnTypeInfo = new ColumnTypeInfo(93, SnowflakeUtil.defaultIfNull(extColTypeName, "TIMESTAMPNTZ"), baseType);
                break;
            }
            case TIMESTAMP_TZ: {
                columnTypeInfo = new ColumnTypeInfo(50001, SnowflakeUtil.defaultIfNull(extColTypeName, "TIMESTAMPTZ"), baseType);
                break;
            }
            case DATE: {
                columnTypeInfo = new ColumnTypeInfo(91, SnowflakeUtil.defaultIfNull(extColTypeName, "DATE"), baseType);
                break;
            }
            case TIME: {
                columnTypeInfo = new ColumnTypeInfo(92, SnowflakeUtil.defaultIfNull(extColTypeName, "TIME"), baseType);
                break;
            }
            case BOOLEAN: {
                columnTypeInfo = new ColumnTypeInfo(16, SnowflakeUtil.defaultIfNull(extColTypeName, "BOOLEAN"), baseType);
                break;
            }
            case ARRAY: {
                columnTypeInfo = new ColumnTypeInfo(2003, SnowflakeUtil.defaultIfNull(extColTypeName, "ARRAY"), baseType);
                break;
            }
            case MAP: {
                columnTypeInfo = new ColumnTypeInfo(2002, SnowflakeUtil.defaultIfNull(extColTypeName, "OBJECT"), baseType);
                break;
            }
            case OBJECT: {
                if (StructureTypeHelper.isStructureTypeEnabled()) {
                    boolean isGeoType = "GEOMETRY".equals(extColTypeName) || "GEOGRAPHY".equals(extColTypeName);
                    int type = isGeoType ? 12 : 2002;
                    columnTypeInfo = new ColumnTypeInfo(type, SnowflakeUtil.defaultIfNull(extColTypeName, "OBJECT"), baseType);
                    break;
                }
                columnTypeInfo = new ColumnTypeInfo(12, SnowflakeUtil.defaultIfNull(extColTypeName, "OBJECT"), baseType);
                break;
            }
            case VARIANT: {
                columnTypeInfo = new ColumnTypeInfo(12, SnowflakeUtil.defaultIfNull(extColTypeName, "VARIANT"), baseType);
                break;
            }
            case BINARY: {
                columnTypeInfo = new ColumnTypeInfo(-2, SnowflakeUtil.defaultIfNull(extColTypeName, "BINARY"), baseType);
                break;
            }
            case GEOGRAPHY: 
            case GEOMETRY: {
                int colType = 12;
                String string = extColTypeName = baseType == SnowflakeType.GEOGRAPHY ? "GEOGRAPHY" : "GEOMETRY";
                if (!udtOutputType.isMissingNode()) {
                    SnowflakeType outputType = SnowflakeType.fromString(udtOutputType.asText());
                    switch (outputType) {
                        case OBJECT: 
                        case TEXT: {
                            colType = 12;
                            break;
                        }
                        case BINARY: {
                            colType = -2;
                        }
                    }
                }
                columnTypeInfo = new ColumnTypeInfo(colType, extColTypeName, baseType);
                break;
            }
            default: {
                throw new SnowflakeSQLLoggedException(session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unknown column type: " + internalColTypeName);
            }
        }
        return columnTypeInfo;
    }

    private static String defaultIfNull(String extColTypeName, String defaultValue) {
        return Optional.ofNullable(extColTypeName).orElse(defaultValue);
    }

    static List<FieldMetadata> createFieldsMetadata(ArrayNode fieldsJson, boolean jdbcTreatDecimalAsInt) throws SnowflakeSQLLoggedException {
        ArrayList<FieldMetadata> fields = new ArrayList<FieldMetadata>();
        for (JsonNode node : fieldsJson) {
            String colName = node.path("name").asText();
            int scale = node.path("scale").asInt();
            int precision = node.path("precision").asInt();
            String internalColTypeName = node.path("type").asText();
            boolean nullable = node.path("nullable").asBoolean();
            int length = node.path("length").asInt();
            boolean fixed = node.path("fixed").asBoolean();
            int fixedColType = jdbcTreatDecimalAsInt && scale == 0 ? -5 : 3;
            List<FieldMetadata> internalFields = SnowflakeUtil.getFieldMetadata(jdbcTreatDecimalAsInt, node);
            JsonNode outputType = node.path("outputType");
            JsonNode extColTypeNameNode = node.path("extTypeName");
            String extColTypeName = null;
            if (!extColTypeNameNode.isMissingNode() && !Strings.isNullOrEmpty(extColTypeNameNode.asText())) {
                extColTypeName = extColTypeNameNode.asText();
            }
            ColumnTypeInfo columnTypeInfo = SnowflakeUtil.getSnowflakeType(internalColTypeName, extColTypeName, outputType, null, fixedColType);
            fields.add(new FieldMetadata(colName, columnTypeInfo.getExtColTypeName(), columnTypeInfo.getColumnType(), nullable, length, precision, scale, fixed, columnTypeInfo.getSnowflakeType(), internalFields));
        }
        return fields;
    }

    private static List<FieldMetadata> getFieldMetadata(boolean jdbcTreatDecimalAsInt, JsonNode node) throws SnowflakeSQLLoggedException {
        if (!node.path("fields").isEmpty()) {
            ArrayNode internalFieldsJson = (ArrayNode)node.path("fields");
            return SnowflakeUtil.createFieldsMetadata(internalFieldsJson, jdbcTreatDecimalAsInt);
        }
        return new ArrayList<FieldMetadata>();
    }

    static String javaTypeToSFTypeString(int javaType, SFBaseSession session) throws SnowflakeSQLException {
        return SnowflakeType.javaTypeToSFType(javaType, session).name();
    }

    static SnowflakeType javaTypeToSFType(int javaType, SFBaseSession session) throws SnowflakeSQLException {
        return SnowflakeType.javaTypeToSFType(javaType, session);
    }

    static String concatFilePathNames(String leftPath, String rightPath, String fileSep) {
        String leftPathTrimmed = leftPath.trim();
        String rightPathTrimmed = rightPath.trim();
        if (leftPathTrimmed.isEmpty()) {
            return rightPath;
        }
        if (leftPathTrimmed.endsWith(fileSep) && rightPathTrimmed.startsWith(fileSep)) {
            return leftPathTrimmed + rightPathTrimmed.substring(1);
        }
        if (!leftPathTrimmed.endsWith(fileSep) && !rightPathTrimmed.startsWith(fileSep)) {
            return leftPathTrimmed + fileSep + rightPathTrimmed;
        }
        return leftPathTrimmed + rightPathTrimmed;
    }

    static String greatestCommonPrefix(String val1, String val2) {
        if (val1 == null || val2 == null) {
            return null;
        }
        StringBuilder greatestCommonPrefix = new StringBuilder();
        int len = Math.min(val1.length(), val2.length());
        for (int idx = 0; idx < len && val1.charAt(idx) == val2.charAt(idx); ++idx) {
            greatestCommonPrefix.append(val1.charAt(idx));
        }
        return greatestCommonPrefix.toString();
    }

    static List<SnowflakeColumnMetadata> describeFixedViewColumns(Class<?> clazz, SFBaseSession session) throws SnowflakeSQLException {
        Field[] columns = ClassUtil.getAnnotatedDeclaredFields(clazz, FixedViewColumn.class, true);
        Arrays.sort(columns, new FixedViewColumn.OrdinalComparatorForFields());
        ArrayList<SnowflakeColumnMetadata> rowType = new ArrayList<SnowflakeColumnMetadata>();
        for (Field column : columns) {
            String typeName;
            int colType;
            FixedViewColumn columnAnnotation = column.getAnnotation(FixedViewColumn.class);
            Class<?> type = column.getType();
            SnowflakeType stype = SnowflakeType.TEXT;
            if (type == Integer.TYPE) {
                colType = 4;
                typeName = "INTEGER";
                stype = SnowflakeType.INTEGER;
            }
            if (type == Long.TYPE) {
                colType = 3;
                typeName = "DECIMAL";
                stype = SnowflakeType.INTEGER;
            } else if (type == String.class) {
                colType = 12;
                typeName = "VARCHAR";
                stype = SnowflakeType.TEXT;
            } else {
                throw new SnowflakeSQLLoggedException(session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unsupported column type: " + type.getName());
            }
            rowType.add(new SnowflakeColumnMetadata(columnAnnotation.name(), colType, false, 20480, 10, 0, typeName, true, stype, new ArrayList<FieldMetadata>(), "", "", "", false));
        }
        return rowType;
    }

    public static void logResponseDetails(HttpResponse response, SFLogger logger) {
        Header[] headers;
        if (response == null) {
            logger.error("null response", false);
            return;
        }
        if (response.getStatusLine() != null) {
            logger.error("Response status line reason: {}", response.getStatusLine().getReasonPhrase());
        }
        if ((headers = response.getAllHeaders()) != null) {
            for (Header header : headers) {
                logger.debug("Header name: {}, value: {}", header.getName(), header.getValue());
            }
        }
        if (response.getEntity() != null) {
            try {
                StringWriter writer = new StringWriter();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                IOUtils.copy((Reader)bufferedReader, (Writer)writer);
                logger.error("Response content: {}", writer.toString());
            }
            catch (IOException ex) {
                logger.error("Failed to read content due to exception: {}", ex.getMessage());
            }
        }
    }

    public static ThreadPoolExecutor createDefaultExecutorService(final String threadNamePrefix, int parallel) {
        ThreadFactory threadFactory = new ThreadFactory(){
            private int threadCount = 1;

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName(threadNamePrefix + this.threadCount++);
                return thread;
            }
        };
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(parallel, threadFactory);
    }

    public static Throwable getRootCause(Exception ex) {
        Throwable cause = ex;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    public static boolean isBlank(String input) {
        if ("".equals(input) || input == null) {
            return true;
        }
        for (char c : input.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static String randomAlphaNumeric(int count) {
        StringBuilder builder = new StringBuilder();
        Random random = new Random();
        while (count-- != 0) {
            int character = random.nextInt(ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }

    public static String systemGetProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException ex) {
            logger.debug("Security exception raised: {}", ex.getMessage());
            return null;
        }
    }

    public static String systemGetEnv(String env) {
        try {
            return System.getenv(env);
        }
        catch (SecurityException ex) {
            logger.debug("Failed to get environment variable {}. Security exception raised: {}", env, ex.getMessage());
            return null;
        }
    }

    public static void systemSetEnv(String key, String value) {
        try {
            Map<String, String> env = System.getenv();
            Class<?> cl = env.getClass();
            Field field = cl.getDeclaredField("m");
            field.setAccessible(true);
            Map writableEnv = (Map)field.get(env);
            writableEnv.put(key, value);
        }
        catch (Exception e) {
            System.out.println("Failed to set value");
            logger.error("Failed to set environment variable {}. Exception raised: {}", key, e.getMessage());
        }
    }

    public static void systemUnsetEnv(String key) {
        try {
            Map<String, String> env = System.getenv();
            Class<?> cl = env.getClass();
            Field field = cl.getDeclaredField("m");
            field.setAccessible(true);
            Map writableEnv = (Map)field.get(env);
            writableEnv.remove(key);
        }
        catch (Exception e) {
            System.out.println("Failed to unset value");
            logger.error("Failed to remove environment variable {}. Exception raised: {}", key, e.getMessage());
        }
    }

    public static HttpClientSettingsKey convertProxyPropertiesToHttpClientKey(OCSPMode mode, Properties info) throws SnowflakeSQLException {
        Boolean useProxy;
        if (info != null && info.size() > 0 && info.getProperty(SFSessionProperty.USE_PROXY.getPropertyKey()) != null && (useProxy = Boolean.valueOf(info.getProperty(SFSessionProperty.USE_PROXY.getPropertyKey()))).booleanValue()) {
            int proxyPort;
            String proxyHost = info.getProperty(SFSessionProperty.PROXY_HOST.getPropertyKey());
            try {
                proxyPort = Integer.parseInt(info.getProperty(SFSessionProperty.PROXY_PORT.getPropertyKey()));
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new SnowflakeSQLException(ErrorCode.INVALID_PROXY_PROPERTIES, "Could not parse port number");
            }
            String proxyUser = info.getProperty(SFSessionProperty.PROXY_USER.getPropertyKey());
            String proxyPassword = info.getProperty(SFSessionProperty.PROXY_PASSWORD.getPropertyKey());
            String nonProxyHosts = info.getProperty(SFSessionProperty.NON_PROXY_HOSTS.getPropertyKey());
            String proxyProtocol = info.getProperty(SFSessionProperty.PROXY_PROTOCOL.getPropertyKey());
            String userAgentSuffix = info.getProperty(SFSessionProperty.USER_AGENT_SUFFIX.getPropertyKey());
            Boolean gzipDisabled = Strings.isNullOrEmpty(info.getProperty(SFSessionProperty.GZIP_DISABLED.getPropertyKey())) ? false : Boolean.valueOf(info.getProperty(SFSessionProperty.GZIP_DISABLED.getPropertyKey()));
            return new HttpClientSettingsKey(mode, proxyHost, proxyPort, nonProxyHosts, proxyUser, proxyPassword, proxyProtocol, userAgentSuffix, gzipDisabled);
        }
        return new HttpClientSettingsKey(mode);
    }

    public static long getSecondsFromMillis(long millis) {
        long returnVal;
        if (millis < 0L) {
            returnVal = (long)Math.ceil((double)Math.abs(millis) / 1000.0);
            returnVal *= -1L;
        } else {
            returnVal = millis / 1000L;
        }
        return returnVal;
    }

    public static Time getTimeInSessionTimezone(Long time, int nanos) {
        LocalDateTime lcd = LocalDateTime.ofEpochSecond(time, nanos, ZoneOffset.UTC);
        Time ts = Time.valueOf(lcd.toLocalTime());
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(ts.getTime());
        c.add(14, nanos / 1000000);
        ts.setTime(c.getTimeInMillis());
        return ts;
    }

    @SnowflakeJdbcInternalApi
    public static boolean convertSystemPropertyToBooleanValue(String systemProperty, boolean defaultValue) {
        String systemPropertyValue = SnowflakeUtil.systemGetProperty(systemProperty);
        if (systemPropertyValue != null) {
            return Boolean.parseBoolean(systemPropertyValue);
        }
        return defaultValue;
    }

    @SnowflakeJdbcInternalApi
    public static <T> T mapSFExceptionToSQLException(ThrowingCallable<T, SFException> action) throws SQLException {
        try {
            return action.call();
        }
        catch (SFException e) {
            throw new SQLException(e);
        }
    }

    public static String getJsonNodeStringValue(JsonNode node) throws SFException {
        if (node.isNull()) {
            return null;
        }
        return node.isValueNode() ? node.asText() : node.toString();
    }
}

