/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import net.snowflake.client.jdbc.internal.google.api.client.util.Strings;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetry.TelemetryField;
import net.snowflake.client.jdbc.telemetry.TelemetryUtil;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryEvent;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;

public class SnowflakeSQLLoggedException
extends SnowflakeSQLException {
    private static final ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();

    private static void sendOutOfBandTelemetryMessage(JSONObject value, SQLException ex, TelemetryService oobInstance) {
        TelemetryEvent.LogBuilder logBuilder = new TelemetryEvent.LogBuilder();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        String stackTrace = SnowflakeSQLLoggedException.maskStacktrace(sw.toString());
        value.put("Stacktrace", stackTrace);
        value.put("Exception", ex.getClass().getSimpleName());
        TelemetryEvent log = ((TelemetryEvent.LogBuilder)logBuilder.withName("Exception: " + ex.getClass().getSimpleName())).withValue(value).build();
        oobInstance.report(log);
    }

    private static Future<Boolean> sendInBandTelemetryMessage(ObjectNode value, SQLException ex, Telemetry ibInstance) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        String stackTrace = SnowflakeSQLLoggedException.maskStacktrace(sw.toString());
        value.put("Stacktrace", stackTrace);
        value.put("Exception", ex.getClass().getSimpleName());
        if (value.get("SQLState").toString().contains("0A000")) {
            String reason = "";
            StackTraceElement[] stackTraceArray = ex.getStackTrace();
            if (stackTraceArray.length >= 1) {
                reason = ex.getStackTrace()[0].getMethodName() + " not supported";
            }
            value.put("reason", reason);
        }
        ibInstance.addLogToBatch(TelemetryUtil.buildJobData(value));
        return ibInstance.sendBatchAsync();
    }

    static String maskStacktrace(String stackTrace) {
        Pattern STACKTRACE_BEGINNING = Pattern.compile("(com|net)(\\.snowflake\\.client\\.jdbc\\.Snowflake)(SQLLogged|LoggedFeatureNotSupported|SQL)(Exception)([\\s\\S]*?)(\\n\\t?at\\snet|com\\.)", 10);
        Matcher matcher = STACKTRACE_BEGINNING.matcher(stackTrace);
        if (matcher.find()) {
            return matcher.replaceAll("$1$2$3$4$6");
        }
        return stackTrace;
    }

    static JSONObject createOOBValue(String queryId, String SQLState, int vendorCode) {
        JSONObject oobValue = new JSONObject();
        oobValue.put("type", TelemetryField.SQL_EXCEPTION.toString());
        oobValue.put("DriverType", "JDBC");
        oobValue.put("DriverVersion", SnowflakeDriver.implementVersion);
        if (!Strings.isNullOrEmpty(queryId)) {
            oobValue.put("QueryID", queryId);
        }
        if (!Strings.isNullOrEmpty(SQLState)) {
            oobValue.put("SQLState", SQLState);
        }
        if (vendorCode != -1) {
            oobValue.put("ErrorNumber", vendorCode);
        }
        return oobValue;
    }

    static ObjectNode createIBValue(String queryId, String SQLState, int vendorCode) {
        ObjectNode ibValue = mapper.createObjectNode();
        ibValue.put("type", TelemetryField.SQL_EXCEPTION.toString());
        ibValue.put("DriverType", "JDBC");
        ibValue.put("DriverVersion", SnowflakeDriver.implementVersion);
        if (!Strings.isNullOrEmpty(queryId)) {
            ibValue.put("QueryID", queryId);
        }
        if (!Strings.isNullOrEmpty(SQLState)) {
            ibValue.put("SQLState", SQLState);
        }
        if (vendorCode != -1) {
            ibValue.put("ErrorNumber", vendorCode);
        }
        return ibValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendTelemetryData(String queryId, String SQLState, int vendorCode, SFBaseSession session, SQLException ex) {
        Telemetry ibInstance = null;
        if (session != null) {
            ibInstance = session.getTelemetryClient();
        }
        if (ibInstance != null) {
            ObjectNode ibValue = SnowflakeSQLLoggedException.createIBValue(queryId, SQLState, vendorCode);
            ExecutorService threadExecutor = Executors.newSingleThreadExecutor();
            Telemetry finalIbInstance = ibInstance;
            try {
                threadExecutor.submit(() -> {
                    boolean inBandSuccess;
                    Future<Boolean> sendInBand = SnowflakeSQLLoggedException.sendInBandTelemetryMessage(ibValue, ex, finalIbInstance);
                    try {
                        inBandSuccess = sendInBand.get(10L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        inBandSuccess = false;
                    }
                    if (!inBandSuccess) {
                        logger.debug("In-band telemetry message failed to send. Sending out-of-band message instead", new Object[0]);
                        JSONObject oobValue = SnowflakeSQLLoggedException.createOOBValue(queryId, SQLState, vendorCode);
                        SnowflakeSQLLoggedException.sendOutOfBandTelemetryMessage(oobValue, ex, TelemetryService.getInstance());
                    }
                });
            }
            finally {
                threadExecutor.shutdown();
                ibInstance.postProcess(queryId, SQLState, vendorCode, ex);
            }
        } else {
            JSONObject oobValue = SnowflakeSQLLoggedException.createOOBValue(queryId, SQLState, vendorCode);
            SnowflakeSQLLoggedException.sendOutOfBandTelemetryMessage(oobValue, ex, TelemetryService.getInstance());
        }
    }

    public SnowflakeSQLLoggedException(SFBaseSession session, String reason, String SQLState, int vendorCode, String queryId) {
        super(queryId, reason, SQLState, vendorCode);
        SnowflakeSQLLoggedException.sendTelemetryData(queryId, SQLState, vendorCode, session, this);
    }

    public SnowflakeSQLLoggedException(SFBaseSession session, int vendorCode, String SQLState) {
        super(SQLState, vendorCode);
        SnowflakeSQLLoggedException.sendTelemetryData(null, SQLState, vendorCode, session, this);
    }

    public SnowflakeSQLLoggedException(String queryId, SFBaseSession session, int vendorCode, String SQLState) {
        super(queryId, SQLState, vendorCode);
        SnowflakeSQLLoggedException.sendTelemetryData(queryId, SQLState, vendorCode, session, this);
    }

    public SnowflakeSQLLoggedException(SFBaseSession session, String SQLState, String reason) {
        super(reason, SQLState);
        SnowflakeSQLLoggedException.sendTelemetryData(null, SQLState, -1, session, this);
    }

    public SnowflakeSQLLoggedException(SFBaseSession session, int vendorCode, String SQLState, Object ... params) {
        this(null, session, vendorCode, SQLState, params);
    }

    public SnowflakeSQLLoggedException(String queryId, SFBaseSession session, int vendorCode, String SQLState, Object ... params) {
        super(queryId, SQLState, vendorCode, params);
        SnowflakeSQLLoggedException.sendTelemetryData(queryId, SQLState, vendorCode, session, this);
    }

    public SnowflakeSQLLoggedException(SFBaseSession session, ErrorCode errorCode, Throwable ex, Object ... params) {
        super(ex, errorCode, params);
        SnowflakeSQLLoggedException.sendTelemetryData(null, errorCode.getSqlState(), errorCode.getMessageCode(), session, this);
    }

    public SnowflakeSQLLoggedException(SFBaseSession session, String SQLState, int vendorCode, Throwable ex, Object ... params) {
        super(ex, SQLState, vendorCode, params);
        SnowflakeSQLLoggedException.sendTelemetryData(null, SQLState, vendorCode, session, this);
    }

    public SnowflakeSQLLoggedException(String queryId, SFBaseSession session, String SQLState, int vendorCode, Throwable ex, Object ... params) {
        super(queryId, ex, SQLState, vendorCode, params);
        SnowflakeSQLLoggedException.sendTelemetryData(queryId, SQLState, vendorCode, session, this);
    }

    public SnowflakeSQLLoggedException(SFBaseSession session, ErrorCode errorCode, Object ... params) {
        super(errorCode, params);
        SnowflakeSQLLoggedException.sendTelemetryData(null, null, -1, session, this);
    }

    public SnowflakeSQLLoggedException(SFBaseSession session, SFException e) {
        super(e);
        SnowflakeSQLLoggedException.sendTelemetryData(null, null, -1, session, this);
    }

    public SnowflakeSQLLoggedException(SFBaseSession session, String reason) {
        super(reason);
        SnowflakeSQLLoggedException.sendTelemetryData(null, null, -1, session, this);
    }
}

