/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import net.snowflake.client.config.SFClientConfig;
import net.snowflake.client.config.SFClientConfigParser;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFBaseStatement;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SFAsyncResultSet;
import net.snowflake.client.jdbc.SFBaseFileTransferAgent;
import net.snowflake.client.jdbc.SFConnectionHandler;
import net.snowflake.client.jdbc.SnowflakeBaseResultSet;
import net.snowflake.client.jdbc.SnowflakeConnectString;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeResultSetV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import net.snowflake.client.log.JDK14Logger;
import net.snowflake.client.log.SFLogLevel;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.log.SFToJavaLogMapper;

public class DefaultSFConnectionHandler
implements SFConnectionHandler {
    private static final SFLogger logger = SFLoggerFactory.getLogger(DefaultSFConnectionHandler.class);
    private final SFSession sfSession = new SFSession(this);
    private final SnowflakeConnectString conStr;
    private final boolean skipOpen;

    public DefaultSFConnectionHandler(SnowflakeConnectString conStr) {
        this(conStr, false);
    }

    public DefaultSFConnectionHandler(SnowflakeConnectString conStr, boolean skipOpen) {
        this.conStr = conStr;
        this.skipOpen = skipOpen;
        this.sfSession.setSnowflakeConnectionString(conStr);
    }

    public static Map<String, Object> mergeProperties(SnowflakeConnectString conStr) {
        conStr.getParameters().remove("SSL");
        conStr.getParameters().put("SERVERURL", conStr.getScheme() + "://" + conStr.getHost() + ":" + conStr.getPort() + "/");
        return conStr.getParameters();
    }

    @Override
    public boolean supportsAsyncQuery() {
        return true;
    }

    @Override
    public void initializeConnection(String url, Properties info) throws SQLException {
        this.initialize(this.conStr, "JDBC", SnowflakeDriver.implementVersion);
    }

    @Override
    public SFBaseSession getSFSession() {
        return this.sfSession;
    }

    @Override
    public SFBaseStatement getSFStatement() {
        return new SFStatement(this.sfSession);
    }

    protected void initialize(SnowflakeConnectString conStr, String appID, String appVersion) throws SQLException {
        TelemetryService.getInstance().updateContext(conStr);
        try {
            this.initSessionProperties(conStr, appID, appVersion);
            this.setClientConfig();
            this.initLogger();
            logger.debug("Trying to establish session, JDBC driver: {}", SnowflakeDriver.getJdbcJarname());
            if (!this.skipOpen) {
                this.sfSession.open();
            }
        }
        catch (SFException ex) {
            throw new SnowflakeSQLLoggedException((SFBaseSession)this.sfSession, ex.getSqlState(), ex.getVendorCode(), ex.getCause(), ex.getParams());
        }
    }

    private void setClientConfig() throws SnowflakeSQLLoggedException {
        SFClientConfig sfClientConfig;
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.sfSession.getConnectionPropertiesMap();
        String clientConfigFilePath = connectionPropertiesMap.getOrDefault((Object)SFSessionProperty.CLIENT_CONFIG_FILE, null);
        try {
            sfClientConfig = SFClientConfigParser.loadSFClientConfig(clientConfigFilePath);
        }
        catch (IOException e) {
            throw new SnowflakeSQLLoggedException((SFBaseSession)this.sfSession, ErrorCode.INTERNAL_ERROR, e.getMessage());
        }
        this.sfSession.setSfClientConfig(sfClientConfig);
    }

    private void initLogger() throws SnowflakeSQLLoggedException {
        if (logger instanceof JDK14Logger && SnowflakeUtil.systemGetProperty("java.util.logging.config.file") == null) {
            Map<SFSessionProperty, Object> connectionPropertiesMap = this.sfSession.getConnectionPropertiesMap();
            String tracingLevelFromConnectionProp = connectionPropertiesMap.getOrDefault((Object)SFSessionProperty.TRACING, null);
            Level logLevel = null;
            String logPattern = "%h/snowflake_jdbc%u.log";
            SFClientConfig sfClientConfig = this.sfSession.getSfClientConfig();
            if (sfClientConfig != null) {
                String logPathFromConfig = sfClientConfig.getCommonProps().getLogPath();
                logPattern = this.constructLogPattern(logPathFromConfig);
                String levelStr = sfClientConfig.getCommonProps().getLogLevel();
                SFLogLevel sfLogLevel = SFLogLevel.getLogLevel(levelStr);
                logLevel = SFToJavaLogMapper.toJavaUtilLoggingLevel(sfLogLevel);
            }
            if (tracingLevelFromConnectionProp != null) {
                logLevel = Level.parse(tracingLevelFromConnectionProp.toUpperCase());
            }
            if (logLevel != null && logPattern != null) {
                try {
                    JDK14Logger.instantiateLogger(logLevel, logPattern);
                }
                catch (IOException ex) {
                    throw new SnowflakeSQLLoggedException((SFBaseSession)this.sfSession, ErrorCode.INTERNAL_ERROR, ex.getMessage());
                }
                if (sfClientConfig != null) {
                    logger.debug(String.format("SF Client config found at location: %s.", sfClientConfig.getConfigFilePath()), new Object[0]);
                }
                logger.debug(String.format("Instantiating JDK14Logger with level: %s , output path: %s", logLevel, logPattern), new Object[0]);
            }
        }
    }

    private String constructLogPattern(String logPathFromConfig) throws SnowflakeSQLLoggedException {
        if (JDK14Logger.STDOUT.equalsIgnoreCase(logPathFromConfig)) {
            return JDK14Logger.STDOUT;
        }
        String logPattern = "%t/snowflake_jdbc%u.log";
        if (logPathFromConfig != null && !logPathFromConfig.isEmpty()) {
            Path path = Paths.get(logPathFromConfig, "jdbc");
            if (!Files.exists(path, new LinkOption[0])) {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (IOException ex) {
                    throw new SnowflakeSQLLoggedException((SFBaseSession)this.sfSession, ErrorCode.INTERNAL_ERROR, String.format("Un-able to create log path mentioned in configfile %s ,%s", logPathFromConfig, ex.getMessage()));
                }
            }
            logPattern = Paths.get(path.toString(), "snowflake_jdbc%u.log").toString();
        }
        return logPattern;
    }

    private void initSessionProperties(SnowflakeConnectString conStr, String appID, String appVersion) throws SFException {
        Map<String, Object> properties = DefaultSFConnectionHandler.mergeProperties(conStr);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            block8: {
                Object v0;
                if ("CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY".equals(entry.getKey())) {
                    try {
                        v0 = entry.getValue();
                        int intV = v0 instanceof Integer ? (Integer)v0 : Integer.parseInt((String)v0);
                        if (intV > 3600) {
                            properties.replace(entry.getKey(), "3600");
                        }
                        if (intV < 900) {
                            properties.replace(entry.getKey(), "900");
                        }
                        break block8;
                    }
                    catch (NumberFormatException ex) {
                        logger.info("Invalid data type for CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY: {}", entry.getValue());
                        continue;
                    }
                }
                if ("CLIENT_SFSQL".equals(entry.getKey())) {
                    v0 = entry.getValue();
                    boolean booleanV = v0 instanceof Boolean ? (Boolean)v0 : Boolean.parseBoolean((String)v0);
                    this.sfSession.setSfSQLMode(booleanV);
                }
            }
            this.sfSession.addSFSessionProperty(entry.getKey(), entry.getValue());
        }
        this.sfSession.addProperty(SFSessionProperty.APP_ID, (Object)appID);
        this.sfSession.addProperty(SFSessionProperty.APP_VERSION, (Object)appVersion);
        for (Map.Entry<String, Object> entry : SessionUtil.JVM_PARAMS_TO_PARAMS.entrySet()) {
            String value = SnowflakeUtil.systemGetProperty(entry.getKey());
            if (value == null || this.sfSession.containProperty((String)entry.getValue())) continue;
            this.sfSession.addSFSessionProperty((String)entry.getValue(), value);
        }
    }

    @Override
    public ResultSet createResultSet(String queryID, Statement statement) throws SQLException {
        SFAsyncResultSet rs = new SFAsyncResultSet(queryID, statement);
        rs.setSession(this.sfSession);
        rs.setStatement(statement);
        return rs;
    }

    @Override
    public SnowflakeBaseResultSet createResultSet(SFBaseResultSet resultSet, Statement statement) throws SQLException {
        return new SnowflakeResultSetV1(resultSet, statement);
    }

    @Override
    public SnowflakeBaseResultSet createAsyncResultSet(SFBaseResultSet resultSet, Statement statement) throws SQLException {
        return new SFAsyncResultSet(resultSet, statement);
    }

    @Override
    public SFBaseFileTransferAgent getFileTransferAgent(String command, SFBaseStatement statement) throws SQLNonTransientConnectionException, SnowflakeSQLException {
        if (!(statement instanceof SFStatement)) {
            throw new SnowflakeSQLException("getFileTransferAgent() called with an incompatible SFBaseStatement type. Requires an SFStatement.");
        }
        return new SnowflakeFileTransferAgent(command, this.sfSession, (SFStatement)statement);
    }
}

