/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.sql.Timestamp;
import java.util.TimeZone;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SnowflakeDateTimeFormat;

@SnowflakeJdbcInternalApi
public class SqlInputTimestampUtil {
    public static Timestamp getTimestampFromType(int columnSubType, String value, SFBaseSession session, TimeZone sessionTimeZone, TimeZone tz) {
        if (columnSubType == 50000) {
            return SqlInputTimestampUtil.getTimestampFromFormat("TIMESTAMP_LTZ_OUTPUT_FORMAT", value, session, sessionTimeZone, tz);
        }
        if (columnSubType == 50002 || columnSubType == 93) {
            return SqlInputTimestampUtil.getTimestampFromFormat("TIMESTAMP_NTZ_OUTPUT_FORMAT", value, session, sessionTimeZone, tz);
        }
        if (columnSubType == 50001) {
            return SqlInputTimestampUtil.getTimestampFromFormat("TIMESTAMP_TZ_OUTPUT_FORMAT", value, session, sessionTimeZone, tz);
        }
        return null;
    }

    private static Timestamp getTimestampFromFormat(String format, String value, SFBaseSession session, TimeZone sessionTimeZone, TimeZone tz) {
        String rawFormat = (String)session.getCommonParameters().get(format);
        if (rawFormat == null || rawFormat.isEmpty()) {
            rawFormat = (String)session.getCommonParameters().get("TIMESTAMP_OUTPUT_FORMAT");
        }
        if (tz == null) {
            tz = sessionTimeZone;
        }
        SnowflakeDateTimeFormat formatter = SnowflakeDateTimeFormat.fromSqlFormat(rawFormat);
        return formatter.parse(value, tz, 0, false).getTimestamp();
    }
}

