/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.TrustManager;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFSSLConnectionSocketFactory;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.core.SFTrustManager;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.SnowflakeMutableProxyRoutePlanner;
import net.snowflake.client.core.SystemUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.RestRequest;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.cloud.storage.S3HttpUtil;
import net.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import net.snowflake.client.jdbc.internal.apache.commons.io.IOUtils;
import net.snowflake.client.jdbc.internal.apache.http.HttpHost;
import net.snowflake.client.jdbc.internal.apache.http.auth.AuthScope;
import net.snowflake.client.jdbc.internal.apache.http.auth.UsernamePasswordCredentials;
import net.snowflake.client.jdbc.internal.apache.http.client.config.RequestConfig;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.CloseableHttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.apache.http.config.Registry;
import net.snowflake.client.jdbc.internal.apache.http.config.RegistryBuilder;
import net.snowflake.client.jdbc.internal.apache.http.conn.socket.ConnectionSocketFactory;
import net.snowflake.client.jdbc.internal.apache.http.conn.socket.PlainConnectionSocketFactory;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.BasicCredentialsProvider;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.DefaultRedirectStrategy;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.HttpClientBuilder;
import net.snowflake.client.jdbc.internal.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import net.snowflake.client.jdbc.internal.apache.http.protocol.HttpContext;
import net.snowflake.client.jdbc.internal.apache.http.ssl.SSLInitializationException;
import net.snowflake.client.jdbc.internal.apache.http.util.EntityUtils;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Strings;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.OperationContext;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.SecretDetector;

public class HttpUtil {
    private static final SFLogger logger = SFLoggerFactory.getLogger(HttpUtil.class);
    static final int DEFAULT_MAX_CONNECTIONS = 300;
    static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 300;
    private static final int DEFAULT_HTTP_CLIENT_CONNECTION_TIMEOUT_IN_MS = 60000;
    static final int DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT_IN_MS = 300000;
    static final int DEFAULT_TTL = 60;
    static final int DEFAULT_IDLE_CONNECTION_TIMEOUT = 5;
    static final int DEFAULT_DOWNLOADED_CONDITION_TIMEOUT = 3600;
    public static final String JDBC_TTL = "net.snowflake.jdbc.ttl";
    static final String JDBC_CONNECTION_TIMEOUT_IN_MS_PROPERTY = "net.snowflake.jdbc.http_client_connection_timeout_in_ms";
    static final String JDBC_SOCKET_TIMEOUT_IN_MS_PROPERTY = "net.snowflake.jdbc.http_client_socket_timeout_in_ms";
    public static final String JDBC_MAX_CONNECTIONS_PROPERTY = "net.snowflake.jdbc.max_connections";
    public static final String JDBC_MAX_CONNECTIONS_PER_ROUTE_PROPERTY = "net.snowflake.jdbc.max_connections_per_route";
    public static Map<HttpClientSettingsKey, CloseableHttpClient> httpClient = new ConcurrentHashMap<HttpClientSettingsKey, CloseableHttpClient>();
    private static Map<HttpClientSettingsKey, CloseableHttpClient> httpClientWithoutDecompression = new ConcurrentHashMap<HttpClientSettingsKey, CloseableHttpClient>();
    static Map<HttpClientSettingsKey, SnowflakeMutableProxyRoutePlanner> httpClientRoutePlanner = new ConcurrentHashMap<HttpClientSettingsKey, SnowflakeMutableProxyRoutePlanner>();
    private static PoolingHttpClientConnectionManager connectionManager = null;
    private static RequestConfig DefaultRequestConfig = null;
    private static boolean socksProxyDisabled = false;

    @SnowflakeJdbcInternalApi
    public static Duration getConnectionTimeout() {
        return Duration.ofMillis(SystemUtil.convertSystemPropertyToIntValue(JDBC_CONNECTION_TIMEOUT_IN_MS_PROPERTY, 60000));
    }

    @SnowflakeJdbcInternalApi
    public static Duration getSocketTimeout() {
        return Duration.ofMillis(SystemUtil.convertSystemPropertyToIntValue(JDBC_SOCKET_TIMEOUT_IN_MS_PROPERTY, 300000));
    }

    public static long getDownloadedConditionTimeoutInSeconds() {
        return 3600L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeExpiredAndIdleConnections() {
        if (connectionManager != null) {
            PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = connectionManager;
            synchronized (poolingHttpClientConnectionManager) {
                logger.debug("connection pool stats: {}", connectionManager.getTotalStats());
                connectionManager.closeExpiredConnections();
                connectionManager.closeIdleConnections(5L, TimeUnit.SECONDS);
            }
        }
    }

    @Deprecated
    public static void setProxyForS3(HttpClientSettingsKey key, ClientConfiguration clientConfig) {
        S3HttpUtil.setProxyForS3(key, clientConfig);
    }

    @Deprecated
    public static void setSessionlessProxyForS3(Properties proxyProperties, ClientConfiguration clientConfig) throws SnowflakeSQLException {
        S3HttpUtil.setSessionlessProxyForS3(proxyProperties, clientConfig);
    }

    public static void setSessionlessProxyForAzure(Properties proxyProperties, OperationContext opContext) throws SnowflakeSQLException {
        Boolean useProxy;
        if (proxyProperties != null && proxyProperties.size() > 0 && proxyProperties.getProperty(SFSessionProperty.USE_PROXY.getPropertyKey()) != null && (useProxy = Boolean.valueOf(proxyProperties.getProperty(SFSessionProperty.USE_PROXY.getPropertyKey()))).booleanValue()) {
            int proxyPort;
            String proxyHost = proxyProperties.getProperty(SFSessionProperty.PROXY_HOST.getPropertyKey());
            try {
                proxyPort = Integer.parseInt(proxyProperties.getProperty(SFSessionProperty.PROXY_PORT.getPropertyKey()));
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new SnowflakeSQLException(ErrorCode.INVALID_PROXY_PROPERTIES, "Could not parse port number");
            }
            Proxy azProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            opContext.setProxy(azProxy);
        }
    }

    public static void setProxyForAzure(HttpClientSettingsKey key, OperationContext opContext) {
        if (key != null && key.usesProxy()) {
            Proxy azProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(key.getProxyHost(), key.getProxyPort()));
            opContext.setProxy(azProxy);
        }
    }

    @VisibleForTesting
    static String buildUserAgent(String customSuffix) {
        StringBuilder builder = new StringBuilder("JDBC/");
        builder.append(SnowflakeDriver.implementVersion);
        builder.append(" (");
        String osPlatform = SnowflakeUtil.systemGetProperty("os.name") != null ? SnowflakeUtil.systemGetProperty("os.name") : "";
        String osVersion = SnowflakeUtil.systemGetProperty("os.version") != null ? SnowflakeUtil.systemGetProperty("os.version") : "";
        builder.append(osPlatform);
        builder.append(" ");
        builder.append(osVersion);
        builder.append(") JAVA/");
        String languageVersion = SnowflakeUtil.systemGetProperty("java.version") != null ? SnowflakeUtil.systemGetProperty("java.version") : "";
        builder.append(languageVersion);
        if (!customSuffix.isEmpty()) {
            builder.append(" " + customSuffix);
        }
        String userAgent = builder.toString();
        return userAgent;
    }

    public static CloseableHttpClient buildHttpClient(@Nullable HttpClientSettingsKey key, File ocspCacheFile, boolean downloadUnCompressed) {
        boolean noDefaultRequestConfig;
        int timeToLive = SystemUtil.convertSystemPropertyToIntValue(JDBC_TTL, 60);
        logger.debug("time to live in connection pooling manager: {}", timeToLive);
        long connectTimeout = HttpUtil.getConnectionTimeout().toMillis();
        long socketTimeout = HttpUtil.getSocketTimeout().toMillis();
        logger.debug("Connect timeout is {} ms and socket timeout is {} for connection pooling manager", connectTimeout, socketTimeout);
        HttpHost proxy = key != null && key.usesProxy() ? new HttpHost(key.getProxyHost(), key.getProxyPort(), key.getProxyHttpProtocol().getScheme()) : null;
        boolean bl = noDefaultRequestConfig = DefaultRequestConfig == null || DefaultRequestConfig.getProxy() == null;
        if (noDefaultRequestConfig || !DefaultRequestConfig.getProxy().equals(proxy)) {
            RequestConfig.Builder builder = RequestConfig.custom().setConnectTimeout((int)connectTimeout).setConnectionRequestTimeout((int)connectTimeout).setSocketTimeout((int)socketTimeout);
            if (proxy != null && Strings.isNullOrEmpty(key.getNonProxyHosts())) {
                builder.setProxy(proxy);
            }
            DefaultRequestConfig = builder.build();
        }
        TrustManager[] trustManagers = null;
        if (key != null && key.getOcspMode() != OCSPMode.INSECURE) {
            try {
                TrustManager[] tm;
                trustManagers = tm = new TrustManager[]{new SFTrustManager(key, ocspCacheFile)};
            }
            catch (Error | Exception err) {
                StringWriter errors = new StringWriter();
                err.printStackTrace(new PrintWriter(errors));
                logger.error(errors.toString(), true);
                throw new RuntimeException(err);
            }
        }
        try {
            Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("https", new SFSSLConnectionSocketFactory(trustManagers, socksProxyDisabled)).register("http", (SFSSLConnectionSocketFactory)((Object)new SFConnectionSocketFactory())).build();
            connectionManager = new PoolingHttpClientConnectionManager(registry, null, null, null, timeToLive, TimeUnit.SECONDS);
            int maxConnections = SystemUtil.convertSystemPropertyToIntValue(JDBC_MAX_CONNECTIONS_PROPERTY, 300);
            int maxConnectionsPerRoute = SystemUtil.convertSystemPropertyToIntValue(JDBC_MAX_CONNECTIONS_PER_ROUTE_PROPERTY, 300);
            logger.debug("Max connections total in connection pooling manager: {}; max connections per route: {}", maxConnections, maxConnectionsPerRoute);
            connectionManager.setMaxTotal(maxConnections);
            connectionManager.setDefaultMaxPerRoute(maxConnectionsPerRoute);
            String userAgentSuffix = key != null ? key.getUserAgentSuffix() : "";
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setConnectionManager(connectionManager).useSystemProperties().setRedirectStrategy(new DefaultRedirectStrategy()).setUserAgent(HttpUtil.buildUserAgent(userAgentSuffix)).disableCookieManagement();
            if (key != null && key.usesProxy()) {
                SnowflakeMutableProxyRoutePlanner sdkProxyRoutePlanner = httpClientRoutePlanner.computeIfAbsent(key, k -> new SnowflakeMutableProxyRoutePlanner(key.getProxyHost(), key.getProxyPort(), key.getProxyHttpProtocol(), key.getNonProxyHosts()));
                httpClientBuilder = httpClientBuilder.setProxy(proxy).setRoutePlanner(sdkProxyRoutePlanner);
                if (!Strings.isNullOrEmpty(key.getProxyUser()) && !Strings.isNullOrEmpty(key.getProxyPassword())) {
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(key.getProxyUser(), key.getProxyPassword());
                    AuthScope authScope = new AuthScope(key.getProxyHost(), key.getProxyPort());
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(authScope, credentials);
                    httpClientBuilder = httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
                }
            }
            httpClientBuilder.setDefaultRequestConfig(DefaultRequestConfig);
            if (downloadUnCompressed) {
                httpClientBuilder = httpClientBuilder.disableContentCompression();
            }
            return httpClientBuilder.build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            throw new SSLInitializationException(ex.getMessage(), ex);
        }
    }

    public static void updateRoutePlanner(HttpClientSettingsKey key) {
        if (httpClientRoutePlanner.containsKey(key) && !httpClientRoutePlanner.get(key).getNonProxyHosts().equalsIgnoreCase(key.getNonProxyHosts())) {
            httpClientRoutePlanner.get(key).setNonProxyHosts(key.getNonProxyHosts());
        }
    }

    public static CloseableHttpClient getHttpClient(HttpClientSettingsKey ocspAndProxyKey) {
        return HttpUtil.initHttpClient(ocspAndProxyKey, null);
    }

    public static CloseableHttpClient getHttpClientWithoutDecompression(HttpClientSettingsKey ocspAndProxyKey) {
        return HttpUtil.initHttpClientWithoutDecompression(ocspAndProxyKey, null);
    }

    public static CloseableHttpClient initHttpClientWithoutDecompression(HttpClientSettingsKey key, File ocspCacheFile) {
        HttpUtil.updateRoutePlanner(key);
        return httpClientWithoutDecompression.computeIfAbsent(key, k -> HttpUtil.buildHttpClient(key, ocspCacheFile, true));
    }

    public static CloseableHttpClient initHttpClient(HttpClientSettingsKey key, File ocspCacheFile) {
        HttpUtil.updateRoutePlanner(key);
        return httpClient.computeIfAbsent(key, k -> HttpUtil.buildHttpClient(key, ocspCacheFile, key.getGzipDisabled()));
    }

    public static RequestConfig getDefaultRequestConfigWithSocketTimeout(int soTimeoutMs, boolean withoutCookies) {
        String cookieSpec = withoutCookies ? "ignoreCookies" : "default";
        return RequestConfig.copy(DefaultRequestConfig).setSocketTimeout(soTimeoutMs).setCookieSpec(cookieSpec).build();
    }

    public static RequestConfig getDefaultRequestConfigWithSocketAndConnectTimeout(int requestSocketAndConnectTimeout, boolean withoutCookies) {
        String cookieSpec = withoutCookies ? "ignoreCookies" : "default";
        return RequestConfig.copy(DefaultRequestConfig).setSocketTimeout(requestSocketAndConnectTimeout).setConnectTimeout(requestSocketAndConnectTimeout).setCookieSpec(cookieSpec).build();
    }

    public static RequestConfig getRequestConfigWithoutCookies() {
        return RequestConfig.copy(DefaultRequestConfig).setCookieSpec("ignoreCookies").build();
    }

    public static void setRequestConfig(RequestConfig requestConfig) {
        DefaultRequestConfig = requestConfig;
    }

    private static String getHttpClientStats() {
        return connectionManager == null ? "" : connectionManager.getTotalStats().toString();
    }

    public static void setSocksProxyDisabled(boolean socksProxyDisabled) {
        HttpUtil.socksProxyDisabled = socksProxyDisabled;
    }

    public static boolean isSocksProxyDisabled() {
        return socksProxyDisabled;
    }

    static String executeRequestWithoutCookies(HttpRequestBase httpRequest, int retryTimeout, int authTimeout, int socketTimeout, int retryCount, int injectSocketTimeout, AtomicBoolean canceling, HttpClientSettingsKey ocspAndProxyKey) throws SnowflakeSQLException, IOException {
        return HttpUtil.executeRequestInternal(httpRequest, retryTimeout, authTimeout, socketTimeout, retryCount, injectSocketTimeout, canceling, true, false, true, false, HttpUtil.getHttpClient(ocspAndProxyKey), new ExecTimeTelemetryData());
    }

    public static String executeGeneralRequest(HttpRequestBase httpRequest, int retryTimeout, int authTimeout, int socketTimeout, int retryCount, HttpClientSettingsKey ocspAndProxyAndGzipKey) throws SnowflakeSQLException, IOException {
        return HttpUtil.executeRequest(httpRequest, retryTimeout, authTimeout, socketTimeout, retryCount, 0, null, false, false, ocspAndProxyAndGzipKey, new ExecTimeTelemetryData());
    }

    public static String executeGeneralRequest(HttpRequestBase httpRequest, int retryTimeout, int authTimeout, int socketTimeout, int retryCount, CloseableHttpClient httpClient) throws SnowflakeSQLException, IOException {
        return HttpUtil.executeRequestInternal(httpRequest, retryTimeout, authTimeout, socketTimeout, retryCount, 0, null, false, false, true, false, httpClient, new ExecTimeTelemetryData());
    }

    public static String executeRequest(HttpRequestBase httpRequest, int retryTimeout, int authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean includeRetryParameters, boolean retryOnHTTP403, HttpClientSettingsKey ocspAndProxyKey, ExecTimeTelemetryData execTimeData) throws SnowflakeSQLException, IOException {
        boolean ocspEnabled = !ocspAndProxyKey.getOcspMode().equals((Object)OCSPMode.INSECURE);
        execTimeData.setOCSPStatus(ocspEnabled);
        return HttpUtil.executeRequestInternal(httpRequest, retryTimeout, authTimeout, socketTimeout, maxRetries, injectSocketTimeout, canceling, false, includeRetryParameters, true, retryOnHTTP403, HttpUtil.getHttpClient(ocspAndProxyKey), execTimeData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String executeRequestInternal(HttpRequestBase httpRequest, int retryTimeout, int authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeRequestGuid, boolean retryOnHTTP403, CloseableHttpClient httpClient, ExecTimeTelemetryData execTimeData) throws SnowflakeSQLException, IOException {
        String theString;
        String requestInfoScrubbed = SecretDetector.maskSASToken(httpRequest.toString());
        logger.debug("Pool: {} Executing: {}", HttpUtil::getHttpClientStats, requestInfoScrubbed);
        StringWriter writer = null;
        CloseableHttpResponse response = null;
        try {
            response = RestRequest.execute(httpClient, httpRequest, retryTimeout, authTimeout, socketTimeout, maxRetries, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeRequestGuid, retryOnHTTP403, execTimeData);
            if (response == null || response.getStatusLine().getStatusCode() != 200) {
                logger.error("Error executing request: {}", requestInfoScrubbed);
                SnowflakeUtil.logResponseDetails(response, logger);
                if (response != null) {
                    EntityUtils.consume(response.getEntity());
                }
                throw new SnowflakeSQLException("58030", (int)ErrorCode.NETWORK_ERROR.getMessageCode(), "HTTP status=" + (response != null ? Integer.valueOf(response.getStatusLine().getStatusCode()) : "null response"));
            }
            execTimeData.setResponseIOStreamStart();
            writer = new StringWriter();
            try (InputStream ins = response.getEntity().getContent();){
                IOUtils.copy(ins, (Writer)writer, "UTF-8");
            }
            theString = writer.toString();
            execTimeData.setResponseIOStreamEnd();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            IOUtils.closeQuietly(response);
            throw throwable;
        }
        IOUtils.closeQuietly(writer);
        IOUtils.closeQuietly((Closeable)response);
        logger.debug("Pool: {} Request returned for: {}", HttpUtil::getHttpClientStats, requestInfoScrubbed);
        return theString;
    }

    static void applyAdditionalHeadersForSnowsight(HttpRequestBase request, Map<String, String> additionalHeaders) {
        if (additionalHeaders != null && !additionalHeaders.isEmpty()) {
            additionalHeaders.forEach(request::addHeader);
        }
    }

    static final class SFConnectionSocketFactory
    extends PlainConnectionSocketFactory {
        SFConnectionSocketFactory() {
        }

        @Override
        public Socket createSocket(HttpContext ctx) throws IOException {
            if (socksProxyDisabled) {
                return new Socket(Proxy.NO_PROXY);
            }
            return super.createSocket(ctx);
        }
    }

    public static final class HttpInputStream
    extends InputStream {
        private final InputStream httpIn;

        public HttpInputStream(InputStream httpIn) {
            this.httpIn = httpIn;
        }

        @Override
        public final int available() throws IOException {
            int available = this.httpIn.available();
            return available == 0 ? 1 : available;
        }

        @Override
        public final int read() throws IOException {
            return this.httpIn.read();
        }

        @Override
        public final int read(byte[] b) throws IOException {
            return this.httpIn.read(b);
        }

        @Override
        public final int read(byte[] b, int off, int len) throws IOException {
            return this.httpIn.read(b, off, len);
        }

        @Override
        public final long skip(long n) throws IOException {
            return this.httpIn.skip(n);
        }

        @Override
        public final void close() throws IOException {
            this.httpIn.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.httpIn.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.httpIn.reset();
        }

        @Override
        public final boolean markSupported() {
            return this.httpIn.markSupported();
        }
    }
}

