/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.tracing;

import java.util.concurrent.CancellationException;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutureCallback;
import net.snowflake.client.jdbc.internal.google.api.gax.tracing.ApiTracer;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.javax.annotation.Nonnull;

class TraceFinisher<T>
implements ApiFutureCallback<T> {
    private final ApiTracer tracer;

    TraceFinisher(@Nonnull ApiTracer tracer) {
        this.tracer = Preconditions.checkNotNull(tracer, "tracer can't be null");
    }

    @Override
    public void onFailure(Throwable throwable) {
        if (throwable instanceof CancellationException) {
            this.tracer.operationCancelled();
        } else {
            this.tracer.operationFailed(throwable);
        }
    }

    @Override
    public void onSuccess(T responseT) {
        this.tracer.operationSucceeded();
    }
}

