/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.AlgorithmParametersHelper;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.impl.CipherHelper;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RSA_OAEP_512 {
    private static MGF1ParameterSpec mgf1ParameterSpec = MGF1ParameterSpec.SHA512;
    private static final String RSA_OEAP_512_JCA_ALG = "RSA/ECB/OAEPWithSHA-512AndMGF1Padding";

    public static byte[] encryptCEK(RSAPublicKey pub, SecretKey cek, Provider provider) throws JOSEException {
        try {
            AlgorithmParameters algp = AlgorithmParametersHelper.getInstance("OAEP", provider);
            OAEPParameterSpec paramSpec = new OAEPParameterSpec("SHA-512", "MGF1", mgf1ParameterSpec, PSource.PSpecified.DEFAULT);
            algp.init(paramSpec);
            Cipher cipher = CipherHelper.getInstance(RSA_OEAP_512_JCA_ALG, provider);
            cipher.init(1, (Key)pub, algp);
            return cipher.doFinal(cek.getEncoded());
        }
        catch (IllegalBlockSizeException e) {
            throw new JOSEException("RSA block size exception: The RSA key is too short, try a longer one", e);
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    public static SecretKey decryptCEK(PrivateKey priv, byte[] encryptedCEK, Provider provider) throws JOSEException {
        try {
            AlgorithmParameters algp = AlgorithmParametersHelper.getInstance("OAEP", provider);
            OAEPParameterSpec paramSpec = new OAEPParameterSpec("SHA-512", "MGF1", mgf1ParameterSpec, PSource.PSpecified.DEFAULT);
            algp.init(paramSpec);
            Cipher cipher = CipherHelper.getInstance(RSA_OEAP_512_JCA_ALG, provider);
            cipher.init(2, (Key)priv, algp);
            return new SecretKeySpec(cipher.doFinal(encryptedCEK), "AES");
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    private RSA_OAEP_512() {
    }
}

