/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.httpjson;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.RestSerializationException;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.google.gson.JsonElement;
import net.snowflake.client.jdbc.internal.google.gson.JsonParser;
import net.snowflake.client.jdbc.internal.google.protobuf.InvalidProtocolBufferException;
import net.snowflake.client.jdbc.internal.google.protobuf.Message;
import net.snowflake.client.jdbc.internal.google.protobuf.TypeRegistry;
import net.snowflake.client.jdbc.internal.google.protobuf.util.JsonFormat;

@BetaApi
public class ProtoRestSerializer<RequestT extends Message> {
    private final TypeRegistry registry;

    private ProtoRestSerializer(TypeRegistry registry) {
        this.registry = registry;
    }

    public static <RequestT extends Message> ProtoRestSerializer<RequestT> create() {
        return ProtoRestSerializer.create(TypeRegistry.getEmptyTypeRegistry());
    }

    static <RequestT extends Message> ProtoRestSerializer<RequestT> create(TypeRegistry registry) {
        return new ProtoRestSerializer<RequestT>(registry);
    }

    String toJson(Message message, boolean numericEnum) {
        try {
            JsonFormat.Printer printer = JsonFormat.printer().usingTypeRegistry(this.registry);
            if (numericEnum) {
                return printer.printingEnumsAsInts().print(message);
            }
            return printer.print(message);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RestSerializationException("Failed to serialize message to JSON", e);
        }
    }

    RequestT fromJson(Reader json, Message.Builder builder) {
        try {
            JsonFormat.parser().usingTypeRegistry(this.registry).ignoringUnknownFields().merge(json, builder);
            return (RequestT)builder.build();
        }
        catch (IOException e) {
            throw new RestSerializationException("Failed to parse response message", e);
        }
    }

    public void putPathParam(Map<String, String> fields, String fieldName, Object fieldValue) {
        fields.put(fieldName, String.valueOf(fieldValue));
    }

    private void putDecomposedMessageQueryParam(Map<String, List<String>> fields, String fieldName, JsonElement parsed) {
        if (parsed.isJsonPrimitive() || parsed.isJsonNull()) {
            this.putQueryParam(fields, fieldName, parsed.getAsString());
        } else if (parsed.isJsonArray()) {
            for (JsonElement element : parsed.getAsJsonArray()) {
                this.putDecomposedMessageQueryParam(fields, fieldName, element);
            }
        } else {
            for (String key : parsed.getAsJsonObject().keySet()) {
                this.putDecomposedMessageQueryParam(fields, String.format("%s.%s", fieldName, key), parsed.getAsJsonObject().get(key));
            }
        }
    }

    public void putQueryParam(Map<String, List<String>> fields, String fieldName, Object fieldValue) {
        ArrayList<String> currentParamValueList = new ArrayList<String>();
        ImmutableList<Object> toProcess = fieldValue instanceof List ? (ImmutableList<Object>)fieldValue : ImmutableList.of(fieldValue);
        for (Object e : toProcess) {
            if (e instanceof Message) {
                String json = this.toJson((Message)e, true);
                JsonElement parsed = JsonParser.parseString(json);
                this.putDecomposedMessageQueryParam(fields, fieldName, parsed);
                continue;
            }
            currentParamValueList.add(String.valueOf(e));
        }
        if (currentParamValueList.isEmpty()) {
            return;
        }
        List accumulativeParamValueList = fields.getOrDefault(fieldName, new ArrayList());
        accumulativeParamValueList.addAll(currentParamValueList);
        fields.put(fieldName, accumulativeParamValueList);
    }

    public String toBody(String fieldName, RequestT fieldValue) {
        return this.toJson((Message)fieldValue, false);
    }

    public String toBody(String fieldName, RequestT fieldValue, boolean numericEnum) {
        return this.toJson((Message)fieldValue, numericEnum);
    }
}

