/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.httpjson;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.google.api.core.AbstractApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.ApiMethodDescriptor;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonCallContext;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonCallOptions;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonClientCall;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonMetadata;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonStatusRuntimeException;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ApiCallContext;
import net.snowflake.client.jdbc.internal.threeten.bp.Instant;

class HttpJsonClientCalls {
    private static final Logger LOGGER = Logger.getLogger(HttpJsonClientCalls.class.getName());

    HttpJsonClientCalls() {
    }

    public static <RequestT, ResponseT> HttpJsonClientCall<RequestT, ResponseT> newCall(ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor, ApiCallContext context) {
        HttpJsonCallContext httpJsonContext = HttpJsonCallContext.createDefault().nullToSelf(context);
        if (httpJsonContext.getTimeout() != null) {
            Instant newDeadline = Instant.now().plus(httpJsonContext.getTimeout());
            HttpJsonCallOptions callOptions = httpJsonContext.getCallOptions();
            if (callOptions.getDeadline() == null || newDeadline.isBefore(callOptions.getDeadline())) {
                callOptions = callOptions.toBuilder().setDeadline(newDeadline).build();
                httpJsonContext = httpJsonContext.withCallOptions(callOptions);
            }
        }
        return httpJsonContext.getChannel().newCall(methodDescriptor, httpJsonContext.getCallOptions());
    }

    static <RequestT, ResponseT> ApiFuture<ResponseT> eagerFutureUnaryCall(HttpJsonClientCall<RequestT, ResponseT> clientCall, RequestT request) {
        HttpJsonFuture future = new HttpJsonFuture(clientCall);
        clientCall.start(new FutureListener(future), HttpJsonMetadata.newBuilder().build());
        try {
            clientCall.sendMessage(request);
            clientCall.halfClose();
            clientCall.request(2);
        }
        catch (Throwable sendError) {
            try {
                clientCall.cancel(null, sendError);
            }
            catch (Throwable cancelError) {
                LOGGER.log(Level.SEVERE, "Error encountered while closing it", sendError);
            }
            throw sendError;
        }
        return future;
    }

    private static class FutureListener<T>
    extends HttpJsonClientCall.Listener<T> {
        private final HttpJsonFuture<T> future;

        private FutureListener(HttpJsonFuture<T> future) {
            this.future = future;
        }

        @Override
        public void onMessage(T message) {
            if (!this.future.set(message)) {
                throw new IllegalStateException("More than one value received for unary call");
            }
        }

        @Override
        public void onClose(int statusCode, HttpJsonMetadata trailers) {
            if (!this.future.isDone()) {
                if (trailers == null || trailers.getException() == null) {
                    this.future.setException(new HttpJsonStatusRuntimeException(statusCode, "Exception during a client call closure", new NullPointerException("Both response message and response exception were null")));
                } else {
                    this.future.setException(trailers.getException());
                }
            } else if (statusCode < 200 || statusCode >= 400) {
                LOGGER.log(Level.WARNING, "Received error for unary call after receiving a successful response");
            }
        }
    }

    private static class HttpJsonFuture<T>
    extends AbstractApiFuture<T> {
        private final HttpJsonClientCall<?, T> call;

        private HttpJsonFuture(HttpJsonClientCall<?, T> call) {
            this.call = call;
        }

        @Override
        protected void interruptTask() {
            this.call.cancel("HttpJsonFuture was cancelled", null);
        }

        @Override
        public boolean set(T value) {
            return super.set(value);
        }

        @Override
        public boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }
    }
}

