/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.util.HashMap;
import java.util.Map;
import net.snowflake.client.core.HostSpecSSD;
import net.snowflake.client.core.KeyUpdSSD;
import net.snowflake.client.core.SFTrustManager;
import net.snowflake.client.core.SSDKeyManager;
import net.snowflake.client.core.SSDPubKey;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ocsp.CertID;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

class SSDManager {
    private static final SFLogger LOGGER = SFLoggerFactory.getLogger(SSDManager.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static String SF_SSD_CACHE;
    private static SSDKeyManager pub_key_dep1;
    private static SSDKeyManager pub_key_dep2;
    private static final String keyUpdDirEnvVariable = "SF_KEY_UPD_SSD";
    private static final String hostSpecBypassEnvVariable = "SF_HOST_SPEC_BYPASS_SSD";
    private static KeyUpdSSD keyUpdateSSD;
    private static HostSpecSSD hostSpecBypassSSD;
    private static boolean ACTIVATE_SSD;

    SSDManager() {
        String ssd_status = null;
        String key_upd_ssd = null;
        String host_spec_ssd = null;
        try {
            ssd_status = SnowflakeUtil.systemGetEnv("SF_OCSP_ACTIVATE_SSD");
            if (ssd_status != null) {
                key_upd_ssd = SnowflakeUtil.systemGetEnv(keyUpdDirEnvVariable);
                host_spec_ssd = SnowflakeUtil.systemGetEnv(hostSpecBypassEnvVariable);
            }
        }
        catch (Throwable ex) {
            LOGGER.debug("Failed to get environment variable for Server Side Directive support", false);
        }
        if (ssd_status == null && (ssd_status = SnowflakeUtil.systemGetProperty("net.snowflake.jdbc.ssd_support_enabled")) != null) {
            key_upd_ssd = SnowflakeUtil.systemGetProperty("net.snowflake.jdbc.key_upd_ssd");
            host_spec_ssd = SnowflakeUtil.systemGetProperty("net.snowflake.jdbc.host_spec_ssd");
        }
        if (ACTIVATE_SSD = Boolean.TRUE.toString().equalsIgnoreCase(ssd_status)) {
            this.clearSSDCache();
            pub_key_dep1.SSD_setKey(SSDPubKey.getPublicKeyInternal("dep1"), 0.1);
            pub_key_dep2.SSD_setKey(SSDPubKey.getPublicKeyInternal("dep2"), 0.1);
            try {
                JsonNode jnode_key_upd;
                if (key_upd_ssd != null) {
                    keyUpdateSSD = new KeyUpdSSD();
                }
                if (host_spec_ssd != null) {
                    hostSpecBypassSSD = new HostSpecSSD();
                }
                if ((jnode_key_upd = OBJECT_MAPPER.readTree(key_upd_ssd)).has("dep1")) {
                    keyUpdateSSD.setIssuer("dep1");
                    keyUpdateSSD.setKeyUpdDirective(jnode_key_upd.get("dep1").textValue());
                } else {
                    keyUpdateSSD.setIssuer("dep2");
                    keyUpdateSSD.setKeyUpdDirective(jnode_key_upd.get("dep2").textValue());
                }
                JsonNode jnode_host_spec = OBJECT_MAPPER.readTree(host_spec_ssd);
                Map keyVal = OBJECT_MAPPER.readValue(host_spec_ssd, HashMap.class);
                for (String key_val : keyVal.keySet()) {
                    String ssd_val = jnode_host_spec.get(key_val).textValue();
                    hostSpecBypassSSD.setHostname(key_val);
                    hostSpecBypassSSD.setHostSpecDirective(ssd_val);
                }
            }
            catch (Throwable ex) {
                LOGGER.debug("Could not read JSON from the directive passed.", false);
            }
        }
    }

    boolean getSSDSupportStatus() {
        return ACTIVATE_SSD;
    }

    void addToSSDCache(String host_spec_ssd) {
        SF_SSD_CACHE = host_spec_ssd;
    }

    void clearSSDCache() {
        SF_SSD_CACHE = null;
    }

    String getSSDFromCache() {
        return SF_SSD_CACHE;
    }

    void updateKey(String dep, String pub_key, float ver) {
        if (dep.equals("dep1")) {
            pub_key_dep1.SSD_setKey(pub_key, ver);
        } else if (dep.equals("dep2")) {
            pub_key_dep2.SSD_setKey(pub_key, ver);
        }
        LOGGER.debug("Failed to update public key, unknown issuing deployment", false);
    }

    String getPubKey(String dep) {
        if (dep.equals("dep1")) {
            return pub_key_dep1.SSD_getKey();
        }
        if (dep.equals("dep2")) {
            return pub_key_dep2.SSD_getKey();
        }
        LOGGER.debug("Invalid deployment name", false);
        return null;
    }

    double getPubKeyVer(String dep) {
        if (dep.equals("dep1")) {
            return pub_key_dep1.SSD_getKeyVer();
        }
        if (dep.equals("dep2")) {
            return pub_key_dep2.SSD_getKeyVer();
        }
        LOGGER.debug("Invalid deployment name", false);
        return -1.0;
    }

    KeyUpdSSD getKeyUpdateSSD() {
        return keyUpdateSSD;
    }

    HostSpecSSD getHostSpecBypassSSD() {
        return hostSpecBypassSSD;
    }

    SFTrustManager.OcspResponseCacheKey getWildCardCertId() {
        SFTrustManager.SHA1DigestCalculator digest = new SFTrustManager.SHA1DigestCalculator();
        AlgorithmIdentifier algo = digest.getAlgorithmIdentifier();
        ASN1OctetString nameHash = ASN1OctetString.getInstance((Object)"0");
        ASN1OctetString keyHash = ASN1OctetString.getInstance((Object)"0");
        ASN1Integer serial_number = ASN1Integer.getInstance((Object)0);
        CertID cid = new CertID(algo, nameHash, keyHash, serial_number);
        SFTrustManager.OcspResponseCacheKey keyOcspResp = null;
        try {
            keyOcspResp = new SFTrustManager.OcspResponseCacheKey(ASN1OctetString.getInstance((Object)"0").getEncoded(), ASN1OctetString.getInstance((Object)"0").getEncoded(), ASN1Integer.getInstance((Object)0).getValue());
        }
        catch (Throwable ex) {
            LOGGER.debug("Could not create wildcard certid as cache key", false);
            keyOcspResp = null;
        }
        return keyOcspResp;
    }

    static {
        pub_key_dep1 = new SSDKeyManager();
        pub_key_dep2 = new SSDKeyManager();
    }
}

