/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.common.graph;

import net.snowflake.client.jdbc.internal.google.common.annotations.Beta;
import net.snowflake.client.jdbc.internal.google.common.base.Function;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableMap;
import net.snowflake.client.jdbc.internal.google.common.collect.Maps;
import net.snowflake.client.jdbc.internal.google.common.graph.ConfigurableValueGraph;
import net.snowflake.client.jdbc.internal.google.common.graph.DirectedGraphConnections;
import net.snowflake.client.jdbc.internal.google.common.graph.EndpointPair;
import net.snowflake.client.jdbc.internal.google.common.graph.GraphConnections;
import net.snowflake.client.jdbc.internal.google.common.graph.ImmutableGraph;
import net.snowflake.client.jdbc.internal.google.common.graph.MutableValueGraph;
import net.snowflake.client.jdbc.internal.google.common.graph.UndirectedGraphConnections;
import net.snowflake.client.jdbc.internal.google.common.graph.ValueGraph;
import net.snowflake.client.jdbc.internal.google.common.graph.ValueGraphBuilder;
import net.snowflake.client.jdbc.internal.google.errorprone.annotations.CanIgnoreReturnValue;
import net.snowflake.client.jdbc.internal.google.errorprone.annotations.Immutable;

@Immutable(containerOf={"N", "V"})
@Beta
public final class ImmutableValueGraph<N, V>
extends ConfigurableValueGraph<N, V> {
    private ImmutableValueGraph(ValueGraph<N, V> graph) {
        super(ValueGraphBuilder.from(graph), ImmutableValueGraph.getNodeConnections(graph), graph.edges().size());
    }

    public static <N, V> ImmutableValueGraph<N, V> copyOf(ValueGraph<N, V> graph) {
        return graph instanceof ImmutableValueGraph ? (ImmutableValueGraph<N, V>)graph : new ImmutableValueGraph<N, V>(graph);
    }

    @Deprecated
    public static <N, V> ImmutableValueGraph<N, V> copyOf(ImmutableValueGraph<N, V> graph) {
        return Preconditions.checkNotNull(graph);
    }

    @Override
    public ImmutableGraph<N> asGraph() {
        return new ImmutableGraph(this);
    }

    private static <N, V> ImmutableMap<N, GraphConnections<N, V>> getNodeConnections(ValueGraph<N, V> graph) {
        ImmutableMap.Builder<N, GraphConnections<N, V>> nodeConnections = ImmutableMap.builder();
        for (N node : graph.nodes()) {
            nodeConnections.put(node, ImmutableValueGraph.connectionsOf(graph, node));
        }
        return nodeConnections.build();
    }

    private static <N, V> GraphConnections<N, V> connectionsOf(final ValueGraph<N, V> graph, final N node) {
        Function successorNodeToValueFn = new Function<N, V>(){

            @Override
            public V apply(N successorNode) {
                return graph.edgeValueOrDefault(node, successorNode, null);
            }
        };
        return graph.isDirected() ? DirectedGraphConnections.ofImmutable(graph.predecessors((Object)node), Maps.asMap(graph.successors((Object)node), successorNodeToValueFn)) : UndirectedGraphConnections.ofImmutable(Maps.asMap(graph.adjacentNodes(node), successorNodeToValueFn));
    }

    public static class Builder<N, V> {
        private final MutableValueGraph<N, V> mutableValueGraph;

        Builder(ValueGraphBuilder<N, V> graphBuilder) {
            this.mutableValueGraph = graphBuilder.build();
        }

        @CanIgnoreReturnValue
        public Builder<N, V> addNode(N node) {
            this.mutableValueGraph.addNode(node);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<N, V> putEdgeValue(N nodeU, N nodeV, V value) {
            this.mutableValueGraph.putEdgeValue(nodeU, nodeV, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<N, V> putEdgeValue(EndpointPair<N> endpoints, V value) {
            this.mutableValueGraph.putEdgeValue(endpoints, value);
            return this;
        }

        public ImmutableValueGraph<N, V> build() {
            return ImmutableValueGraph.copyOf(this.mutableValueGraph);
        }
    }
}

