/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.core;

import java.io.IOException;
import java.util.List;
import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.api.gax.core.AutoValue_GoogleCredentialsProvider;
import net.snowflake.client.jdbc.internal.google.api.gax.core.CredentialsProvider;
import net.snowflake.client.jdbc.internal.google.auth.Credentials;
import net.snowflake.client.jdbc.internal.google.auth.oauth2.GoogleCredentials;
import net.snowflake.client.jdbc.internal.google.auth.oauth2.ServiceAccountCredentials;
import net.snowflake.client.jdbc.internal.google.auth.oauth2.ServiceAccountJwtAccessCredentials;
import net.snowflake.client.jdbc.internal.google.auto.value.AutoValue;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

@AutoValue
public abstract class GoogleCredentialsProvider
implements CredentialsProvider {
    public abstract List<String> getScopesToApply();

    @BetaApi
    public abstract List<String> getJwtEnabledScopes();

    @BetaApi
    public abstract boolean getUseJwtAccessWithScope();

    @Nullable
    @VisibleForTesting
    abstract GoogleCredentials getOAuth2Credentials();

    @Override
    public Credentials getCredentials() throws IOException {
        ServiceAccountCredentials serviceAccount;
        GoogleCredentials credentials = this.getOAuth2Credentials();
        if (credentials == null) {
            credentials = GoogleCredentials.getApplicationDefault();
        }
        boolean hasJwtEnabledScope = false;
        for (String scope : this.getJwtEnabledScopes()) {
            if (!this.getScopesToApply().contains(scope)) continue;
            hasJwtEnabledScope = true;
            break;
        }
        if (credentials instanceof ServiceAccountCredentials && hasJwtEnabledScope) {
            serviceAccount = (ServiceAccountCredentials)credentials;
            return ServiceAccountJwtAccessCredentials.newBuilder().setClientEmail(serviceAccount.getClientEmail()).setClientId(serviceAccount.getClientId()).setPrivateKey(serviceAccount.getPrivateKey()).setPrivateKeyId(serviceAccount.getPrivateKeyId()).setQuotaProjectId(serviceAccount.getQuotaProjectId()).build();
        }
        if (credentials.createScopedRequired()) {
            credentials = credentials.createScoped(this.getScopesToApply());
        }
        if (this.getUseJwtAccessWithScope() && credentials instanceof ServiceAccountCredentials) {
            serviceAccount = (ServiceAccountCredentials)credentials;
            return serviceAccount.createWithUseJwtAccessWithScope(true);
        }
        return credentials;
    }

    public static Builder newBuilder() {
        return new AutoValue_GoogleCredentialsProvider.Builder().setJwtEnabledScopes(ImmutableList.of()).setUseJwtAccessWithScope(false);
    }

    public abstract Builder toBuilder();

    @BetaApi
    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setScopesToApply(List<String> var1);

        public abstract List<String> getScopesToApply();

        @VisibleForTesting
        abstract Builder setOAuth2Credentials(GoogleCredentials var1);

        @BetaApi
        public abstract Builder setJwtEnabledScopes(List<String> var1);

        @BetaApi
        public abstract List<String> getJwtEnabledScopes();

        @BetaApi
        public abstract Builder setUseJwtAccessWithScope(boolean var1);

        @BetaApi
        public abstract boolean getUseJwtAccessWithScope();

        public GoogleCredentialsProvider build() {
            this.setScopesToApply(ImmutableList.copyOf(this.getScopesToApply()));
            this.setJwtEnabledScopes(ImmutableList.copyOf(this.getJwtEnabledScopes()));
            this.setUseJwtAccessWithScope(this.getUseJwtAccessWithScope());
            return this.autoBuild();
        }

        abstract GoogleCredentialsProvider autoBuild();
    }
}

