/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl;

import java.util.Collections;
import java.util.Set;
import net.snowflake.ingest.internal.com.nimbusds.jose.Header;
import net.snowflake.ingest.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWEHeader;

public class CriticalHeaderParamsDeferral {
    private Set<String> deferredParams = Collections.emptySet();

    public Set<String> getProcessedCriticalHeaderParams() {
        return Collections.emptySet();
    }

    public Set<String> getDeferredCriticalHeaderParams() {
        return Collections.unmodifiableSet(this.deferredParams);
    }

    public void setDeferredCriticalHeaderParams(Set<String> defCritHeaders) {
        this.deferredParams = defCritHeaders == null ? Collections.emptySet() : defCritHeaders;
    }

    public boolean headerPasses(Header header) {
        Set<String> crit = header.getCriticalParams();
        if (crit == null || crit.isEmpty()) {
            return true;
        }
        return this.deferredParams != null && this.deferredParams.containsAll(crit);
    }

    public void ensureHeaderPasses(JWEHeader header) throws JOSEException {
        if (!this.headerPasses(header)) {
            throw new JOSEException("Unsupported critical header parameter(s)");
        }
    }
}

