/*
 * Decompiled with CFR 0.152.
 */
package an.awesome.pipelinr.repack.com.google.common.collect;

import an.awesome.pipelinr.repack.com.google.common.annotations.GwtCompatible;
import an.awesome.pipelinr.repack.com.google.common.collect.ElementTypesAreNonnullByDefault;
import an.awesome.pipelinr.repack.com.google.common.collect.ForwardingCollection;
import an.awesome.pipelinr.repack.com.google.common.collect.ParametricNullness;
import an.awesome.pipelinr.repack.com.google.errorprone.annotations.CanIgnoreReturnValue;
import an.awesome.pipelinr.repack.javax.annotation.CheckForNull;
import java.util.NoSuchElementException;
import java.util.Queue;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingQueue<E>
extends ForwardingCollection<E>
implements Queue<E> {
    protected ForwardingQueue() {
    }

    @Override
    protected abstract Queue<E> delegate();

    @Override
    @CanIgnoreReturnValue
    public boolean offer(@ParametricNullness E o) {
        return this.delegate().offer(o);
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public E poll() {
        return this.delegate().poll();
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public E remove() {
        return this.delegate().remove();
    }

    @Override
    @CheckForNull
    public E peek() {
        return this.delegate().peek();
    }

    @Override
    @ParametricNullness
    public E element() {
        return this.delegate().element();
    }

    protected boolean standardOffer(@ParametricNullness E e) {
        try {
            return this.add(e);
        }
        catch (IllegalStateException caught) {
            return false;
        }
    }

    @CheckForNull
    protected E standardPeek() {
        try {
            return this.element();
        }
        catch (NoSuchElementException caught) {
            return null;
        }
    }

    @CheckForNull
    protected E standardPoll() {
        try {
            return this.remove();
        }
        catch (NoSuchElementException caught) {
            return null;
        }
    }
}

