/*
 * Decompiled with CFR 0.152.
 */
package an.awesome.pipelinr.repack.com.google.common.collect;

import an.awesome.pipelinr.repack.com.google.common.annotations.GwtCompatible;
import an.awesome.pipelinr.repack.com.google.common.base.Function;
import an.awesome.pipelinr.repack.com.google.common.base.Objects;
import an.awesome.pipelinr.repack.com.google.common.base.Preconditions;
import an.awesome.pipelinr.repack.com.google.common.collect.ElementTypesAreNonnullByDefault;
import an.awesome.pipelinr.repack.com.google.common.collect.Ordering;
import an.awesome.pipelinr.repack.com.google.common.collect.ParametricNullness;
import an.awesome.pipelinr.repack.javax.annotation.CheckForNull;
import java.io.Serializable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class ByFunctionOrdering<F, T>
extends Ordering<F>
implements Serializable {
    final Function<F, ? extends T> function;
    final Ordering<T> ordering;
    private static final long serialVersionUID = 0L;

    ByFunctionOrdering(Function<F, ? extends T> function, Ordering<T> ordering) {
        this.function = Preconditions.checkNotNull(function);
        this.ordering = Preconditions.checkNotNull(ordering);
    }

    @Override
    public int compare(@ParametricNullness F left, @ParametricNullness F right) {
        return this.ordering.compare(this.function.apply(left), this.function.apply(right));
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ByFunctionOrdering) {
            ByFunctionOrdering that = (ByFunctionOrdering)object;
            return this.function.equals(that.function) && this.ordering.equals(that.ordering);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.function, this.ordering);
    }

    public String toString() {
        return this.ordering + ".onResultOf(" + this.function + ")";
    }
}

