/*
 * Decompiled with CFR 0.152.
 */
package an.awesome.pipelinr;

import an.awesome.pipelinr.AggregateException;
import an.awesome.pipelinr.NotificationHandlingStrategy;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;

public class ParallelWhenAny
implements NotificationHandlingStrategy {
    private final ExecutorService threadPool;

    public ParallelWhenAny(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public void handle(List<Runnable> runnableNotifications) {
        CopyOnWriteArrayList<Throwable> exceptions = new CopyOnWriteArrayList<Throwable>();
        List<CompletableFuture> futures = runnableNotifications.stream().map(runnable -> CompletableFuture.runAsync(runnable, this.threadPool).exceptionally(throwable -> {
            exceptions.add((Throwable)throwable);
            return null;
        })).collect(Collectors.toList());
        CompletableFuture.anyOf(futures.toArray(new CompletableFuture[0])).join();
        if (!exceptions.isEmpty()) {
            throw new AggregateException(exceptions);
        }
    }
}

