/*
 * Decompiled with CFR 0.152.
 */
package an.awesome.pipelinr;

import an.awesome.pipelinr.Command;
import java.util.Collection;
import java.util.stream.Collectors;

public class CommandHasMultipleHandlersException
extends RuntimeException {
    private final String message;

    public CommandHasMultipleHandlersException(Command command, Collection<Command.Handler> matchingHandlers) {
        String commandName = command.getClass().getSimpleName();
        String handlerNames = matchingHandlers.stream().map(it -> it.getClass().getSimpleName()).collect(Collectors.joining(", "));
        this.message = "Command " + commandName + " must have a single matching handler, but found " + matchingHandlers.size() + " (" + handlerNames + ")";
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

