/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.codec;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.codec.DecodingException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.apache.commons.codec.binary.Base32;

public final class Base32Support {
    public static final boolean CHUNKED = true;
    public static final boolean UNCHUNKED = false;
    @Nonnull
    private static final Base32 CHUNKED_ENCODER = new Base32(76, new byte[]{10});
    @Nonnull
    private static final Base32 UNCHUNKED_ENCODER = new Base32(0, new byte[]{10});

    private Base32Support() {
    }

    @Nonnull
    public static String encode(@Nonnull byte[] data, boolean chunked) {
        Constraint.isNotNull(data, "Binary data to be encoded can not be null");
        if (chunked) {
            return Constraint.isNotNull(StringSupport.trim(CHUNKED_ENCODER.encodeToString(data)), "Encoded data was null");
        }
        return Constraint.isNotNull(StringSupport.trim(UNCHUNKED_ENCODER.encodeToString(data)), "Encoded data was null");
    }

    @Nonnull
    public static byte[] decode(@Nonnull String data) throws DecodingException {
        Constraint.isNotNull(data, "Base32 encoded data can not be null");
        try {
            byte[] decoded = CHUNKED_ENCODER.decode(data);
            if (null == decoded) {
                throw new DecodingException("Base32 decoded data was null");
            }
            return decoded;
        }
        catch (Exception e) {
            throw new DecodingException("Unable to Base32 decode input data, input invalid", e);
        }
    }
}

