/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.utilities.java.support.primitive;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.CharsetDecoder;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import net.shibboleth.shared.annotation.constraint.NullableElements;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.DeprecationSupport.ObjectType;

/**
 * Legacy stub for {@link net.shibboleth.shared.primitive.StringSupport}.
 * 
 * @deprecated
 */
@Deprecated(since="9.0.0", forRemoval=true)
public final class StringSupport {

    /** Constructor. */
    private StringSupport() {
    }

    /**
     * Reads an input stream into a string. The provided stream is <strong>not</strong> closed.
     * 
     * @param input the input stream to read
     * @param decoder character decoder to use, if null, system default character set is used
     * 
     * @return the string read from the stream
     * 
     * @throws IOException thrown if there is a problem reading from the stream and decoding it
     */
    @Nonnull public static String inputStreamToString(@Nonnull final InputStream input,
            @Nullable final CharsetDecoder decoder) throws IOException {
        DeprecationSupport.warn(ObjectType.CLASS, StringSupport.class.getName(), null,
                net.shibboleth.shared.primitive.StringSupport.class.getName());
        
        return net.shibboleth.shared.primitive.StringSupport.inputStreamToString(input, decoder);
    }

    /**
     * Converts a List of objects into a single string, with values separated by a specified delimiter.
     * 
     * @param values list of objects
     * @param delimiter the delimiter used between values
     * 
     * @return delimited string of values
     */
    @Nonnull public static String listToStringValue(@Nonnull final List<?> values, @Nonnull final String delimiter) {
        DeprecationSupport.warn(ObjectType.CLASS, StringSupport.class.getName(), null,
                net.shibboleth.shared.primitive.StringSupport.class.getName());

        return net.shibboleth.shared.primitive.StringSupport.listToStringValue(values, delimiter);
    }

    /**
     * Converts a delimited string into a list. We cannot use an ungarnished tokenizer since it doesn't add an empty
     * String if the end of the input String was the delimiter. Hence we have to explicitly check.
     * 
     * @param string the string to be split into a list
     * @param delimiter the delimiter between values. This string may contain multiple delimiter characters, as allowed
     *            by {@link StringTokenizer}
     * 
     * @return the list of values or an empty list if the given string is empty
     */
    @Nonnull public static List<String> stringToList(@Nonnull final String string, @Nonnull final String delimiter) {
        DeprecationSupport.warn(ObjectType.CLASS, StringSupport.class.getName(), null,
                net.shibboleth.shared.primitive.StringSupport.class.getName());
        
        return net.shibboleth.shared.primitive.StringSupport.stringToList(string, delimiter);
    }

    /**
     * Safely trims a string.
     * 
     * @param s the string to trim, may be null
     * 
     * @return the trimmed string or null if the given string was null
     */
    @Nullable public static String trim(@Nullable final String s) {
        DeprecationSupport.warn(ObjectType.CLASS, StringSupport.class.getName(), null,
                net.shibboleth.shared.primitive.StringSupport.class.getName());

        return net.shibboleth.shared.primitive.StringSupport.trim(s);
    }

    /**
     * Safely trims a string and, if empty, converts it to null.
     * 
     * @param s the string to trim, may be null
     * 
     * @return the trimmed string or null if the given string was null or the trimmed string was empty
     */
    @Nullable public static String trimOrNull(@Nullable final String s) {
        DeprecationSupport.warn(ObjectType.CLASS, StringSupport.class.getName(), null,
                net.shibboleth.shared.primitive.StringSupport.class.getName());

        return net.shibboleth.shared.primitive.StringSupport.trimOrNull(s);
    }
    
    /**
     * Normalize a string collection by:
     * <ol>
     *   <li>Safely trimming each member.</li>
     *   <li>Converting all empty members to null.</li>
     *   <li>Removing any null members.</li>
     * </ol>
     * 
     * @param values the collection of string values
     * @return the normalized collection of string values
     */
    @Nonnull public static Collection<String> normalizeStringCollection(
            @Nullable @NullableElements final Collection<String> values) {
        DeprecationSupport.warn(ObjectType.CLASS, StringSupport.class.getName(), null,
                net.shibboleth.shared.primitive.StringSupport.class.getName());

        return net.shibboleth.shared.primitive.StringSupport.normalizeStringCollection(values);
    }

    /** Null/empty preserving conversion from xs:boolean to {@link Boolean}.
     * @param what the string: potentially empty or null
     * @return null or the boolean equivalent.
     */
    @Nullable public static Boolean booleanOf(final String what) {
        DeprecationSupport.warn(ObjectType.CLASS, StringSupport.class.getName(), null,
                net.shibboleth.shared.primitive.StringSupport.class.getName());

        return net.shibboleth.shared.primitive.StringSupport.booleanOf(what);
    }
    
}