/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.expression;

import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.spring.expression.AbstractSpringExpressionEvaluator;
import org.slf4j.Logger;
import org.springframework.expression.EvaluationContext;

public class SpringExpressionBiConsumer<T, U>
extends AbstractSpringExpressionEvaluator
implements BiConsumer<T, U> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SpringExpressionBiConsumer.class);
    @Nullable
    private Pair<Class<T>, Class<U>> inputTypes;

    public SpringExpressionBiConsumer(@Nonnull @ParameterName(name="expression") @NotEmpty String expression) {
        super(expression);
    }

    @Nullable
    public Pair<Class<T>, Class<U>> getInputTypes() {
        return this.inputTypes;
    }

    public void setInputTypes(@Nullable Pair<Class<T>, Class<U>> types) {
        this.inputTypes = types != null && types.getFirst() != null && types.getSecond() != null ? types : null;
    }

    @Override
    public void accept(@Nullable T first, @Nullable U second) {
        Pair<Class<T>, Class<U>> types = this.getInputTypes();
        if (null != types) {
            Class intype1 = (Class)types.getFirst();
            Class intype2 = (Class)types.getSecond();
            if (null != first && null != intype1 && !intype1.isInstance(first)) {
                this.log.error("Input of type {} was not of type {}", first.getClass(), (Object)intype1);
                return;
            }
            if (null != second && null != intype2 && !intype2.isInstance(second)) {
                this.log.error("Input of type {} was not of type {}", second.getClass(), (Object)intype2);
                return;
            }
        }
        this.evaluate(first, second);
    }

    @Override
    protected void prepareContext(@Nonnull EvaluationContext context, Object ... input) {
        context.setVariable("input1", input != null ? input[0] : null);
        context.setVariable("input2", input != null ? input[1] : null);
    }
}

