/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.saml.xmlobject.impl;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import net.shibboleth.oidc.saml.xmlobject.DefaultAcrValue;
import net.shibboleth.oidc.saml.xmlobject.MetadataValueSAMLObject;
import net.shibboleth.oidc.saml.xmlobject.OAuthRPExtensions;
import net.shibboleth.oidc.saml.xmlobject.PostLogoutRedirectUri;
import net.shibboleth.oidc.saml.xmlobject.RequestUri;
import net.shibboleth.oidc.saml.xmlobject.impl.DefaultAcrValueBuilder;
import net.shibboleth.oidc.saml.xmlobject.impl.PostLogoutRedirectUriBuilder;
import net.shibboleth.oidc.saml.xmlobject.impl.RequestUriBuilder;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.AbstractSAMLObjectBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class OAuthRPExtensionsTest
extends XMLObjectProviderBaseTestCase {
    public static final String EXTENSION_NAMESPACE = "urn:unknown:namespace";
    public static final QName ATTRIBUTE_EXT_QNAME = new QName("urn:unknown:namespace", "attributeExtension1", "unknown");
    public static final String ATTRIBUTE_EXT_VALUE = "extensionValue1";

    public OAuthRPExtensionsTest() {
        this.childElementsFile = "/net/shibboleth/oidc/saml/xmlobject/impl/OAuthRPExtensions_ordered.xml";
    }

    @Test
    public void testChildElementsMarshall() {
        OAuthRPExtensions rpExtensions = (OAuthRPExtensions)this.buildXMLObject(OAuthRPExtensions.TYPE_NAME);
        rpExtensions.setApplicationType("web");
        rpExtensions.setClientUri("https://example.org/clientUri");
        rpExtensions.getDefaultAcrValues().add((DefaultAcrValue)this.buildMetadataValueObject(new DefaultAcrValueBuilder(), "password"));
        rpExtensions.getDefaultAcrValues().add((DefaultAcrValue)this.buildMetadataValueObject(new DefaultAcrValueBuilder(), "mfa"));
        rpExtensions.setGrantTypes("authorization_code");
        rpExtensions.setIdTokenEncryptedResponseAlg("A256KW");
        rpExtensions.setIdTokenEncryptedResponseEnc("A256GCM");
        rpExtensions.setIdTokenSignedResponseAlg("RS512");
        rpExtensions.setInitiateLoginUri("https://example.org/initiateLogin");
        rpExtensions.getPostLogoutRedirectUris().add((PostLogoutRedirectUri)this.buildMetadataValueObject(new PostLogoutRedirectUriBuilder(), "https://example.org/postLogout"));
        rpExtensions.setRequestObjectEncryptionAlg("A128KW");
        rpExtensions.setRequestObjectEncryptionEnc("A128GCM");
        rpExtensions.setRequestObjectSigningAlg("RS256");
        rpExtensions.getRequestUris().add((RequestUri)this.buildMetadataValueObject(new RequestUriBuilder(), "https://example.org/request"));
        rpExtensions.setResponseTypes("code id_token");
        rpExtensions.setScopes("openid profile");
        rpExtensions.setSoftwareId("mockSoftwareId");
        rpExtensions.setSoftwareVersion("mockSoftwareVersion");
        rpExtensions.setTokenEndpointAuthMethod("client_secret_basic");
        rpExtensions.setTokenEndpointAuthSigningAlg("RS512");
        rpExtensions.setSectorIdentifierUri("https://example.org/sectorIdentifier");
        rpExtensions.setUserInfoEncryptedResponseAlg("A192KW");
        rpExtensions.setUserInfoEncryptedResponseEnc("A192GCM");
        rpExtensions.setUserInfoSignedResponseAlg("RS384");
        rpExtensions.getUnknownAttributes().put(ATTRIBUTE_EXT_QNAME, ATTRIBUTE_EXT_VALUE);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)rpExtensions);
    }

    @Test
    public void testChildElementsUnmarshall() {
        OAuthRPExtensions rpExtensions = (OAuthRPExtensions)this.unmarshallElement("/net/shibboleth/oidc/saml/xmlobject/impl/OAuthRPExtensions.xml");
        String attributeExt = rpExtensions.getUnknownAttributes().get((Object)ATTRIBUTE_EXT_QNAME);
        Assert.assertNotNull((Object)attributeExt);
        Assert.assertEquals((Object)attributeExt, (Object)ATTRIBUTE_EXT_VALUE);
        Assert.assertEquals((String)rpExtensions.getApplicationType(), (String)"web", (String)"The application type did not have expected value");
        Assert.assertEquals((String)rpExtensions.getClientUri(), (String)"https://example.org/clientUri", (String)"The client URI did not have expected value");
        this.assertMetadataValueList(rpExtensions.getDefaultAcrValues(), List.of("password", "mfa"), "The default ACR values did not have expected value");
        Assert.assertEquals((String)rpExtensions.getGrantTypes(), (String)"authorization_code", (String)"The grant types did not have expected value");
        Assert.assertEquals((String)rpExtensions.getIdTokenEncryptedResponseAlg(), (String)"A256KW", (String)"The IDToken encrypted response alg did not have expected value");
        Assert.assertEquals((String)rpExtensions.getIdTokenEncryptedResponseEnc(), (String)"A256GCM", (String)"The IDToken encrypted response enc did not have expected value");
        Assert.assertEquals((String)rpExtensions.getIdTokenSignedResponseAlg(), (String)"RS512", (String)"The IDToken signed response alg did not have expected value");
        Assert.assertEquals((String)rpExtensions.getInitiateLoginUri(), (String)"https://example.org/initiateLogin", (String)"The initiate login URI did not have expected value");
        this.assertMetadataValueList(rpExtensions.getPostLogoutRedirectUris(), List.of("https://example.org/postLogout"), "The post logout redirect URIs did not have expected value");
        Assert.assertEquals((String)rpExtensions.getRequestObjectEncryptionAlg(), (String)"A128KW", (String)"The request object encryption alg did not have expected value");
        Assert.assertEquals((String)rpExtensions.getRequestObjectEncryptionEnc(), (String)"A128GCM", (String)"The request object encryption enc did not have expected value");
        Assert.assertEquals((String)rpExtensions.getRequestObjectSigningAlg(), (String)"RS256", (String)"The request object signing alg did not have expected value");
        this.assertMetadataValueList(rpExtensions.getRequestUris(), List.of("https://example.org/request"), "The request URIs did not have expected value");
        Assert.assertEquals((String)rpExtensions.getResponseTypes(), (String)"code id_token", (String)"The response types did not have expected value");
        Assert.assertEquals((String)rpExtensions.getScopes(), (String)"openid profile", (String)"The scope did not have expected value");
        Assert.assertEquals((String)rpExtensions.getSoftwareId(), (String)"mockSoftwareId", (String)"The software ID did not have expected value");
        Assert.assertEquals((String)rpExtensions.getSoftwareVersion(), (String)"mockSoftwareVersion", (String)"The software version did not have expected value");
        Assert.assertEquals((String)rpExtensions.getTokenEndpointAuthMethod(), (String)"client_secret_basic", (String)"The token endpoint auth method did not have expected value");
        Assert.assertEquals((String)rpExtensions.getTokenEndpointAuthSigningAlg(), (String)"RS512", (String)"The token endpoint auth signing alg did not have expected value");
        Assert.assertEquals((String)rpExtensions.getSectorIdentifierUri(), (String)"https://example.org/sectorIdentifier", (String)"The sector identifier URI did not have expected value");
        Assert.assertEquals((String)rpExtensions.getUserInfoEncryptedResponseAlg(), (String)"A192KW", (String)"The user info encrypted response alg did not have expected value");
        Assert.assertEquals((String)rpExtensions.getUserInfoEncryptedResponseEnc(), (String)"A192GCM", (String)"The user info encrypted response enc did not have expected value");
        Assert.assertEquals((String)rpExtensions.getUserInfoSignedResponseAlg(), (String)"RS384", (String)"The user info signing response alg did not have expected value");
    }

    protected <T extends MetadataValueSAMLObject> void assertMetadataValue(T metadataValue, String expectedValue, String message) {
        Assert.assertEquals((String)metadataValue.getValue(), (String)expectedValue, (String)message);
    }

    protected <T extends MetadataValueSAMLObject> void assertMetadataValueSet(Set<T> metadataValues, Set<T> expectedValues, String message) {
        Set values = metadataValues.stream().map(MetadataValueSAMLObject::getValue).collect(Collectors.toSet());
        Assert.assertEquals(values, expectedValues, (String)message);
    }

    protected <T extends MetadataValueSAMLObject> void assertMetadataValueList(List<T> metadataValues, List<String> expectedValues, String message) {
        List values = metadataValues.stream().map(MetadataValueSAMLObject::getValue).collect(Collectors.toList());
        Assert.assertEquals(values, expectedValues, (String)message);
    }

    protected <T extends MetadataValueSAMLObject, B extends AbstractSAMLObjectBuilder<T>> T buildMetadataValueObject(B builder, String value) {
        MetadataValueSAMLObject object = (MetadataValueSAMLObject)builder.buildObject();
        object.setValue(value);
        return (T)object;
    }

    public void testSingleElementMarshall() {
    }

    public void testSingleElementUnmarshall() {
    }
}

