/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.oidc.saml.xmlobject;

import javax.annotation.Nonnull;

import org.opensaml.saml.common.xml.SAMLConstants;

import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;

/**
 * Constants related to SAML 2.0 Metadata extension OAuthRPRoleDescriptorType.
 */
public final class Constants {

    /** SAML 2.0 Metadata extension for OAuth/OIDC descriptors prefi. */
    public static final String SAML20MDOIDCMD_PREFIX = "oidcmd";

    /** SAML 2.0 Metadata extension for OAuth/OIDC descriptors XML namespace. */
    public static final String SAML20MDOIDCMD_NS = "urn:mace:shibboleth:metadata:oidc:1.0";

    /** SAML 2.0 Metadata extension for OAuth/OIDC descriptors. */
    public static final String SAML20MDOIDCMD_SCHEMA_LOCATION =
            SAMLConstants.SCHEMA_DIR + "saml-metadata-ext-oidcmd.xsd";

    /** OIDC base protocol URI. */
    @Nonnull @NotEmpty public static final String OIDC_PROTOCOL_URI =
            "http://openid.net/specs/openid-connect-core-1_0.html";

    /** Format constant for signaling public "sub" claim in metadata. */
    @Nonnull @NotEmpty public static final String OIDC_SUB_NAMEID_FORMAT_PUBLIC =
            "urn:mace:shibboleth:metadata:oidc:1.0:nameid-format:public";

    /** Format constant for signaling pairwise "sub" claim in metadata. */
    @Nonnull @NotEmpty public static final String OIDC_SUB_NAMEID_FORMAT_PAIRWISE =
            "urn:mace:shibboleth:metadata:oidc:1.0:nameid-format:pairwise";

    /**
     * Constructor.
     */
    private Constants() {
        // no op
    }

}