/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.logic;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.context.OIDCProviderMetadataContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;

public class IssuerIDFromOIDCProviderMetadataContextLookupFunction
implements BiFunction<ProfileRequestContext, JWTClaimsSet, String> {
    @Nonnull
    private Function<ProfileRequestContext, OIDCProviderMetadataContext> oidcMetadataContextLookupStrategy = new ChildContextLookup(OIDCProviderMetadataContext.class).compose((Function)new InboundMessageContextLookup());

    public void setOIDCMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCProviderMetadataContext> strategy) {
        this.oidcMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCMetadataContext lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nonnull ProfileRequestContext prc, @Nullable JWTClaimsSet claimsSet) {
        OIDCProviderMetadataContext oidcMetadataContext = this.oidcMetadataContextLookupStrategy.apply(prc);
        if (oidcMetadataContext == null) {
            return null;
        }
        OIDCProviderMetadata providerInformation = oidcMetadataContext.getProviderInformation();
        if (providerInformation == null || providerInformation.getIssuer() == null) {
            return null;
        }
        return providerInformation.getIssuer().toString();
    }
}

