/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.impl;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.oidc.profile.config.OIDCAuthorizationConfiguration;
import net.shibboleth.oidc.profile.encoder.OIDCMessageEncoder;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AuthenticationRequestMessageEncoderFactory
extends AbstractInitializableComponent
implements Function<ProfileRequestContext, MessageEncoder> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AuthenticationRequestMessageEncoderFactory.class);
    @Nonnull
    @Unmodifiable
    @NotLive
    private final List<OIDCMessageEncoder> encoders;

    public AuthenticationRequestMessageEncoderFactory(@Nullable @ParameterName(name="encoders") List<OIDCMessageEncoder> encodersToUse) {
        this.encoders = encodersToUse == null ? Collections.emptyList() : Collections.unmodifiableList(encodersToUse);
    }

    @Override
    @Nullable
    public MessageEncoder apply(@Nonnull ProfileRequestContext profileRequestContext) {
        RelyingPartyContext rpCtx = (RelyingPartyContext)profileRequestContext.getSubcontext(RelyingPartyContext.class);
        OIDCAuthorizationConfiguration profileConfiguration = null;
        if (rpCtx != null && rpCtx.getProfileConfig() instanceof OIDCAuthorizationConfiguration) {
            profileConfiguration = (OIDCAuthorizationConfiguration)rpCtx.getProfileConfig();
        }
        if (profileConfiguration == null) {
            this.log.warn("OIDCAuthorizationConfiguration not found, no encoders to lookup");
            return null;
        }
        OIDCAuthorizationConfiguration.OIDCHttpRequestMethod requestMethodFromConfig = profileConfiguration.getHttpRequestMethod(profileRequestContext);
        if (requestMethodFromConfig == null) {
            this.log.warn("Authentication request method not found on profile, no encoders to lookup");
            return null;
        }
        Optional<OIDCMessageEncoder> encoder = this.encoders.stream().filter(enc -> enc.test((Object)requestMethodFromConfig)).findFirst();
        if (encoder.isPresent()) {
            this.log.trace("Returning OIDC message encoder of type '{}'", encoder.get().getClass());
        } else {
            this.log.warn("No message encoder was found for authentication request method type '{}'", (Object)requestMethodFromConfig);
        }
        return encoder.orElse(null);
    }
}

