/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.decoding.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.oidc.profile.decoding.OIDCMessageDecoder;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.AbstractHttpServletRequestMessageDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPRedirectAuthnResponseDecoder
extends AbstractHttpServletRequestMessageDecoder
implements OIDCMessageDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPRedirectAuthnResponseDecoder.class);

    protected void doDecode() throws MessageDecodingException {
        this.log.trace("Decoding incomming 'query' authentication response");
        MessageContext messageContext = new MessageContext();
        HttpServletRequest request = this.getHttpServletRequest();
        if (!"GET".equalsIgnoreCase(request.getMethod())) {
            throw new MessageDecodingException("This message decoder only supports the HTTP GET method");
        }
        try {
            AuthenticationResponse inboundMessage = AuthenticationResponseParser.parse((HTTPRequest)ServletUtils.createHTTPRequest((HttpServletRequest)request));
            messageContext.setMessage((Object)inboundMessage);
        }
        catch (ParseException | IOException e) {
            this.log.error("Unable to parse incomming authentication response", e);
        }
        this.setMessageContext(messageContext);
    }
}

