/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.encoder.impl;

import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.net.URI;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.oidc.profile.encoder.impl.HTTPRedirectAuthnRequestEncoder;
import net.shibboleth.utilities.java.support.component.UninitializedComponentException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HTTPRedirectAuthnRequestEncoderTest {
    private HTTPRedirectAuthnRequestEncoder encoder;
    private MockHttpServletResponse mockResponse;
    private OIDCAuthenticationRequest request;
    private MessageContext context;

    @BeforeMethod
    public void setUp() throws Exception {
        this.encoder = new HTTPRedirectAuthnRequestEncoder();
        this.context = new MessageContext();
        this.request = new OIDCAuthenticationRequest(new ClientID("clientID"));
        this.request.setResponseType(ResponseType.CODE);
        this.request.setEndpointURI(new URI("https://somewhere.com/oauth2/authz"));
        this.request.setRedirectURI(new URI("https://localhost:8080/callback"));
        this.context.setMessage((Object)this.request);
        this.encoder.setMessageContext(this.context);
        this.mockResponse = new MockHttpServletResponse();
        this.encoder.setHttpServletResponse((HttpServletResponse)this.mockResponse);
    }

    @Test
    public void testSuccesfullEncoding() throws Exception {
        this.encoder.initialize();
        this.encoder.encode();
        String response = this.mockResponse.getRedirectedUrl();
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.contains("client_id"));
        Assert.assertTrue((boolean)response.contains("response_type"));
        Assert.assertTrue((boolean)response.contains("client_id"));
        Assert.assertTrue((boolean)response.contains("scope"));
    }

    @Test(expectedExceptions={UninitializedComponentException.class})
    public void testUninitialized() throws MessageEncodingException {
        this.encoder.encode();
    }

    @Test(expectedExceptions={MessageEncodingException.class})
    public void testNullEndpointURL() throws Exception {
        this.request = new OIDCAuthenticationRequest(new ClientID("clientID"));
        this.context.setMessage((Object)this.request);
        this.encoder.initialize();
        this.encoder.encode();
    }
}

