/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.oauth2.config;

import java.time.Duration;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.oauth2.config.AbstractOAuth2TokenValidatingConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class OAuth2TokenRevocationConfiguration
extends AbstractOAuth2TokenValidatingConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROTOCOL_URI = "https://tools.ietf.org/html/rfc7009";
    @Nonnull
    @NotEmpty
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/oauth2/revocation";
    @Nonnull
    private Function<ProfileRequestContext, String> revocationMethodLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Duration> revocationLifetimeLookupStrategy;

    public OAuth2TokenRevocationConfiguration() {
        this(PROFILE_ID);
        this.revocationMethodLookupStrategy = FunctionSupport.constant((Object)OAuth2TokenRevocationMethod.CHAIN.toString());
        this.revocationLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofHours(6L));
    }

    public OAuth2TokenRevocationConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    public void setRevocationMethodLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.revocationMethodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setRevocationMethod(@Nonnull @NotEmpty OAuth2TokenRevocationMethod method) {
        this.revocationMethodLookupStrategy = FunctionSupport.constant((Object)(method != null ? method.toString() : null));
    }

    public OAuth2TokenRevocationMethod getRevocationMethod(@Nullable ProfileRequestContext profileRequestContext) {
        String method = this.revocationMethodLookupStrategy.apply(profileRequestContext);
        if (method != null) {
            try {
                return OAuth2TokenRevocationMethod.valueOf(method);
            }
            catch (IllegalArgumentException e) {
                throw new ConstraintViolationException("Unexpected revocation method value: '" + method + "': " + e.getMessage());
            }
        }
        return null;
    }

    public void setRevocationLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.revocationLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @Positive
    public Duration getRevocationLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.revocationLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Revocation lifetime must be greater than 0");
        return lifetime;
    }

    public void setRevocationLifetime(@Nonnull @Positive Duration lifetime) {
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Revocation lifetime must be greater than 0");
        this.revocationLifetimeLookupStrategy = FunctionSupport.constant((Object)lifetime);
    }

    public static enum OAuth2TokenRevocationMethod {
        CHAIN,
        TOKEN;

    }
}

