/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.oauth2.config;

import com.google.common.base.Predicates;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.idp.profile.config.AbstractConditionalProfileConfiguration;
import net.shibboleth.oidc.authn.principal.AuthenticationContextClassReferencePrincipal;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2ProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractOAuth2ClientAuthenticableProfileConfiguration
extends AbstractConditionalProfileConfiguration
implements OAuth2ProfileConfiguration,
AuthenticationProfileConfiguration {
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> tokenEndpointAuthMethodsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, ClaimsValidator> claimsValidatorLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> forceAuthnPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Integer> proxyCountLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<AuthenticationContextClassReferencePrincipal>> defaultAuthenticationContextsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> authenticationFlowsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> postAuthenticationFlowsLookupStrategy;

    protected AbstractOAuth2ClientAuthenticableProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setTokenEndpointAuthMethods(Set.of(ClientAuthenticationMethod.CLIENT_SECRET_BASIC.toString(), ClientAuthenticationMethod.CLIENT_SECRET_POST.toString(), ClientAuthenticationMethod.CLIENT_SECRET_JWT.toString(), ClientAuthenticationMethod.PRIVATE_KEY_JWT.toString()));
        this.claimsValidatorLookupStrategy = FunctionSupport.constant(null);
        this.forceAuthnPredicate = Predicates.alwaysFalse();
        this.proxyCountLookupStrategy = FunctionSupport.constant(null);
        this.defaultAuthenticationContextsLookupStrategy = FunctionSupport.constant(null);
        this.authenticationFlowsLookupStrategy = FunctionSupport.constant(null);
        this.postAuthenticationFlowsLookupStrategy = FunctionSupport.constant(null);
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getTokenEndpointAuthMethods(@Nullable ProfileRequestContext profileRequestContext) {
        Collection methods = this.tokenEndpointAuthMethodsLookupStrategy.apply(profileRequestContext);
        if (methods != null) {
            return Set.copyOf(methods);
        }
        return Collections.emptySet();
    }

    public void setTokenEndpointAuthMethods(@Nonnull @NonnullElements Collection<String> methods) {
        Constraint.isNotNull(methods, (String)"Collection of methods cannot be null");
        this.tokenEndpointAuthMethodsLookupStrategy = methods != null ? FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(methods))) : FunctionSupport.constant(null);
    }

    public void setTokenEndpointAuthMethodsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.tokenEndpointAuthMethodsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public ClaimsValidator getClaimsValidator(@Nullable ProfileRequestContext profileRequestContext) {
        return this.claimsValidatorLookupStrategy.apply(profileRequestContext);
    }

    public void setClaimsValidator(@Nullable ClaimsValidator validator) {
        this.claimsValidatorLookupStrategy = FunctionSupport.constant((Object)validator);
    }

    public void setClaimsValidatorLookupStrategy(@Nonnull Function<ProfileRequestContext, ClaimsValidator> strategy) {
        this.claimsValidatorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isForceAuthn(@Nullable ProfileRequestContext profileRequestContext) {
        return this.forceAuthnPredicate.test(profileRequestContext);
    }

    public void setForceAuthn(boolean flag) {
        this.forceAuthnPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setForceAuthnPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.forceAuthnPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Forced authentication predicate cannot be null");
    }

    @Nullable
    public Integer getProxyCount(@Nullable ProfileRequestContext profileRequestContext) {
        Integer count = this.proxyCountLookupStrategy.apply(profileRequestContext);
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        return count;
    }

    public void setProxyCount(@Nullable @NonNegative Integer count) {
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        this.proxyCountLookupStrategy = FunctionSupport.constant((Object)count);
    }

    public void setProxyCountLookupStrategy(@Nonnull Function<ProfileRequestContext, Integer> strategy) {
        this.proxyCountLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> flows = this.authenticationFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return Set.copyOf(flows);
        }
        return Collections.emptySet();
    }

    public void setAuthenticationFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.authenticationFlowsLookupStrategy = flows != null ? FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    public void setAuthenticationFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.authenticationFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getPostAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> flows = this.postAuthenticationFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return List.copyOf(flows);
        }
        return Collections.emptyList();
    }

    public void setPostAuthenticationFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.postAuthenticationFlowsLookupStrategy = flows != null ? FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    public void setPostAuthenticationFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.postAuthenticationFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<Principal> getDefaultAuthenticationMethods(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<AuthenticationContextClassReferencePrincipal> methods = this.defaultAuthenticationContextsLookupStrategy.apply(profileRequestContext);
        if (methods != null) {
            return List.copyOf(methods);
        }
        return Collections.emptyList();
    }

    public void setDefaultAuthenticationMethods(@Nullable @NonnullElements Collection<AuthenticationContextClassReferencePrincipal> contexts) {
        this.defaultAuthenticationContextsLookupStrategy = contexts != null ? FunctionSupport.constant(List.copyOf(contexts)) : FunctionSupport.constant(null);
    }

    public void setDefaultAuthenticationMethodsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<AuthenticationContextClassReferencePrincipal>> strategy) {
        this.defaultAuthenticationContextsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

