/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.core;

import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.Display;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.Prompt;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class OAuthAuthorizationRequest {
    @Nonnull
    private final ClientID clientID;
    @Nullable
    private State state;
    @Nullable
    private URI redirectURI;
    @Nullable
    private ResponseType responseType;
    @Nullable
    private URI endpointURI;
    @Nullable
    private Nonce nonce;
    @Nonnull
    private final Scope scope;
    @Nullable
    private Display display;
    @Nullable
    private Prompt prompt;
    @Nullable
    private Duration maxAge;
    @Nonnull
    @NotLive
    private List<ACR> acrs;
    @Nullable
    private ResponseMode responseMode;

    public OAuthAuthorizationRequest(@Nonnull ClientID id) {
        this.clientID = (ClientID)Constraint.isNotNull((Object)id, (String)"ClientID can not be null");
        this.acrs = Collections.emptyList();
        this.scope = new Scope();
    }

    @Nonnull
    public ClientID getClientID() {
        return this.clientID;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    public void setState(@Nullable State theState) {
        this.state = theState;
    }

    @Nullable
    public URI getRedirectURI() {
        return this.redirectURI;
    }

    public void setRedirectURI(@Nonnull URI uri) {
        this.redirectURI = (URI)Constraint.isNotNull((Object)uri, (String)"RedirectURI can not be null");
    }

    @Nullable
    public ResponseType getResponseType() {
        return this.responseType;
    }

    public void setResponseType(@Nonnull ResponseType type) {
        this.responseType = (ResponseType)Constraint.isNotNull((Object)type, (String)"ResponseType can not be null");
    }

    @Nullable
    public URI getEndpointURI() {
        return this.endpointURI;
    }

    public void setEndpointURI(@Nonnull URI uri) {
        this.endpointURI = (URI)Constraint.isNotNull((Object)uri, (String)"EndpointURI can not be null");
    }

    @Nullable
    public Nonce getNonce() {
        return this.nonce;
    }

    public void setNonce(@Nullable Nonce theNonce) {
        this.nonce = theNonce;
    }

    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    @Nullable
    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(@Nullable Display theDisplay) {
        this.display = theDisplay;
    }

    @Nullable
    public Prompt getPrompt() {
        return this.prompt;
    }

    public void setPrompt(@Nullable Prompt thePrompt) {
        this.prompt = thePrompt;
    }

    @Nullable
    public Duration getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(@Nullable Duration max) {
        this.maxAge = max;
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<ACR> getAcrs() {
        return Collections.unmodifiableList(this.acrs);
    }

    public void setAcrs(@Nullable List<ACR> theAcrs) {
        if (theAcrs != null) {
            this.acrs = Collections.unmodifiableList(theAcrs);
        }
    }

    @Nullable
    public ResponseMode getResponseMode() {
        return this.responseMode;
    }

    public void setResponseMode(@Nullable ResponseMode mode) {
        this.responseMode = mode;
    }
}

