/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.navigate;

import java.time.Duration;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.AbstractRelyingPartyLookupFunction;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2TokenRevocationConfiguration;
import org.opensaml.profile.context.ProfileRequestContext;

public class RevocationLifetimeLookupFunction
extends AbstractRelyingPartyLookupFunction<Duration> {
    private boolean activeProfileOnly = true;

    public void setUseActiveProfileOnly(boolean flag) {
        this.activeProfileOnly = flag;
    }

    @Nullable
    public Duration apply(@Nullable ProfileRequestContext input) {
        RelyingPartyContext rpc = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null) {
            ProfileConfiguration pc;
            ProfileConfiguration profileConfiguration = pc = this.activeProfileOnly ? rpc.getProfileConfig() : rpc.getConfiguration().getProfileConfiguration(input, "http://shibboleth.net/ns/profiles/oauth2/revocation");
            if (pc instanceof OAuth2TokenRevocationConfiguration) {
                return ((OAuth2TokenRevocationConfiguration)pc).getRevocationLifetime(input);
            }
        }
        return null;
    }
}

