/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.navigate;

import com.nimbusds.oauth2.sdk.GrantType;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.AbstractRelyingPartyLookupFunction;
import net.shibboleth.oidc.profile.config.OIDCAuthorizationConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2TokenConfiguration;
import org.opensaml.profile.context.ProfileRequestContext;

public class GrantTypesLookupFunction
extends AbstractRelyingPartyLookupFunction<Set<GrantType>> {
    @Nullable
    public Set<GrantType> apply(@Nullable ProfileRequestContext input) {
        RelyingPartyContext rpc = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null) {
            ProfileConfiguration pc = rpc.getProfileConfig();
            if (pc instanceof OAuth2TokenConfiguration) {
                Set<String> types = ((OAuth2TokenConfiguration)pc).getGrantTypes(input);
                if (types != null) {
                    return types.stream().map(GrantType::new).collect(Collectors.toUnmodifiableSet());
                }
            } else if (pc instanceof OIDCAuthorizationConfiguration) {
                return Set.of(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN);
            }
        }
        return null;
    }
}

