/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.navigate;

import java.time.Duration;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.AbstractRelyingPartyLookupFunction;
import net.shibboleth.oidc.profile.config.AbstractOIDCSSOConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2TokenAudienceConfiguration;
import org.opensaml.profile.context.ProfileRequestContext;

public class AccessTokenLifetimeLookupFunction
extends AbstractRelyingPartyLookupFunction<Duration> {
    @Nullable
    public Duration apply(@Nullable ProfileRequestContext input) {
        RelyingPartyContext rpc = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null) {
            ProfileConfiguration pc = rpc.getProfileConfig();
            if (pc instanceof AbstractOIDCSSOConfiguration) {
                return ((AbstractOIDCSSOConfiguration)pc).getAccessTokenLifetime(input);
            }
            if (pc instanceof OAuth2TokenAudienceConfiguration) {
                return ((OAuth2TokenAudienceConfiguration)pc).getAccessTokenLifetime(input);
            }
        }
        return null;
    }
}

