/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.logic;

import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.logic.AbstractRelyingPartyPredicate;
import net.shibboleth.oidc.profile.config.AbstractOIDCSSOConfiguration;
import net.shibboleth.oidc.profile.config.OIDCUserInfoConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2TokenAudienceConfiguration;
import org.opensaml.profile.context.ProfileRequestContext;

public class EncryptionOptionalPredicate
extends AbstractRelyingPartyPredicate {
    public boolean test(@Nullable ProfileRequestContext input) {
        RelyingPartyContext rpc = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null) {
            ProfileConfiguration pc = rpc.getProfileConfig();
            if (pc instanceof AbstractOIDCSSOConfiguration) {
                return ((AbstractOIDCSSOConfiguration)pc).isEncryptionOptional(input);
            }
            if (pc instanceof OIDCUserInfoConfiguration) {
                return ((OIDCUserInfoConfiguration)pc).isEncryptionOptional(input);
            }
            if (pc instanceof OAuth2TokenAudienceConfiguration) {
                return ((OAuth2TokenAudienceConfiguration)pc).isEncryptionOptional(input);
            }
        }
        return false;
    }
}

