/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config;

import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.AttributeResolvingProfileConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.AbstractOAuth2TokenValidatingConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class OIDCUserInfoConfiguration
extends AbstractOAuth2TokenValidatingConfiguration
implements AttributeResolvingProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROTOCOL_URI = "http://openid.net/specs/openid-connect-core-1_0.html";
    @Nonnull
    @NotEmpty
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/oidc/userinfo";
    @Nonnull
    private Predicate<ProfileRequestContext> resolveAttributesPredicate = Predicates.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> encryptionOptionalPredicate = Predicates.alwaysTrue();
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> deniedUserInfoAttributesLookupStrategy = FunctionSupport.constant(null);

    public OIDCUserInfoConfiguration() {
        this(PROFILE_ID);
    }

    public OIDCUserInfoConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    public boolean isResolveAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return this.resolveAttributesPredicate.test(profileRequestContext);
    }

    public void setResolveAttributes(boolean flag) {
        this.resolveAttributesPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setResolveAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.resolveAttributesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Resolve attributes predicate cannot be null");
    }

    public boolean isEncryptionOptional(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encryptionOptionalPredicate.test(profileRequestContext);
    }

    public void setEncryptionOptional(boolean flag) {
        this.encryptionOptionalPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setEncryptionOptionalPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.encryptionOptionalPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Encryption optional predicate cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    public Set<String> getDeniedUserInfoAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> attributes = this.deniedUserInfoAttributesLookupStrategy.apply(profileRequestContext);
        if (attributes != null) {
            return Set.copyOf(attributes);
        }
        return Collections.emptySet();
    }

    public void setDeniedUserInfoAttributes(@Nullable @NonnullElements Collection<String> attributes) {
        this.deniedUserInfoAttributesLookupStrategy = attributes == null || attributes.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(attributes)));
    }

    public void setDeniedUserInfoAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.deniedUserInfoAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

