/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.AbstractConditionalProfileConfiguration;
import net.shibboleth.idp.profile.config.OverriddenIssuerProfileConfiguration;
import net.shibboleth.oidc.profile.config.OIDCProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class OIDCProviderInformationConfiguration
extends AbstractConditionalProfileConfiguration
implements OIDCProfileConfiguration,
OverriddenIssuerProfileConfiguration {
    public static final String PROTOCOL_URI = "http://openid.net/specs/openid-connect-discovery-1_0.html";
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/oidc/configuration";
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = FunctionSupport.constant(null);

    public OIDCProviderInformationConfiguration() {
        this(PROFILE_ID);
    }

    public OIDCProviderInformationConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Nullable
    @NotEmpty
    public String getIssuer(@Nullable ProfileRequestContext profileRequestContext) {
        return this.issuerLookupStrategy.apply(profileRequestContext);
    }

    public void setIssuer(@Nullable @NotEmpty String issuer) {
        this.issuerLookupStrategy = FunctionSupport.constant((Object)issuer);
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }
}

