/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config;

import com.google.common.base.Predicates;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.idp.profile.config.OverriddenIssuerProfileConfiguration;
import net.shibboleth.oidc.profile.config.AbstractOIDCSSOConfiguration;
import net.shibboleth.oidc.profile.config.OIDCProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class OIDCAuthorizationConfiguration
extends AbstractOIDCSSOConfiguration
implements OIDCProfileConfiguration,
AuthenticationProfileConfiguration,
OverriddenIssuerProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/oidc/sso/browser";
    @Nonnull
    private Predicate<ProfileRequestContext> acrRequestAlwaysEssentialPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> encodeConsentInTokensPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Function<ProfileRequestContext, Duration> authorizeCodeLifetimeLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> encodedAttributesLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> useRequestObjectPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> deniedUserInfoAttributesLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> includeIssuerInResponsePredicate;
    @Nonnull
    private Function<ProfileRequestContext, String> httpRequestMethodLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> authorizationCodeClaimsSetManipulationStrategyLookupStrategy;

    public OIDCAuthorizationConfiguration() {
        this(PROFILE_ID);
    }

    public OIDCAuthorizationConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.authorizeCodeLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofMinutes(5L));
        this.encodedAttributesLookupStrategy = FunctionSupport.constant(null);
        this.deniedUserInfoAttributesLookupStrategy = FunctionSupport.constant(null);
        this.httpRequestMethodLookupStrategy = FunctionSupport.constant((Object)OIDCHttpRequestMethod.GET.toString());
        this.includeIssuerInResponsePredicate = Predicates.alwaysFalse();
        this.authorizationCodeClaimsSetManipulationStrategyLookupStrategy = FunctionSupport.constant(null);
    }

    public boolean isAcrRequestAlwaysEssential(@Nullable ProfileRequestContext profileRequestContext) {
        return this.acrRequestAlwaysEssentialPredicate.test(profileRequestContext);
    }

    public void setAcrRequestAlwaysEssential(boolean flag) {
        this.acrRequestAlwaysEssentialPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setAcrRequestAlwaysEssentialPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.acrRequestAlwaysEssentialPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public boolean isUseRequestObject(@Nullable ProfileRequestContext profileRequestContext) {
        return this.useRequestObjectPredicate.test(profileRequestContext);
    }

    public void setUseRequestObject(boolean flag) {
        this.useRequestObjectPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setUseRequestObjectPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.useRequestObjectPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Use request object condition cannot be null");
    }

    public boolean isEncodeConsentInTokens(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encodeConsentInTokensPredicate.test(profileRequestContext);
    }

    public void setEncodeConsentInTokens(boolean flag) {
        this.encodeConsentInTokensPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setEncodeConsentInTokensPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.encodeConsentInTokensPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    @Nonnull
    @Positive
    public Duration getAuthorizeCodeLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.authorizeCodeLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Authorization code lifetime must be greater than 0");
        return lifetime;
    }

    public void setAuthorizeCodeLifetime(@Nonnull @Positive Duration lifetime) {
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Authorization code lifetime must be greater than 0");
        this.authorizeCodeLifetimeLookupStrategy = FunctionSupport.constant((Object)lifetime);
    }

    public void setAuthorizeCodeLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.authorizeCodeLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setHttpRequestMethodLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.httpRequestMethodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"HTTP request method strategy can not be null");
    }

    public void setHttpRequestMethod(@Nonnull @NotEmpty OIDCHttpRequestMethod method) {
        this.httpRequestMethodLookupStrategy = FunctionSupport.constant((Object)(method != null ? method.toString() : null));
    }

    public OIDCHttpRequestMethod getHttpRequestMethod(@Nullable ProfileRequestContext profileRequestContext) {
        String method = this.httpRequestMethodLookupStrategy.apply(profileRequestContext);
        if (method != null) {
            try {
                return OIDCHttpRequestMethod.valueOf(method);
            }
            catch (IllegalArgumentException e) {
                throw new ConstraintViolationException("Unexpected HTTP method value: '" + method + "': " + e.getMessage());
            }
        }
        return null;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    public Set<String> getEncodedAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> attributes = this.encodedAttributesLookupStrategy.apply(profileRequestContext);
        if (attributes != null) {
            return Set.copyOf(attributes);
        }
        return Collections.emptySet();
    }

    public void setEncodedAttributes(@Nullable @NonnullElements Collection<String> attributes) {
        this.encodedAttributesLookupStrategy = attributes == null || attributes.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(attributes)));
    }

    public void setEncodedAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.encodedAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    public Set<String> getDeniedUserInfoAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> attributes = this.deniedUserInfoAttributesLookupStrategy.apply(profileRequestContext);
        if (attributes != null) {
            return Set.copyOf(attributes);
        }
        return Collections.emptySet();
    }

    public void setDeniedUserInfoAttributes(@Nullable @NonnullElements Collection<String> attributes) {
        this.deniedUserInfoAttributesLookupStrategy = attributes == null || attributes.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(attributes)));
    }

    public void setDeniedUserInfoAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.deniedUserInfoAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isIncludeIssuerInResponse(@Nullable ProfileRequestContext profileRequestContext) {
        return this.includeIssuerInResponsePredicate.test(profileRequestContext);
    }

    public void setIncludeIssuerInResponse(boolean flag) {
        this.includeIssuerInResponsePredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setIncludeIssuerInResponsePredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.includeIssuerInResponsePredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    @Nonnull
    public BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> getAuthorizationCodeClaimsSetManipulationStrategy(@Nullable ProfileRequestContext profileRequestContext) {
        return this.authorizationCodeClaimsSetManipulationStrategyLookupStrategy.apply(profileRequestContext);
    }

    public void setAuthorizationCodeClaimsSetManipulationStrategy(@Nullable BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> strategy) {
        this.authorizationCodeClaimsSetManipulationStrategyLookupStrategy = FunctionSupport.constant(strategy);
    }

    public void setAuthorizationCodeClaimsSetManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        this.authorizationCodeClaimsSetManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public static enum OIDCHttpRequestMethod {
        GET,
        POST;

    }
}

