/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.authn.principal;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.principal.CloneablePrincipal;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public final class AuthenticationContextClassReferencePrincipal
implements CloneablePrincipal {
    public static final String UNSPECIFIED = "net.shibboleth.idp.oidc.authn.principal.string.unspecified";
    @Nonnull
    @NotEmpty
    private String authnContextClassReference;

    public AuthenticationContextClassReferencePrincipal(@Nonnull @ParameterName(name="classRef") @NotEmpty String classRef) {
        this.authnContextClassReference = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)classRef), (String)"AuthnContextClassRef cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getName() {
        return this.authnContextClassReference;
    }

    public int hashCode() {
        return this.authnContextClassReference.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof AuthenticationContextClassReferencePrincipal) {
            return this.authnContextClassReference.equals(((AuthenticationContextClassReferencePrincipal)other).getName());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("authnContextClassReference", (Object)this.authnContextClassReference).toString();
    }

    public AuthenticationContextClassReferencePrincipal clone() throws CloneNotSupportedException {
        AuthenticationContextClassReferencePrincipal copy = (AuthenticationContextClassReferencePrincipal)super.clone();
        copy.authnContextClassReference = this.authnContextClassReference;
        return copy;
    }
}

