/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.policy.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.cache.CacheLoadingContext;
import net.shibboleth.oidc.metadata.cache.CacheLoadingException;
import net.shibboleth.oidc.metadata.cache.impl.DefaultFileLoadingStrategy;
import net.shibboleth.oidc.metadata.criterion.ResourceLocationCriterion;
import net.shibboleth.oidc.metadata.impl.AbstractDynamicHTTPFetchingStrategy;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class MetadataPolicyViaLocationFetchingStrategy
extends AbstractDynamicHTTPFetchingStrategy<Map<String, MetadataPolicy>>
implements Function<CriteriaSet, Map<String, MetadataPolicy>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MetadataPolicyViaLocationFetchingStrategy.class);
    @NonnullAfterInit
    private Function<byte[], List<Map<String, MetadataPolicy>>> parsingStrategy;

    public MetadataPolicyViaLocationFetchingStrategy(HttpClient client, ResponseHandler<Map<String, MetadataPolicy>> handler) {
        super(client, handler);
    }

    public void setParsingStrategy(@Nonnull Function<byte[], List<Map<String, MetadataPolicy>>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.parsingStrategy = (Function)Constraint.isNotNull(strategy, (String)"Parsing strategy cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.parsingStrategy == null) {
            throw new ComponentInitializationException("Parsing strategy cannot be null");
        }
    }

    @Override
    @Nullable
    public Map<String, MetadataPolicy> apply(@Nonnull CriteriaSet criteriaSet) {
        byte[] loadedPolicy;
        String requestURL = this.buildRequestURL(criteriaSet);
        if (requestURL == null) {
            return null;
        }
        if (requestURL.startsWith("http://") || requestURL.startsWith("https://")) {
            return (Map)super.apply(criteriaSet);
        }
        String fileLocation = requestURL.startsWith("file:") ? requestURL.substring(5) : requestURL;
        CacheLoadingContext context = new CacheLoadingContext(null, null);
        FileSystemResource resource = new FileSystemResource(fileLocation);
        try {
            DefaultFileLoadingStrategy loadingStrategy = new DefaultFileLoadingStrategy((Resource)resource);
            loadedPolicy = loadingStrategy.load(context);
            if (loadedPolicy == null) {
                this.log.error("Could not load any entries via loading strategy");
                return null;
            }
        }
        catch (IOException | CacheLoadingException e) {
            this.log.error("Could not load a metadata policy from file {}", (Object)fileLocation, (Object)e);
            return null;
        }
        List<Map<String, MetadataPolicy>> result = this.parsingStrategy.apply(loadedPolicy);
        if (result == null || result.isEmpty()) {
            this.log.warn("Could not find any entries via parsing strategy");
            return null;
        }
        if (result.size() > 1) {
            this.log.warn("More than one metadata policies found, returning first of the list.");
        }
        return result.get(0);
    }

    @Override
    protected String buildRequestURL(CriteriaSet criteria) {
        if (criteria == null || criteria.isEmpty()) {
            return null;
        }
        ResourceLocationCriterion criterion = (ResourceLocationCriterion)criteria.get(ResourceLocationCriterion.class);
        return criterion == null ? null : criterion.getResourceLocation();
    }
}

