/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.policy.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.impl.MetadataPolicyViaLocationFetchingStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class DefaultMetadataPolicyResponseHandler
extends AbstractIdentifiableInitializableComponent
implements ResponseHandler<Map<String, MetadataPolicy>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultMetadataPolicyResponseHandler.class);
    @NonnullAfterInit
    private Function<byte[], List<Map<String, MetadataPolicy>>> parsingStrategy;

    public void setParsingStrategy(@Nonnull Function<byte[], List<Map<String, MetadataPolicy>>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.parsingStrategy = (Function)Constraint.isNotNull(strategy, (String)"Parsing strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.parsingStrategy == null) {
            throw new ComponentInitializationException("Parsing strategy cannot be null");
        }
    }

    @Nullable
    public Map<String, MetadataPolicy> handleResponse(HttpResponse response) throws IOException {
        List<Map<String, MetadataPolicy>> parsedResponse;
        int httpStatusCode = response.getStatusLine().getStatusCode();
        String currentRequestURI = MDC.get((String)MetadataPolicyViaLocationFetchingStrategy.MDC_ATTRIB_CURRENT_REQUEST_URI);
        if (httpStatusCode != 200) {
            this.log.warn("Non-ok status code '{}' returned from remote metadata source: {}", (Object)httpStatusCode, (Object)currentRequestURI);
            return null;
        }
        try {
            parsedResponse = this.parsingStrategy.apply(EntityUtils.toByteArray((HttpEntity)response.getEntity()));
        }
        catch (Exception e) {
            this.log.error("Error parsing HTTP response stream", (Throwable)e);
            return null;
        }
        if (parsedResponse == null || parsedResponse.isEmpty()) {
            this.log.error("No parsed values found from the response.");
            return null;
        }
        if (parsedResponse.size() > 1) {
            this.log.warn("More than one metadata policies found, returning first of the list.");
        }
        return parsedResponse.get(0);
    }
}

