/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.io.IOException;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.ClientInformationManager;
import net.shibboleth.oidc.metadata.ClientInformationManagerException;
import net.shibboleth.oidc.metadata.impl.BaseStorageServiceClientInformationComponent;
import net.shibboleth.oidc.metadata.impl.StorageServiceClientInformationResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageServiceClientInformationManager
extends BaseStorageServiceClientInformationComponent
implements ClientInformationManager {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StorageServiceClientInformationResolver.class);

    public void storeClientInformation(@Nonnull OIDCClientInformation clientInformation, @Nullable Instant expiration, boolean replace) throws ClientInformationManagerException {
        block4: {
            this.log.debug("Attempting to store client information (replace={})", (Object)(replace ? "true" : "false"));
            String clientId = clientInformation.getID().getValue();
            String serialized = clientInformation.toJSONObject().toJSONString();
            try {
                if (this.getStorageService().create("oidcClientInformation", clientId, serialized, expiration != null ? Long.valueOf(expiration.toEpochMilli()) : null)) {
                    this.log.info("Successfully stored the client information for ID {}", (Object)clientId);
                    break block4;
                }
                if (replace) {
                    this.getStorageService().update("oidcClientInformation", clientId, serialized, expiration != null ? Long.valueOf(expiration.toEpochMilli()) : null);
                    break block4;
                }
                throw new ClientInformationManagerException("Attempt to store duplicate client information for ID " + clientId);
            }
            catch (IOException e) {
                throw new ClientInformationManagerException("Could not store the client information", (Exception)e);
            }
        }
    }

    @Deprecated
    public void storeClientInformation(@Nonnull OIDCClientInformation clientInformation, @Nullable Instant expiration) throws ClientInformationManagerException {
        this.storeClientInformation(clientInformation, expiration, false);
    }

    public void destroyClientInformation(ClientID clientId) {
        if (clientId == null) {
            this.log.warn("The null clientId cannot be destroyed, nothing to do");
            return;
        }
        try {
            this.getStorageService().delete("oidcClientInformation", clientId.getValue());
        }
        catch (IOException e) {
            this.log.error("Could not delete the client ID {}", (Object)clientId.getValue(), (Object)e);
        }
    }
}

